

#if !defined __DHFX_H
#define __DHFX_H

#include "fxman.h"
#include "gfx.h"

#include "darkman.h"
#include "darkstrg.h"

#define COL_NULL            0
#define COL_OBJECT          1
#define COL_SHIELDS         2

#define PROPERTY_NONE       0

#define DEFAULT_FX_BLAST_TIME   1                   // seconds


/* *************************************************************
************************************************************* */
class fx_link : public dbl_llist {

   public:
      fx_type *link;
      
      virtual ~fx_link() {}
};

      
/* *************************************************************
************************************************************* */
class ammo_type : public fx_type {

   protected:
      unsigned int properties;
      int          damage;

      int atom_vs_lineseg(atom_list_type *obstacle, float *midpt, float rad, float *ray, float *start, target_type *victim, float *pos, int *col_type);
      int subobject_vs_lineseg(quark *specific_target, quark *obstacle, quark *parent, float *midpt, float rad, float *start, float *end, int level, target_type *victim, float *pos, float *normal, int *col_type);
      int specific_object_vs_lineseg(quark *obstacle, float *midpt, float rad, float *ray, float *start, float *end, int level, target_type *victim, float *pos, float *normal, int *col_type);
      int object_vs_lineseg(quark *specific_target, atom_list_type *obstacle, float *midpt, float rad, float *ray, float *start, float *end, int level, target_type *victim, float *pos, float *normal, int *col_type);

      virtual void damage_target(gameatom *tree, quark *target, quark *tparent, quark *parent, float *pos, vector4f *mx);

   public:
      // superclass
      int  query_whatami() { return OBJECT_AMMO_TYPE; }
      int  query_whatwasi(int type);

      // fx_type
      void init() { fx_type::init(); properties = PROPERTY_NONE; }

      // ammo_type
      virtual ~ammo_type() {}
};


/* *************************************************************
************************************************************* */
class lazer : public ammo_type {

   protected:
      void process_intel();

      virtual void process_collision(target_type *target, float *pos, float *normal, int *col_type);
      virtual int post_rotate();
      
   public:
      float    speed, dist_scale, time_scale;
      vector3f dir;
      vector4f end;                 // tail of lazer, behind head
      float    distance;
      texbase  *death_tob;
      target_type specific_target;

      // superclass
      int  query_whatami() { return OBJECT_LAZER; }
      int  query_whatwasi(int type);
      void preprocess(void *data);

      // quark
      void whereami(dbl_llist_manager *hiearchy_manager, quark *parent, vector4f *mx);
      void update(dbl_llist_manager *hiearchy_manager, quark *parent);

      // fx_type
      void init() { ammo_type::init(); }      // keeps the compiler from being confused...

      // lazer
      lazer();
      virtual ~lazer() {}

      void init(atom_list_type *source, float dist, float spd, int dam, float *oclock, float *offset, vector4f *mx, texbase *tob, target_type *target);
};


/* *************************************************************
************************************************************* */
class fx_lazer_launcher : public fx_launcher {

   public:
      int query_whatami() { return OBJECT_LAZER; }
      char *query_name()  { return TOKEN_LAZER_STR; }
      fx_type *launch()   { return new lazer; }

      virtual ~fx_lazer_launcher() {}
};


/* *************************************************************
************************************************************* */
class lazer2blu : public lazer {

   protected:
      int post_rotate();

      gameatom *cam;
      void fail_rotate();
      
   public:

      // superclass
      int  query_whatami() { return OBJECT_LAZER2BLU; }
      int  query_whatwasi(int type);
      void preprocess(void *data);

      // fx_type
      void init();

      virtual ~lazer2blu() {}
};


/* *************************************************************
************************************************************* */
class fx_lazer2blu_launcher : public fx_launcher {

   public:
      int query_whatami() { return OBJECT_LAZER2BLU; }
      char *query_name()  { return TOKEN_LAZER2BLU_STR; }
      fx_type *launch()   { return new lazer2blu; }

      virtual ~fx_lazer2blu_launcher() {}
};


/* *************************************************************
************************************************************* */
class lazer2red : public lazer2blu {

   public:

      // superclass
      int  query_whatami() { return OBJECT_LAZER2RED; }
      int  query_whatwasi(int type);
      void preprocess(void *data);

      virtual ~lazer2red() {}
};


/* *************************************************************
************************************************************* */
class fx_lazer2red_launcher : public fx_launcher {

   public:
      int query_whatami() { return OBJECT_LAZER2RED; }
      char *query_name()  { return TOKEN_LAZER2RED_STR; }
      fx_type *launch()   { return new lazer2red; }

      virtual ~fx_lazer2red_launcher() {}
};


/* *************************************************************
************************************************************* */
class lazerii : public lazer {

   public:

      // superclass
      int  query_whatami() { return OBJECT_LAZERII; }
      int  query_whatwasi(int type);
      void preprocess(void *data);

      virtual ~lazerii() {}
};


/* *************************************************************
************************************************************* */
class fx_lazerii_launcher : public fx_launcher {

   public:
      int query_whatami() { return OBJECT_LAZERII; }
      char *query_name()  { return TOKEN_LAZERII_STR; }
      fx_type *launch()   { return new lazerii; }

      virtual ~fx_lazerii_launcher() {}
};


/* *************************************************************
************************************************************* */
class lazeriii : public lazer {

   public:

      // superclass
      int  query_whatami() { return OBJECT_LAZERIII; }
      int  query_whatwasi(int type);
      void preprocess(void *data);

      virtual ~lazeriii() {}
};


/* *************************************************************
************************************************************* */
class fx_lazeriii_launcher : public fx_launcher {

   public:
      int query_whatami() { return OBJECT_LAZERIII; }
      char *query_name()  { return TOKEN_LAZERIII_STR; }
      fx_type *launch()   { return new lazeriii; }

      virtual ~fx_lazeriii_launcher() {}
};


/* *************************************************************
************************************************************* */
class dual_lazer : public lazer {

   public:
      // superclass
      int  query_whatami() { return OBJECT_DUAL_LAZER; }
      int  query_whatwasi(int type);
      void preprocess(void *data);

      virtual ~dual_lazer() {}
};


/* *************************************************************
************************************************************* */
class fx_dual_lazer_launcher : public fx_launcher {

   public:
      int query_whatami() { return OBJECT_DUAL_LAZER; }
      char *query_name()  { return TOKEN_DUAL_LAZER_STR; }
      fx_type *launch()   { return new dual_lazer; }

      virtual ~fx_dual_lazer_launcher() {}
};


/* *************************************************************
************************************************************* */
class cone_lazer : public lazer {

   public:
      // superclass
      int  query_whatami() { return OBJECT_CONE_LAZER; }
      int  query_whatwasi(int type);
      void preprocess(void *data);

      virtual ~cone_lazer() {}
};


/* *************************************************************
************************************************************* */
class fx_cone_lazer_launcher : public fx_launcher {

   public:
      int query_whatami() { return OBJECT_CONE_LAZER; }
      char *query_name()  { return TOKEN_CONE_LAZER_STR; }
      fx_type *launch()   { return new cone_lazer; }

      virtual ~fx_cone_lazer_launcher() {}
};


/* *************************************************************
************************************************************* */
class rail_round : public lazer {

   public:
      // superclass
      int  query_whatami() { return OBJECT_RAIL_ROUND; }
      int  query_whatwasi(int type);
      void preprocess(void *data);

      // quark
      void whereami(dbl_llist_manager *hiearchy_manager, quark *parent, vector4f *mx);

      virtual ~rail_round() {}
};


/* *************************************************************
************************************************************* */
class fx_rail_round_launcher : public fx_launcher {

   public:
      int query_whatami() { return OBJECT_RAIL_ROUND; }
      char *query_name()  { return TOKEN_RAIL_ROUND_STR; }
      fx_type *launch()   { return new rail_round; }

      virtual ~fx_rail_round_launcher() {}
};


/* *************************************************************
************************************************************* */
class smoke_trail : public fx_type {

   protected:
      gameatom *cam;
      int timer_flag;
      float timer;
      float dist_scale;
      texpolygon *tob;
      texbase *tmap;
      float duration;
      
      int post_rotate();
      void fail_rotate();
      
   public:
      // superclass
      void preprocess(void *data);
      int  query_whatami() { return OBJECT_SMOKE_TRAIL; }
      int  query_whatwasi(int type);
   
      // quark
      void begin(dbl_llist_manager *hiearchy_manager, quark *parent, vector4f *mx);
      void whereami(dbl_llist_manager *hiearchy_manager, quark *parent, vector4f *mx);
      void update(dbl_llist_manager *hiearchy_manager, quark *parent);

      // fx_type
      void init() { fx_type::init(); timer_flag = 0; }      // keeps the compiler from being confused...

      // smoke_trail
      vector4f start, end;

      smoke_trail();
      virtual ~smoke_trail() {}

      void update(float *pos, int breakflag);
      void init(vector4f *mx, float *offset, float timelimit, texbase *stob);
};


/* *************************************************************
************************************************************* */
class fx_smoke_trail_launcher : public fx_launcher {

   public:
      int query_whatami() { return OBJECT_SMOKE_TRAIL; }
      char *query_name()  { return TOKEN_SMOKE_TRAIL_STR; }
      fx_type *launch()   { return new smoke_trail; }

      virtual ~fx_smoke_trail_launcher() {}
};


/* *************************************************************
************************************************************* */
class generic_flat : public fx_type {

   protected:
      float radius;
      float countdown, timelimit;
      int   attachflag;
      quark *cam;
      int   goflag;
      quark *tether;
      
   public:
      // superclass
      int  query_whatami() { return OBJECT_GENERIC_FLAT; }
      int  query_whatwasi(int type);
      void preprocess(void *data);

      // quark
      void begin(dbl_llist_manager *hiearchy_manager, quark *parent, vector4f *mx);
      void whereami(dbl_llist_manager *hiearchy_manager, quark *parent, vector4f *mx);
      void update(dbl_llist_manager *hiearchy_manager, quark *parent);

      // fx_type
      void init();

      // generic_flat
      generic_flat();
      virtual ~generic_flat() {}

      void attach(quark *target, float *pos);
      void init(quark *source, float duration, float rad, float *center, vector4f *parent_mx, vector4f *mx, texbase *tob);
      void init(float duration, float rad, float *center, vector4f *parent_mx, vector4f *mx, texbase *tob);
      void update(int flag);
};


/* *************************************************************
************************************************************* */
class fx_generic_flat_launcher : public fx_launcher {

   public:
      int query_whatami() { return OBJECT_GENERIC_FLAT; }
      char *query_name()  { return TOKEN_GENERIC_FLAT_STR; }
      fx_type *launch()   { return new generic_flat; }

      virtual ~fx_generic_flat_launcher() {}
};


/* *************************************************************
************************************************************* */
class missile : public ammo_type {

   protected:
      camera *camptr;
      quark *src;
      smoke_trail *smoke;
      generic_flat *puff;
      dbl_llist_manager smokeman;
      dbl_llist_manager puffman;
      
      void trail(float *v2, vector4f *mx);
      
      virtual void process_intel();

   public:
      vector3f vel;                                  // current velocity dir
      float    speed, maxspeed, accel, dorient;      // current speed, max speed, accel
      vector3f target_vel;                           // targets direction
      vector4f target_pos;                           // targets position
      float    target_speed;
      target_type specific_target;
      float    distance;
      texbase  *trail_tob, *death_tob, *smoke_tob;
      sound_id_type detonate_sndfx_id;
      
      // superclass
      int  query_whatami() { return OBJECT_MISSILE; }
      int  query_whatwasi(int type);
      void preprocess(void *data);

      // quark
      void whereami(dbl_llist_manager *hiearchy_manager, quark *parent, vector4f *mx);
      void update(dbl_llist_manager *hiearchy_manager, quark *parent);

      // fx_type
      void init() { ammo_type::init(); puff = NULL; smoke = NULL; camptr = NULL; } // keeps the compiler from being confused...
      void dest();

      // missile
      missile();
      virtual ~missile() {}

      void init(atom_list_type *source, float dist, int dam, vector4f *mx, texbase *dtob, texbase *ttob, texbase *stob, float maxspd, float acl, float dor, float init_spd, float *init_v, target_type *target, sound_id_type *sound_id);
};


/* *************************************************************
************************************************************* */
class fx_missile_launcher : public fx_launcher {

   public:
      int query_whatami() { return OBJECT_MISSILE; }
      char *query_name()  { return TOKEN_MISSILE_STR; }
      fx_type *launch()   { return new missile; }

      virtual ~fx_missile_launcher() {}
};


/* *************************************************************
************************************************************* */
class zuni_missile : public missile {

   public:
      // superclass
      int  query_whatami() { return OBJECT_ZUNI_MISSILE; }
      int  query_whatwasi(int type);
      void preprocess(void *data);

      virtual ~zuni_missile() {}
};


/* *************************************************************
************************************************************* */
class fx_zuni_missile_launcher : public fx_launcher {

   public:
      int query_whatami() { return OBJECT_ZUNI_MISSILE; }
      char *query_name()  { return TOKEN_ZUNI_MISSILE_STR; }
      fx_type *launch()   { return new zuni_missile; }

      virtual ~fx_zuni_missile_launcher() {}
};


/* *************************************************************
************************************************************* */
class ssm_missile : public missile {

   protected:
      void process_intel();

   public:
      // superclass
      int  query_whatami() { return OBJECT_SSM_MISSILE; }
      int  query_whatwasi(int type);
      void preprocess(void *data);

      // fx_type
      void init() { missile::init(); lockflag = 0; }      // keeps the compiler from being confused...

      // ssm_missile
      int lockflag;
      virtual ~ssm_missile() {}
};


/* *************************************************************
************************************************************* */
class fx_ssm_missile_launcher : public fx_launcher {

   public:
      int query_whatami() { return OBJECT_SSM_MISSILE; }
      char *query_name()  { return TOKEN_SSM_MISSILE_STR; }
      fx_type *launch()   { return new ssm_missile; }

      virtual ~fx_ssm_missile_launcher() {}
};


/* *************************************************************
************************************************************* */
class magnetic_mine : public fx_type {

   public:
      float countdown;
      int   attachflag;
      quark *tether;
      
      // superclass
      int  query_whatami() { return OBJECT_MAGNETIC_MINE; }
      int  query_whatwasi(int type);
      void preprocess(void *data);

      // quark
      void whereami(dbl_llist_manager *hiearchy_manager, quark *parent, vector4f *mx);
      void update(dbl_llist_manager *hiearchy_manager, quark *parent);

      // fx_type
      void init() { fx_type::init(); tether = NULL; }

      // magnetic_mine
      magnetic_mine();
      virtual ~magnetic_mine() {}

      void attach(quark *target, float *pos);
};


/* *************************************************************
************************************************************* */
class fx_magnetic_mine_launcher : public fx_launcher {

   public:
      int query_whatami() { return OBJECT_MAGNETIC_MINE; }
      char *query_name()  { return TOKEN_MAGNETIC_MINE_STR; }
      fx_type *launch()   { return new magnetic_mine; }

      virtual ~fx_magnetic_mine_launcher() {}
};


/* *************************************************************
************************************************************* */
class shield_ripple : public fx_type {

   protected:
      float countdown, timelimit;
      int   attach_flag;
      quark *tether;
      
   public:
      // superclass
      int  query_whatami() { return OBJECT_SHIELD_RIPPLE; }
      int  query_whatwasi(int type);
      void preprocess(void *data);

      // quark
      void begin(dbl_llist_manager *hiearchy_manager, quark *parent, vector4f *mx);
      void whereami(dbl_llist_manager *hiearchy_manager, quark *parent, vector4f *mx);
      void update(dbl_llist_manager *hiearchy_manager, quark *parent);

      // fx_type
      void init();

      // shield_ripple
      shield_ripple();
      virtual ~shield_ripple() {}

      void init(quark *source, vector4f *parent_mx, float *pos, float *shield_data, float duration);
};


/* *************************************************************
************************************************************* */
class fx_shield_ripple_launcher : public fx_launcher {

   public:
      int query_whatami() { return OBJECT_SHIELD_RIPPLE; }
      char *query_name()  { return TOKEN_SHIELD_RIPPLE_STR; }
      fx_type *launch()   { return new shield_ripple; }

      virtual ~fx_shield_ripple_launcher() {}
};


/* *************************************************************
************************************************************* */
class human_shield_ripple : public shield_ripple {

   public:
      // superclass
      int  query_whatami() { return OBJECT_HUMAN_SHIELD_RIPPLE; }
      int  query_whatwasi(int type);
      void preprocess(void *data);

      virtual ~human_shield_ripple() {}
};


/* *************************************************************
************************************************************* */
class fx_human_shield_ripple_launcher : public fx_launcher {

   public:
      int query_whatami() { return OBJECT_HUMAN_SHIELD_RIPPLE; }
      char *query_name()  { return TOKEN_HUMAN_SHIELD_RIPPLE_STR; }
      fx_type *launch()   { return new human_shield_ripple; }

      virtual ~fx_human_shield_ripple_launcher() {}
};


/* *************************************************************
************************************************************* */
class alien_shield_ripple : public shield_ripple {

   public:
      // superclass
      int  query_whatami() { return OBJECT_ALIEN_SHIELD_RIPPLE; }
      int  query_whatwasi(int type);
      void preprocess(void *data);

      virtual ~alien_shield_ripple() {}
};


/* *************************************************************
************************************************************* */
class fx_alien_shield_ripple_launcher : public fx_launcher {

   public:
      int query_whatami() { return OBJECT_ALIEN_SHIELD_RIPPLE; }
      char *query_name()  { return TOKEN_ALIEN_SHIELD_RIPPLE_STR; }
      fx_type *launch()   { return new alien_shield_ripple; }

      virtual ~fx_alien_shield_ripple_launcher() {}
};


/* *************************************************************
************************************************************* */
class explosion : public fx_type {

   protected:
      float duration;
      float timer;
      float max_size;

   public:
      // superclass
      int  query_whatami() { return OBJECT_EXPLOSION; }
      int  query_whatwasi(int type);
      void preprocess(void *data);

      // quark
      void begin(dbl_llist_manager *hiearchy_manager, quark *parent, vector4f *mx);
      void whereami(dbl_llist_manager *hiearchy_manager, quark *parent, vector4f *mx);
      void update(dbl_llist_manager *hiearchy_manager, quark *parent);

      // fx_type
      void init() { fx_type::init(); }      // keeps the compiler from being confused...

      // explode
      explosion();
      virtual ~explosion() {}

      void init(vector4f *mx, float timelimit, float maxsize);
};


/* *************************************************************
************************************************************* */
class fx_explosion_launcher : public fx_launcher {

   public:
      int query_whatami() { return OBJECT_EXPLOSION; }
      char *query_name()  { return TOKEN_EXPLOSION_STR; }
      fx_type *launch()   { return new explosion; }

      virtual ~fx_explosion_launcher() {}
};


/* *************************************************************
************************************************************* */
class shockwave : public fx_type {

   protected:
      float duration;
      float timer;
      float max_size;

   public:
      // superclass
      int  query_whatami() { return OBJECT_SHOCKWAVE; }
      int  query_whatwasi(int type);
      void preprocess(void *data);

      // quark
      void begin(dbl_llist_manager *hiearchy_manager, quark *parent, vector4f *mx);
      void whereami(dbl_llist_manager *hiearchy_manager, quark *parent, vector4f *mx);
      void update(dbl_llist_manager *hiearchy_manager, quark *parent);

      // fx_type
      void init() { fx_type::init(); }      // keeps the compiler from being confused...

      // shockwave
      shockwave();
      virtual ~shockwave() {}

      void init(vector4f *mx, float timelimit, float maxsize);
};


/* *************************************************************
************************************************************* */
class fx_shockwave_launcher : public fx_launcher {

   public:
      int query_whatami() { return OBJECT_SHOCKWAVE; }
      char *query_name()  { return TOKEN_SHOCKWAVE_STR; }
      fx_type *launch()   { return new shockwave; }

      virtual ~fx_shockwave_launcher() {}
};


#endif
