

#include "polygame.h"
#include "anineutr.h"

#include "darkgine.h"
#include "darkfx.h"


/* *************************************************************
************************************************************* */
int ammo_type::query_whatwasi(int type) {

   return ammo_type::query_whatami() == type ? 1 : fx_type::query_whatwasi(type);
}


/* *************************************************************
************************************************************* */
int ammo_type::atom_vs_lineseg(atom_list_type *obstacle, float *midpt, float rad, float *ray, float *start, target_type *victim, float *pos, int *col_type) {

   float *shield_data;
   vector4f istart;
   vector3f iray;
   int i;
   float t;

   // tree doesnt intersect w/ its children or owner
   if ((obstacle->htree->old_state.state_flags & STATE_MASK_TREE) == STATE_FLAG_TNONE || !(obstacle->htree->flags & QUARK_FLAG_ACTIVE) || owner == obstacle)
      return 0;

   // check lineseg vs tree
   if ((obstacle->htree->old_state.state_flags & STATE_MASK_TREE) == STATE_FLAG_TSPHERE && !query_sphere_sphere_intersect(midpt, rad, obstacle->htree->old_state.tree_center, obstacle->htree->old_state.tree_radius))
      return 0;

   // check shields
   if (!(obstacle->htree->flags & GAMEFLAG_SHIELDS) || !obstacle->htree->query_specific_data(DATAFLAG_SHIELDS, &shield_data)) {
      *col_type = COL_NULL;
      return 1;
   }

   if (!(obstacle->htree->old_state.state_flags & STATE_FLAG_INVERSE)) {
      inversemx(obstacle->htree->old_state.xmx, obstacle->htree->old_state.ixmx);
      obstacle->htree->old_state.state_flags |= STATE_FLAG_INVERSE;
   }

   matvecmulto(obstacle->htree->old_state.ixmx, start, istart);
   istart[0] -= shield_data[3];
   istart[1] -= shield_data[4];
   istart[2] -= shield_data[5];

   matvecmultv(obstacle->htree->old_state.ixmx, ray, iray);

   i = line_ellipse_intersect(shield_data, istart, iray, &t);

   // inside ellipsoid
   if (i < 0) {
      copyarray3(pos, start);
      pos[3] = 1.0f;
      *col_type = COL_SHIELDS;
      victim->object = obstacle;
      return 1;
   }

   if (!i || t < 0 || t > 1.0f)
      return 0;

   pos[0] = istart[0] + shield_data[3] + t*iray[0];
   pos[1] = istart[1] + shield_data[4] + t*iray[1];
   pos[2] = istart[2] + shield_data[5] + t*iray[2];
   pos[3] = 1.0f;

   matvecmulto(obstacle->htree->old_state.xmx, pos);

   *col_type = COL_SHIELDS;
   victim->object = obstacle;
   return 1;
}


/* *************************************************************
************************************************************* */
int ammo_type::subobject_vs_lineseg(quark *specific_target, quark *obstacle, quark *parent, float *midpt, float rad,
                                  float *start, float *end, int level, target_type *victim, float *pos, float *normal, int *col_type) {

   linktype *ptr;

   // tree doesnt intersect w/ its children or owner
   if ((obstacle->old_state.state_flags & STATE_MASK_TREE) == STATE_FLAG_TNONE || this == obstacle || owner->htree == obstacle)
      return 0;

   if (obstacle != specific_target) {

      // check lineseg vs tree
      if ((obstacle->old_state.state_flags & STATE_MASK_TREE) == STATE_FLAG_TSPHERE &&
          !query_sphere_sphere_intersect(midpt, rad, obstacle->old_state.tree_center, obstacle->old_state.tree_radius))
         return 0;

      // check vs checkable object
      if ((obstacle->flags & QUARK_FLAG_ACTIVE) && (obstacle->flags & GAMEFLAG_PHYSICAL) &&
          obstacle->query_whatwasi(OBJECT_ANTINEUTRON) &&
          ((antineutron *)obstacle)->obj_vs_lineseg(start, end, midpt, rad, pos, normal, level)) {

         *col_type = COL_OBJECT;
         victim->specific = obstacle;
         return 1;
      }

   }

   // check w/ subtree
   for (ptr=(linktype *)obstacle->edge.head; ptr; ptr=(linktype *)ptr->next) {
      if (ptr->link != parent && subobject_vs_lineseg(specific_target, ptr->link, obstacle, midpt, rad, start, end, level, victim, pos, normal, col_type)) {

         if (victim->specific == ptr->link)
            victim->specific_parent = obstacle;

         return 1;
      }

   }

   return 0;
}


/* *************************************************************
************************************************************* */
int ammo_type::specific_object_vs_lineseg(quark *obstacle, float *midpt, float rad, float *ray,
                                          float *start, float *end, int level, target_type *victim, float *pos, float *normal, int *col_type) {

   if ((obstacle->old_state.state_flags & STATE_MASK_TREE) == STATE_FLAG_TNONE)
      return 0;

   // check lineseg vs tree
   if ((obstacle->old_state.state_flags & STATE_MASK_TREE) == STATE_FLAG_TSPHERE &&
       !query_sphere_sphere_intersect(midpt, rad, obstacle->old_state.tree_center, obstacle->old_state.tree_radius))
      return 0;

   // check vs checkable object
   if ((obstacle->flags & QUARK_FLAG_ACTIVE) && (obstacle->flags & GAMEFLAG_PHYSICAL) &&
       obstacle->query_whatwasi(OBJECT_ANTINEUTRON) &&
       ((antineutron *)obstacle)->obj_vs_lineseg(start, end, midpt, rad, pos, normal, level)) {

      *col_type = COL_OBJECT;
      victim->specific = obstacle;
      return 1;
   }

   return 0;
}


/* *************************************************************
************************************************************* */
int ammo_type::object_vs_lineseg(quark *specific_target, atom_list_type *obstacle, float *midpt, float rad, float *ray,
                                 float *start, float *end, int level, target_type *victim, float *pos, float *normal, int *col_type) {

   linktype *ptr;

   if (!atom_vs_lineseg(obstacle, midpt, rad, ray, start, victim, pos, col_type))
      return 0;

   if (*col_type != COL_NULL)
      return 1;

   // check w/ subtree
   for (ptr=(linktype *)obstacle->htree->edge.head; ptr; ptr=(linktype *)ptr->next) {
      if (subobject_vs_lineseg(specific_target, ptr->link, obstacle->htree, midpt, rad, start, end, level, victim, pos, normal, col_type)) {
         victim->object = obstacle;
         return 1;
      }

   }

   return 0;
}


/* *************************************************************
************************************************************* */
void ammo_type::damage_target(gameatom *tree, quark *target, quark *tparent, quark *parent, float *pos, vector4f *mx) {

   linktype *ptr;
   threat_type threat;
   int ret = 0;
   hit_type *htr;
      
   if (target != tree && target->query_category() == CLASS_GAME) {
      threat.threat = owner;
      threat.damage = (float)damage;
      threat.hit_count = 1;

      tree->set_specific_data(DATAFLAG_THREAT, &threat);

      ret = tree->apply_damage((gamequark *)target, properties, &damage, pos, mx);

      if (owner->htree == global_player && sheader) {
         for (htr = (hit_type *)sheader->player_hit_manager.head; htr && htr->target != tree; htr = (hit_type *)htr->next);
	 
	 if (htr)
	    htr->amount += ret;
      }
      
      if (!damage)
         return;
   }

   for (ptr=(linktype *)target->edge.head; ptr; ptr=(linktype *)ptr->next)
      if (ptr->link != tparent && ptr->link != parent) {
         damage_target(tree, ptr->link, NULL, target, pos, mx);

         if (!damage)
            return;
      }
      
   if (tparent)
      damage_target(tree, tparent, NULL, target, pos, mx);
}
