

#if !defined __DARKEQUP_H
#define __DARKEQUP_H


#include "equipmnt.h"
#include "fxman.h"
#include "brain.h"
#include "darkstrg.h"
#include "darkman.h"

#define EQUIPCAT_ENGINE             21
#define EQUIPCAT_THRUSTER           22
#define EQUIPCAT_PRIMARY_WEAPON     23
#define EQUIPCAT_SECONDARY_WEAPON   24
#define EQUIPCAT_INSTRUMENT         25
#define EQUIPCAT_DEFENSE            26
#define EQUIPCAT_INERTIA            27

#define EQUIP_ENGINE                151
#define EQUIP_THRUSTER              152
#define EQUIP_LAZER                 153
#define EQUIP_LAZER2BLU             154
#define EQUIP_LAZER2RED             155
#define EQUIP_DUAL_LAZER            156
#define EQUIP_CONE_LAZER            157
#define EQUIP_RAIL_GUN              158
#define EQUIP_TARGETING_COMPUTER    159
#define EQUIP_SYSTEMS_COMPUTER      160
#define EQUIP_LAUNCHER              161
#define EQUIP_ZUNI_LAUNCHER         162
#define EQUIP_SSM_LAUNCHER          163
#define EQUIP_ARMOUR                164
#define EQUIP_SHIELDS               165
#define EQUIP_INERTIAL_COMPENSATOR  166
#define EQUIP_INERTIAL_DAMPENER     167
#define EQUIP_RADAR                 168

#define TARGET_MODE_NEXT          0
#define TARGET_MODE_NEAREST       1
#define TARGET_MODE_CENTER        2

#define TARGET_MASK_NULL           0x00
#define TARGET_MASK_FIND_TARGET    0x01
#define TARGET_MASK_FIND_SUBTARGET 0x02

#define CRADLE_PRIMARY   0
#define CRADLE_SECONDARY 1
#define CRADLE_STATUS_COMPUTER  2
#define MAX_CRADLE       3

#define PRIMARY_MODE_SINGLE 0
#define PRIMARY_MODE_FULL   1
#define PRIMARY_MODE_ROBIN  2

#define SECONDARY_MODE_GUIDED     0x01
#define SECONDARY_MODE_MAX_DAMAGE 0x02
#define SECONDARY_MODE_OTHER      0x03

#define SOUND_EQUIP_ID_DAMAGE     0x00
#define SOUND_EQUIP_ID_DEATH      0x01
#define SOUND_EQUIP_ID_DAMAGE_MAX 0x02

#define FLAG_RADAR_NULL 0x00
#define FLAG_RADAR_RADAR_LOCK 0x01
#define FLAG_RADAR_MISSILE_LOCK 0x02

#define SOUND_EQUIP_ID_ENGINE      0x00
#define SOUND_EQUIP_ID_AFTERBURNER 0x01
#define SOUND_EQUIP_ID_ENGINE_MAX  0x02

#define VOICE_PILOT_TRIUMPH         0
#define VOICE_PILOT_DYNAMIC_ATTACK  1
#define VOICE_PILOT_DYNAMIC_DEFEND  2
#define VOICE_PILOT_DYNAMIC_WINGMAN 3
#define VOICE_PILOT_DYNAMIC_RESCIND 4
#define VOICE_PILOT_TRAITOR         5
#define VOICE_PILOT_DEATH           6
#define VOICE_PILOT_MAX             7


/* *************************************************************
************************************************************* */
class substate_type : public dbl_llist {

   public:
      vector4f weighted_velocity;
      
      virtual ~substate_type() {}
};


/* *************************************************************
************************************************************* */
class equip_engine : public equipment {

   protected:
      // equipment
      equipment *copy(equipment *item);

      // engine
      float speed, accel;
      sound_id_type sndfx_id[SOUND_EQUIP_ID_ENGINE_MAX];

      // not copied when cloned...
      sound_type *sndfx;

   public:
      // superclass
      int query_whatami()  { return EQUIP_ENGINE; }
      int query_whatwasi(int type);
      int query_category() { return EQUIPCAT_ENGINE; }
      int parse(FILE *infile, char *token);

      // equipment
      equipment *clone()  { return copy(new equip_engine); }
      void update_fx(vector4f *mx);
      void reset(gameatom *source, object_desc *ob);
      void apply_damage(int *damage);

      // engine
      equip_engine();
      virtual ~equip_engine();
};


/* *************************************************************
************************************************************* */
class equip_engine_loader : public equipment_loader {

   public:
      char *query_name()       { return TOKEN_ENGINE_STR; }
      equipment *make_object() { return new equip_engine; }

      virtual ~equip_engine_loader() {}
};


/* *************************************************************
************************************************************* */
class equip_thruster : public equipment {

   protected:
      // equipment
      equipment *copy(equipment *item);

      float dorient;

   public:
      int query_whatami()  { return EQUIP_THRUSTER; }
      int query_whatwasi(int type);
      int query_category() { return EQUIPCAT_THRUSTER; }
      int parse(FILE *infile, char *token);

      equipment *clone()  { return copy(new equip_thruster); }
      void reset(gameatom *source, object_desc *ob);
      void apply_damage(int *damage);

      equip_thruster() { dorient = HALFPI; }
      virtual ~equip_thruster() {}
};


/* *************************************************************
************************************************************* */
class equip_thruster_loader : public equipment_loader {

   public:
      char *query_name()       { return TOKEN_THRUSTER_STR; }
      equipment *make_object() { return new equip_thruster; }

      virtual ~equip_thruster_loader() {}
};


/* *************************************************************
************************************************************* */
class equip_weapon : public equipment {

   protected:
      // equipment
      equipment *copy(equipment *item);

      // equip_weapon
      virtual unsigned int query_gfx() = 0;

   public:
      // superclass
      int parse(FILE *infile, char *token);

      // equipment
      void reset(gameatom *source, object_desc *ob);

      // equip_weapon
      vector4f offset;
      float max_range, speed, max_time;
      float max_delay, delay, link_delay;
      int max_damage;

      // not copied when cloned...
      int current_flag;

      equip_weapon();
      virtual ~equip_weapon() {}
      virtual void launch(atom_list_type *source, target_type *target, vector4f *mx) = 0;
      virtual equip_weapon *query_fire() = 0;
      virtual int query_active() { return 1; }
};


/* *************************************************************
************************************************************* */
class equip_lazer : public equip_weapon {

   protected:
      // equipment
      equipment *copy(equipment *item);

      // equip_weapon
      unsigned int query_gfx() { return OBJECT_LAZER; }

      // equip_lazer
      float capacitor, discharge_rate;
      float max_capacitor_charge;
      float capacitor_charge;	// max_capacitor_charge augmented by damage
      float recharge_rate;
      string_type deathname;
      texbase *death_tob;
      sound_id_type sndfx_id;

      // not copied when cloned...
      sound_type *sndfx;

   public:
      // superclass
      int query_whatami() { return EQUIP_LAZER; }
      int query_whatwasi(int type);
      int query_category() { return EQUIPCAT_PRIMARY_WEAPON; }
      int parse(FILE *infile, char *token);
      void preprocess(void *data);

      // equipment
      equipment *clone()  { return copy(new equip_lazer); }
      void update(dbl_llist_manager *hiearchy_manager);
      void update_fx(vector4f *mx);
      void display_hud(dbl_llist_manager *hiearchy_manager, gameatom *source, engine *proc, mapul *mapbuffer);
      void reset(gameatom *source, object_desc *ob);
      void apply_damage(int *damage);

      // equip_weapon
      void launch(atom_list_type *source, target_type *target, vector4f *mx);
      equip_weapon *query_fire();

      // equip_lazer
      equip_lazer();
      virtual ~equip_lazer();
};


/* *************************************************************
************************************************************* */
class equip_lazer_loader : public equipment_loader {

   public:
      char *query_name()       { return TOKEN_LAZER_STR; }
      equipment *make_object() { return new equip_lazer; }

      virtual ~equip_lazer_loader() {}
};


/* *************************************************************
************************************************************* */
class equip_lazer2blu : public equip_lazer {

   protected:
      // equip_weapon
      unsigned int query_gfx() { return OBJECT_LAZER2BLU; }

   public:
      // superclass
      int query_whatami() { return EQUIP_LAZER2BLU; }
      int query_whatwasi(int type);

      // equipment
      equipment *clone()  { return copy(new equip_lazer2blu); }

      // equip_lazer2blu
      virtual ~equip_lazer2blu() {}
};


/* *************************************************************
************************************************************* */
class equip_lazer2blu_loader : public equipment_loader {

   public:
      char *query_name()       { return TOKEN_LAZER2BLU_STR; }
      equipment *make_object() { return new equip_lazer2blu; }

      virtual ~equip_lazer2blu_loader() {}
};


/* *************************************************************
************************************************************* */
class equip_lazer2red : public equip_lazer {

   protected:
      // equip_weapon
      unsigned int query_gfx() { return OBJECT_LAZER2RED; }

   public:
      // superclass
      int query_whatami() { return EQUIP_LAZER2RED; }
      int query_whatwasi(int type);

      // equipment
      equipment *clone()  { return copy(new equip_lazer2red); }

      // equip_lazer2red
      virtual ~equip_lazer2red() {}
};


/* *************************************************************
************************************************************* */
class equip_lazer2red_loader : public equipment_loader {

   public:
      char *query_name()       { return TOKEN_LAZER2RED_STR; }
      equipment *make_object() { return new equip_lazer2red; }

      virtual ~equip_lazer2red_loader() {}
};


/* *************************************************************
************************************************************* */
class equip_dual_lazer : public equip_lazer {

   protected:
      // equip_weapon
      unsigned int query_gfx() { return OBJECT_DUAL_LAZER; }

   public:
      // superclass
      int query_whatami() { return EQUIP_DUAL_LAZER; }
      int query_whatwasi(int type);

      // equipment
      equipment *clone()  { return copy(new equip_dual_lazer); }

      // equip_dual_lazer
      virtual ~equip_dual_lazer() {}
};


/* *************************************************************
************************************************************* */
class equip_dual_lazer_loader : public equipment_loader {

   public:
      char *query_name()       { return TOKEN_DUAL_LAZER_STR; }
      equipment *make_object() { return new equip_dual_lazer; }

      virtual ~equip_dual_lazer_loader() {}
};


/* *************************************************************
************************************************************* */
class equip_cone_lazer : public equip_lazer {

   protected:
      // equip_weapon
      unsigned int query_gfx() { return OBJECT_CONE_LAZER; }

   public:
      // superclass
      int query_whatami() { return EQUIP_CONE_LAZER; }
      int query_whatwasi(int type);

      // equipment
      equipment *clone()  { return copy(new equip_cone_lazer); }

      // equip_dual_lazer
      virtual ~equip_cone_lazer() {}
};


/* *************************************************************
************************************************************* */
class equip_cone_lazer_loader : public equipment_loader {

   public:
      char *query_name()       { return TOKEN_CONE_LAZER_STR; }
      equipment *make_object() { return new equip_cone_lazer; }

      virtual ~equip_cone_lazer_loader() {}
};


/* *************************************************************
************************************************************* */
class equip_rail_gun : public equip_lazer {

   protected:
      // equip_weapon
      unsigned int query_gfx() { return OBJECT_RAIL_ROUND; }

   public:
      // superclass
      int query_whatami() { return EQUIP_RAIL_GUN; }
      int query_whatwasi(int type);

      // equipment
      equipment *clone()  { return copy(new equip_rail_gun); }
      void reset(gameatom *source, object_desc *ob);

      // equip_weapon
      int query_active() { return capacitor > 0; }

      // equip_rail_gun
      virtual ~equip_rail_gun() {}
};


/* *************************************************************
************************************************************* */
class equip_rail_gun_loader : public equipment_loader {

   public:
      char *query_name()       { return TOKEN_RAIL_GUN_STR; }
      equipment *make_object() { return new equip_rail_gun; }

      virtual ~equip_rail_gun_loader() {}
};


/* *************************************************************
************************************************************* */
class equip_launcher : public equip_weapon {

   protected:
      // equipment
      equipment *copy(equipment *item);

      // equip_weapon
      unsigned int query_gfx() { return OBJECT_MISSILE; }

      int maxcount, count;

      float accel, launch_speed, dorient;
      vector3f launch_dir;
      sound_id_type sndfx_id;
      sound_id_type detonate_sndfx_id;

      // not copied when cloned...
      sound_type *sndfx;

      string_type deathname, trailname, smokename;
      texbase *death_tob, *trail_tob, *smoke_tob;

   public:
      int query_whatami() { return EQUIP_LAUNCHER; }
      int query_whatwasi(int type);

      int query_category() { return EQUIPCAT_SECONDARY_WEAPON; }
      int parse(FILE *infile, char *token);
      void preprocess(void *data);

      // equipment
      equipment *clone()  { return copy(new equip_launcher); }
      void update(dbl_llist_manager *hiearchy_manager);
      void update_fx(vector4f *mx);
      void display_hud(dbl_llist_manager *hiearchy_manager, gameatom *source, engine *proc, mapul *mapbuffer);
      void reset(gameatom *source, object_desc *ob);

      // equip_weapon
      void launch(atom_list_type *source, target_type *target, vector4f *mx);
      equip_weapon *query_fire();
      int query_active() { return count > 0; }

      // equip_launcher
      equip_launcher();
      virtual ~equip_launcher();
      virtual int query_guidance() { return 0; }
};


/* *************************************************************
************************************************************* */
class equip_launcher_loader : public equipment_loader {

   public:
      char *query_name()       { return TOKEN_LAUNCHER_STR; }
      equipment *make_object() { return new equip_launcher; }

      virtual ~equip_launcher_loader() {}
};


/* *************************************************************
************************************************************* */
class equip_zuni_launcher : public equip_launcher {

   protected:
      // equip_weapon
      unsigned int query_gfx() { return OBJECT_ZUNI_MISSILE; }

   public:
      // superclass
      int query_whatami() { return EQUIP_ZUNI_LAUNCHER; }
      int query_whatwasi(int type);

      // equipment
      equipment *clone()  { return copy(new equip_zuni_launcher); }

      // equip_zuni_launcher
      virtual ~equip_zuni_launcher() {}
};


/* *************************************************************
************************************************************* */
class equip_zuni_launcher_loader : public equipment_loader {

   public:
      char *query_name()       { return TOKEN_ZUNI_LAUNCHER_STR; }
      equipment *make_object() { return new equip_zuni_launcher; }

      virtual ~equip_zuni_launcher_loader() {}
};


/* *************************************************************
************************************************************* */
class equip_ssm_launcher : public equip_launcher {

   protected:
      // equipment
      equipment *copy(equipment *item);

      // equip_weapon
      unsigned int query_gfx() { return OBJECT_SSM_MISSILE; }

      // equip_ssm_launcher
      int locktime;

   public:
      // superclass
      int query_whatami() { return EQUIP_SSM_LAUNCHER; }
      int query_whatwasi(int type);
      int parse(FILE *infile, char *token);

      // equipment
      equipment *clone()  { return copy(new equip_ssm_launcher); }
      int query_guidance() { return locktime; }

      // equip_weapon
      void launch(atom_list_type *source, target_type *target, vector4f *mx);

      // equip_ssm_launcher
      equip_ssm_launcher() { locktime = 1; }
      virtual ~equip_ssm_launcher() {}
};


/* *************************************************************
************************************************************* */
class equip_ssm_launcher_loader : public equipment_loader {

   public:
      char *query_name()       { return TOKEN_SSM_LAUNCHER_STR; }
      equipment *make_object() { return new equip_ssm_launcher; }

      virtual ~equip_ssm_launcher_loader() {}
};


/* *************************************************************
************************************************************* */
class equip_status_computer : public equipment {

   public:

      // equipment
      void reset(gameatom *source, object_desc *ob);

      // equip_status_computer

      // not copied when cloned...
      int current_flag;

      equip_status_computer() { current_flag = 0; }
      virtual ~equip_status_computer() {}
      
      virtual int cycle_display();
};


/* *************************************************************
************************************************************* */
class equip_targeting_computer : public equip_status_computer {

   protected:
      // equipment
      equipment *copy(equipment *item);

      master_targeting_pathway targetlock;
      sub_targeting_pathway    sublock;
      int                      target_mode;
      unsigned int             target_flag;
      sound_id_type            sndfx_id;

      // not copied in clone()
      sound_type               *sndfx;
      float                    timer;

   public:
      // superclass
      int query_whatami() { return EQUIP_TARGETING_COMPUTER; }
      int query_whatwasi(int type);
      int query_category() { return EQUIPCAT_INSTRUMENT; }
      int parse(FILE *infile, char *token);

      // equipment
      equipment *clone()  { return copy(new equip_targeting_computer); }
      void update(dbl_llist_manager *hiearchy_manager);
      void update_fx(vector4f *mx);
      void reset(gameatom *source, object_desc *ob);
      void display_hud(dbl_llist_manager *hiearchy_manager, gameatom *source, engine *proc, mapul *mapbuffer);

      // equip_targeting_computer
      target_type target;
//      target_type subtarget;
      int         missilelock_active;
      float       missilelock_time, missilelock_countdown;

      // not copied in clone()
      int               match_velocity_flag;
      dbl_llist_manager target_substate_manager;

      equip_targeting_computer();
      virtual ~equip_targeting_computer();

      void set_target_type(unsigned int andtype, unsigned int ortype) { targetlock.set_mask(andtype, ortype); }
      void set_target_mode(int mode) { target_mode = mode; }
      void set_target(target_type *source) { target.object = source->object; target.specific_parent = source->specific_parent; target.specific = source->specific; }
      void update_target(unsigned int mask) { target_flag = mask; }
      float query_match_velocity();
};


/* *************************************************************
************************************************************* */
class equip_targeting_computer_loader : public equipment_loader {

   public:
      char *query_name()       { return TOKEN_TARGETING_COMPUTER_STR; }
      equipment *make_object() { return new equip_targeting_computer; }

      virtual ~equip_targeting_computer_loader() {}
};


/* *************************************************************
************************************************************* */
class radar_blip_type : public dbl_llist {

   public:
      vector4uc color;
      vector2i pos;

      virtual ~radar_blip_type() {}
};


/* ************************************************************
************************************************************ */
class radar_man : public mini_memman {

   public:
      virtual ~radar_man() {}

      void *pop();
};


/* *************************************************************
************************************************************* */
class equip_radar : public equipment {

   protected:
      // equipment
      equipment *copy(equipment *item);

      // equip_radar
      sound_id_type radar_sndfx_id;
      sound_id_type missile_sndfx_id;
      texbase *display_tob, *pulse_tob;
            
      // not copied in clone()
      unsigned int status_flag;
      float radar_timer;
      float missile_timer;
      sound_type *radar_sndfx;
      sound_type *missile_sndfx;
      float scan_timer;
      dbl_llist_manager contact;
      camera *cam;
      gameatom *parent;
      radar_man rman;
      
      int  compute_offset(float *in, int *out, float scale, int *offset, int winx, int winy);
      void update_scan(dbl_llist_manager *hiearchy_manager, int winx, int winy);

   public:
      // superclass
      int query_whatami() { return EQUIP_RADAR; }
      int query_whatwasi(int type);
      int query_category() { return EQUIPCAT_INSTRUMENT; }
      int parse(FILE *infile, char *token);
      void preprocess(void *data);

      // equipment
      equipment *clone()  { return copy(new equip_radar); }
      void update(dbl_llist_manager *hiearchy_manager);
      void update_fx(vector4f *mx);
      void reset(gameatom *source, object_desc *ob);
      void display_hud(dbl_llist_manager *hiearchy_manager, gameatom *source, engine *proc, mapul *mapbuffer);

      // equip_radar
      equip_radar();
      virtual ~equip_radar();

      void set_missile_lock(gameatom *source);
      void set_radar_lock(gameatom *source);
};


/* *************************************************************
************************************************************* */
class equip_radar_loader : public equipment_loader {

   public:
      char *query_name()       { return TOKEN_RADAR_STR; }
      equipment *make_object() { return new equip_radar; }

      virtual ~equip_radar_loader() {}
};


/* *************************************************************
************************************************************* */
class equip_systems_computer : public equip_status_computer {

   protected:
      // equipment
      equipment *copy(equipment *item);

      // not copied in clone()
      float update_timer;
      
   public:

      // superclass
      int query_whatami() { return EQUIP_SYSTEMS_COMPUTER; }
      int query_whatwasi(int type);
      int query_category() { return EQUIPCAT_INSTRUMENT; }
      int parse(FILE *infile, char *token);

      // equipment
      equipment *clone()  { return copy(new equip_systems_computer); }
      void update(dbl_llist_manager *hiearchy_manager);
      void reset(gameatom *source, object_desc *ob);
      void display_hud(dbl_llist_manager *hiearchy_manager, gameatom *source, engine *proc, mapul *mapbuffer);

      // equip_status_computer
      int cycle_display();
      
      // equip_systems_computer
      vector4uc rgb;

      // not copied in clone()
      int current_status_index;

      equip_systems_computer() { *(unsigned int *)rgb = 0; }
      virtual ~equip_systems_computer() {}
};


/* *************************************************************
************************************************************* */
class equip_systems_computer_loader : public equipment_loader {

   public:
      char *query_name()       { return TOKEN_SYSTEMS_COMPUTER_STR; }
      equipment *make_object() { return new equip_systems_computer; }

      virtual ~equip_systems_computer_loader() {}
};


/* *************************************************************
************************************************************* */
class equip_ablative_armour : public equipment {

   protected:
      // equipment
      equipment *copy(equipment *item);

      int  armour;

   public:
      // superclass
      int query_whatami() { return EQUIP_ARMOUR; }
      int query_whatwasi(int type);
      int query_category() { return EQUIPCAT_DEFENSE; }
      int parse(FILE *infile, char *token);

      // equipment
      equipment *clone()  { return copy(new equip_ablative_armour); }
      void reset(gameatom *source, object_desc *ob);

      // equip_ablative_armour
      equip_ablative_armour() { armour = 0; }
      virtual ~equip_ablative_armour() {}
};


/* *************************************************************
************************************************************* */
class equip_ablative_armour_loader : public equipment_loader {

   public:
      char *query_name()       { return TOKEN_ARMOUR_STR; }
      equipment *make_object() { return new equip_ablative_armour; }

      virtual ~equip_ablative_armour_loader() {}
};


/* *************************************************************
************************************************************* */
class equip_shields : public equipment {

   protected:
      // equipment
      equipment *copy(equipment *item);

      float regen_rate, max_regen_rate, max_shields;

   public:

      // superclass
      int query_whatami()  { return EQUIP_SHIELDS; }
      int query_whatwasi(int type);
      int query_category() { return EQUIPCAT_DEFENSE; }
      int parse(FILE *infile, char *token);

      // equipment
      equipment *clone()  { return copy(new equip_shields); }
      void reset(gameatom *source, object_desc *ob);
      void update(dbl_llist_manager *hiearchy_manager);
      void apply_damage(int *damage);

      // equip_shields
      unsigned int fx_id;
      float duration, downtime;
      sound_id_type sndfx_id;

      equip_shields();
      virtual ~equip_shields() {}

      void activate(gameatom *tree, vector4f *mx, float *pos);
};


/* *************************************************************
************************************************************* */
class equip_shields_loader : public equipment_loader {

   public:
      char *query_name()       { return TOKEN_SHIELDS_STR; }
      equipment *make_object() { return new equip_shields; }

      virtual ~equip_shields_loader() {}
};


/* *************************************************************
************************************************************* */
class equip_inertial_compensator : public equipment {

   protected:
      // equipment
      equipment *copy(equipment *item);

   public:

      // superclass
      int query_whatami()  { return EQUIP_INERTIAL_COMPENSATOR; }
      int query_whatwasi(int type);
      int query_category() { return EQUIPCAT_INERTIA; }

      // equipment
      equipment *clone()  { return copy(new equip_inertial_compensator); }

      void reset(gameatom *source, object_desc *ob);
      void update(dbl_llist_manager *hiearchy_manager);

      // equip_inertial_compensator
      int toggle, playerflag;

      equip_inertial_compensator() { toggle = 1; playerflag = 0; }
      virtual ~equip_inertial_compensator() {}
};


/* *************************************************************
************************************************************* */
class equip_inertial_compensator_loader : public equipment_loader {

   public:
      char *query_name()       { return TOKEN_INERTIAL_COMPENSATOR_STR; }
      equipment *make_object() { return new equip_inertial_compensator; }

      virtual ~equip_inertial_compensator_loader() {}
};


/* *************************************************************
************************************************************* */
class equip_inertial_dampener : public equip_inertial_compensator {

   public:

      // superclass
      int query_whatami()  { return EQUIP_INERTIAL_DAMPENER; }
      int query_whatwasi(int type);

      // equipment
      equipment *clone()  { return copy(new equip_inertial_dampener); }

      // equip_inertial_dampener
      virtual ~equip_inertial_dampener() {}
};


/* *************************************************************
************************************************************* */
class equip_inertial_dampener_loader : public equipment_loader {

   public:
      char *query_name()       { return TOKEN_INERTIAL_DAMPENER_STR; }
      equipment *make_object() { return new equip_inertial_dampener; }

      virtual ~equip_inertial_dampener_loader() {}
};


/* *************************************************************
   equipment list for an object
************************************************************* */
class object_systems {

   public:
      equipment **inventory;
      int count;

      object_systems() { inventory = NULL; }
      virtual ~object_systems();
      void dest();
      int read_data(FILE *infile, dbl_llist_manager *eloader);
};


/* *************************************************************
************************************************************* */
class equip_specific_desc {

   public:
      string_type dataname, texname, shadename;
      shading_model mctype;
      vector4f xmx[4];
      vector3f fire_offset;
      int fire_offset_flag;

      equip_specific_desc() { init_mx(xmx); fire_offset_flag = 0; }
      int parse(FILE *infile, char *token);
      void preprocess(void *data);
};


/* *************************************************************
************************************************************* */
class equip_desc {

   public:
      equipment *master_template;
      equip_specific_desc desc;

      equip_desc() { master_template = NULL; }
};


/* *************************************************************
   list of indices into the master equipment list for building an
   equipment list for an object
************************************************************* */
class object_template {

   public:
      
      string_type name;
      float afterburner_burntime;
      int primary_count;
      vector3f *primary_offset;

      int secondary_count;
      vector3f *secondary_offset;

      int count;
      equip_desc *equip_template;

      sound_id_type snd[SOUND_EQUIP_ID_DAMAGE_MAX];

      void init();
      void dest();

      object_template() { init(); }
      virtual ~object_template() { dest(); }

      int read_data(FILE *infile, object_systems *inventory);
};


/* *************************************************************
************************************************************* */
class pilot_template : public dbl_llist {

   protected:
      void parse_voice(FILE *infile, char *token, int index);

   public:
      string_type full_name;
      float avoid_delay;
      float fire_primary_delay;
      float fire_secondary_delay;
      jukebox_manager jukebox[VOICE_PILOT_MAX];
      
      pilot_template() { avoid_delay = fire_primary_delay = fire_secondary_delay = 0; }
      virtual ~pilot_template() {}

      int parse(FILE *infile, char *token);
};

      
/* *************************************************************
   equipment templates for all "objects"
************************************************************* */
class equip_manager {

   public:
      object_systems master_list;
      object_template *master_index;
      dbl_llist_manager pilot_pool;
      int index_count;

      equip_manager() {
         master_index = NULL;
         index_count = 0;
      }

      virtual ~equip_manager() { if (master_index) delete [] master_index; }

      int read_data(char *filename, dbl_llist_manager *eloader);
};


/* *************************************************************
************************************************************* */
class subcat_type : public circular_dbl_llist {

   public:
      equipment *link;
};


/* *************************************************************
************************************************************* */
class subcat_manager_type : public circular_dbl_llist_manager {

   public:
      subcat_type *current;
};


/* *************************************************************
    current state of an object
************************************************************* */
class fighter_desc : public object_desc {

   protected:
      // object_desc
      void remove(equipment *item);

      // fighter_desc
      atom_list_type *owner;
      int  primary_mode;
      sound_id_type sound_id[SOUND_EQUIP_ID_DAMAGE_MAX];

      void set_secondary(subcat_type *secondary);
      void restock(equip_manager *qmaster, gameatom *source);

   public:
      // object_desc
      void init();
      void update(dbl_llist_manager *hiearchy_manager);

      // fighter_desc
      subcat_manager_type equip_stat[MAX_CRADLE];
      int object_id;

      float maxspeed, accel;
      float speed, set_speed_ratio;
      float dorient;
      vector3f vel;

      int armour, max_armour;
      float shields, max_shields, shields_downtime;

      float afterburner_burntime, afterburner_iburntime;
      float afterburner_timer;
      int afterburner_toggle, afterburner_status;
      pilot_template *pilot_param;
      
      fighter_desc() { owner = NULL; pilot_param = NULL; }
      virtual ~fighter_desc() {}

      void build_equip_list(equip_manager *qmaster, atom_list_type *source);

      equip_weapon *query_fire(int type);
      void fire_weapon(target_type *target, vector4f *mx, int type);
      int  apply_damage(unsigned int properties, int *damage, float *pos, vector4f *mx);
      void select_next_weapon(int type);
      void select_secondary(unsigned int type);
      void cycle_status();
      
      void set_primary_mode(int mode) { primary_mode = mode; }
      int query_primary_mode() { return primary_mode; }

      void set_sound(int id, char *filename, unsigned int flags);
      void set_volume(int id, int volume);

      float query_maxspeed();
      float query_accel();
};

#endif

