

#include <stdlib.h>
#include <string.h>

#include "polygon.h"
#include "pstring.h"

#include "fighter.h"
#include "darkgine.h"


#define LINK_DELAY                0.10


/* *************************************************************
************************************************************* */
object_systems::~object_systems() {

    dest();
}


/* *************************************************************
************************************************************* */
void object_systems::dest() {

   int i;

   if (!inventory)
      return;

   for (i=0; i<count; i++)
      delete inventory[i];

   delete [] inventory;

   inventory = NULL;
}


/* *************************************************************
************************************************************* */
int object_systems::read_data(FILE *infile, dbl_llist_manager *eloader) {

   char token[MAXSTRLEN];
   int i;
   equipment *item;

   dest();

   get_token(infile, token);
   count = atoi(token);

   if (!count)
      return 1;

   inventory = new pequipment[count];

   for (i=0; i<count; i++) {

      get_token(infile, token);
      lower_case(token);

      item = ((equipment_loader *)eloader->head)->parse(infile, token);

      if (!item) {
         fprintf(logfile, "Error::object_systems: Invalid equipment type \"%s\"... Aborting...\n", token);
         fclose(infile);

         for (i--; i > -1; i--)
            delete inventory[i];

         delete [] inventory;
         inventory = NULL;
         exit(0);
      }

      item->preprocess(NULL);
      inventory[i] = item;
   }

   return 1;
}


/* *************************************************************
************************************************************* */
int equip_specific_desc::parse(FILE *infile, char *token) {

   if (!strcmp(token, TOKEN_2D_TEXTURE_STR)) {
      get_token(infile, token);
      texname.stringcpy(token);
      return 1;
   }

   if (!strcmp(token, TOKEN_FILE_STR)) {
      get_token(infile, token);
      dataname.stringcpy(token);
      return 1;
   }

   if (!strcmp(token, TOKEN_OFFSET_STR)) {
      fire_offset_flag = 1;

      get_token(infile, token);
      fire_offset[0] = (float)atof(token);

      get_token(infile, token);
      fire_offset[1] = (float)atof(token);

      get_token(infile, token);
      fire_offset[2] = (float)atof(token);

      return 1;
   }

   if (!strcmp(token, TOKEN_SHADE_STR)) {
      get_token(infile, token);
      lower_case(token);

      if (!mctype.parse(token)) {
         fprintf(logfile, "WARNING: Equipment ilm \"%s\" unknown...\n", token);
         mctype.set_master(CONSTANT);
      }

      switch (mctype.query_master()) {
         case BW:
         case WFBW:
         case DOT:
         case PBW:
         case PWFBW:
         case PDOT:
            shadename.string[0] = 0;
            break;

         default:
            get_token(infile, token);
            shadename.stringcpy(token);
	    break;
      }

      return 1;
   }

   if (!strcmp(token, TOKEN_TR_MATRIX_STR)) {
      get_token(infile, token);
      xmx[0][0] = (float)atof(token);
      get_token(infile, token);
      xmx[0][1] = (float)atof(token);
      get_token(infile, token);
      xmx[0][2] = (float)atof(token);
      get_token(infile, token);
      xmx[0][3] = (float)atof(token);

      get_token(infile, token);
      xmx[1][0] = (float)atof(token);
      get_token(infile, token);
      xmx[1][1] = (float)atof(token);
      get_token(infile, token);
      xmx[1][2] = (float)atof(token);
      get_token(infile, token);
      xmx[1][3] = (float)atof(token);

      get_token(infile, token);
      xmx[2][0] = (float)atof(token);
      get_token(infile, token);
      xmx[2][1] = (float)atof(token);
      get_token(infile, token);
      xmx[2][2] = (float)atof(token);
      get_token(infile, token);
      xmx[2][3] = (float)atof(token);

      get_token(infile, token);
      xmx[3][0] = (float)atof(token);
      get_token(infile, token);
      xmx[3][1] = (float)atof(token);
      get_token(infile, token);
      xmx[3][2] = (float)atof(token);
      get_token(infile, token);
      xmx[3][3] = (float)atof(token);

      return 1;
   }

   return 0;
}


/* *************************************************************
************************************************************* */
void equip_specific_desc::preprocess(void *data) {

   antineutron *head;
   polygon *rob;

   if (!dataname.string[0])
      return;

   head = new antineutron;

   ((linktype *)((quark *)data)->edge.head)->link->create_link(head);

   rob = (polygon *)head->get_render_object();

   rob->filename.stringcpy(&dataname);
   rob->colorname.stringcpy(&shadename);

   if (texname.string[0]) {
      rob->texname2.stringcpy(&texname);
      rob->mcinfo.mask_or(CITEXTURE);
   }

   rob->mctype.set_master(mctype.query_master());

   copymx4x4o(head->initxform, xmx);
   head->init_hp = 1;
   head->flags |= GAMEFLAG_DEATHCHECK;
}


/* *************************************************************
************************************************************* */
void object_template::init() {

   equip_template = NULL;
   primary_offset = NULL;
   secondary_offset = NULL;
   name.string[0] = 0;
   afterburner_burntime = 1.0f;
}


/* *************************************************************
************************************************************* */
void object_template::dest() {

   if (equip_template)
      delete [] equip_template;

   if (primary_offset)
      delete [] primary_offset;

   if (secondary_offset)
      delete [] secondary_offset;

   init();
}


/* *************************************************************
************************************************************* */
int object_template::read_data(FILE *infile, object_systems *inventory) {

   char token[MAXSTRLEN];
   int i, j;

   dest();

   get_token(infile, token);
   name.stringcpy(token);

   // "burntime"
   get_token(infile, token);
   get_token(infile, token);
   afterburner_burntime = (float)atof(token);

   // death sound fx
   get_token(infile, token);
   get_token(infile, token);
   snd[SOUND_EQUIP_ID_DEATH].name.stringcpy(token);
   snd[SOUND_EQUIP_ID_DEATH].flags = FLAG_SOUND_WAV;
   
   get_token(infile, token);
   get_token(infile, token);
   snd[SOUND_EQUIP_ID_DEATH].volume(atoi(token));
   
   get_token(infile, token);
   get_token(infile, token);
   snd[SOUND_EQUIP_ID_DAMAGE].name.stringcpy(token);
   snd[SOUND_EQUIP_ID_DAMAGE].flags = FLAG_SOUND_WAV | FLAG_SOUND_3D;

   get_token(infile, token);
   get_token(infile, token);
   snd[SOUND_EQUIP_ID_DAMAGE].volume(atoi(token));

   get_token(infile, token);
   count = atoi(token);

   if (count) {
      equip_template = new equip_desc[count];

      for (i=0; i<count; i++) {
         get_token(infile, token);
         lower_case(token);

         for (j=0; j<inventory->count; j++)
            if (!inventory->inventory[j]->name.stringcmp(token))
               break;

         if (j == inventory->count) {
            fprintf(logfile, "Error::object_template: Invalid equipment type \"%s\"... Aborting...\n", token);
            fclose(infile);
            exit(0);
         }

         equip_template[i].master_template = inventory->inventory[j];

         // read specifics on equipment related to object
         get_token(infile, token);           // left bracket ...

         while (get_token(infile, token) && token[0] != '}') {
            lower_case(token);
            equip_template[i].desc.parse(infile, token);
         }

      }

   }

   get_token(infile, token);
   primary_count = atoi(token);

   if (primary_count) {
      primary_offset = new vector3f[primary_count];

      for (i=0; i<primary_count; i++) {
         get_token(infile, token);
         primary_offset[i][0] = (float)atof(token);
         get_token(infile, token);
         primary_offset[i][1] = (float)atof(token);
         get_token(infile, token);
         primary_offset[i][2] = (float)atof(token);
      }

   }

   get_token(infile, token);
   secondary_count = atoi(token);

   if (secondary_count) {
      secondary_offset = new vector3f[secondary_count];

      for (i=0; i<secondary_count; i++) {
         get_token(infile, token);
         secondary_offset[i][0] = (float)atof(token);
         get_token(infile, token);
         secondary_offset[i][1] = (float)atof(token);
         get_token(infile, token);
         secondary_offset[i][2] = (float)atof(token);
      }

   }

   return 1;
}


/* *************************************************************
************************************************************* */
void pilot_template::parse_voice(FILE *infile, char *token, int index) {

   sound_id_type *sound_id;
   
   get_token(infile, token);
   jukebox[index].append(sound_id = new sound_id_type, NULL);
   sound_id->name.stringcpy(token); 
   get_token(infile, token);
   sound_id->volume(atoi(token));
   sound_id->flags = FLAG_SOUND_WAV | FLAG_SOUND_VOICE;
   complex->soundmanager->find(sound_id);
}


/* *************************************************************
************************************************************* */
int pilot_template::parse(FILE *infile, char *token) {

   if (!strcmp(token, TOKEN_AVOID_STR)) {
      get_token(infile, token);
      avoid_delay = (float)atof(token);
      return 1;
   }
  
   if (!strcmp(token, TOKEN_FIRE_PRIMARY_STR)) {
      get_token(infile, token);
      fire_primary_delay = (float)atof(token);
      return 1;
   }
  
   if (!strcmp(token, TOKEN_FIRE_SECONDARY_STR)) {
      get_token(infile, token);
      fire_secondary_delay = (float)atof(token);
      return 1;
   }

   if (!strcmp(token, TOKEN_COMM_DEATH_STR)) {
      parse_voice(infile, token, VOICE_PILOT_DEATH);
      return 1;
   }

   if (!strcmp(token, TOKEN_COMM_TRAITOR_STR)) {
      parse_voice(infile, token, VOICE_PILOT_TRAITOR);
      return 1;
   }

   if (!strcmp(token, TOKEN_COMM_KILL_STR)) {
      parse_voice(infile, token, VOICE_PILOT_TRIUMPH);
      return 1;
   }

   if (!strcmp(token, TOKEN_COMM_ATTACK_RESPONSE_STR)) {
      parse_voice(infile, token, VOICE_PILOT_DYNAMIC_ATTACK);
      return 1;
   }

   if (!strcmp(token, TOKEN_COMM_ESCORT_RESPONSE_STR)) {
      parse_voice(infile, token, VOICE_PILOT_DYNAMIC_DEFEND);
      return 1;
   }

   if (!strcmp(token, TOKEN_COMM_HELP_RESPONSE_STR)) {
      parse_voice(infile, token, VOICE_PILOT_DYNAMIC_WINGMAN);
      return 1;
   }

   if (!strcmp(token, TOKEN_COMM_BREAK_RESPONSE_STR)) {
      parse_voice(infile, token, VOICE_PILOT_DYNAMIC_RESCIND);
      return 1;
   }

   return 0;  
};

      
/* *************************************************************
************************************************************* */
int equip_manager::read_data(char *filename, dbl_llist_manager *eloader) {

   FILE *infile;
   int i;
   char token[MAXSTRLEN];
   pilot_template *ptr;
   
   infile = fopen(filename, "r");

   if (!infile)
      return 0;

   // read equipment descriptions
   master_list.read_data(infile, eloader);

   // read in object equipment templates
   get_token(infile, token);
   index_count = atoi(token);

   if (!index_count)
      return 1;

   if (master_index)
      delete [] master_index;

   master_index = new object_template[index_count];

   for (i=0; i<index_count; i++)
      master_index[i].read_data(infile, &master_list);

   // read in pilot templates
   pilot_pool.dest();

   get_token(infile, token);

   for (i=atoi(token); i > 0; i--) {
      pilot_pool.append(ptr = new pilot_template, NULL);

      get_token(infile, token);
      ptr->full_name.stringcpy(token);

      get_token(infile, token); // '{'
      
      while (get_token(infile, token) && token[0] != '}') {
         lower_case(token);
         ptr->parse(infile, token);
      }
      
   }
   
   fclose(infile);
   return 1;
}


/* *************************************************************
************************************************************* */
void fighter_desc::init() {

   object_desc::init();

   pilot_param = NULL;

   armour = max_armour = 0;

   shields = max_shields = 0;
   shields_downtime = -1;

   speed = 0.0f;
   maxspeed = 1.0f;
   set_speed_ratio = 0.0f;
   vel[0] = vel[1] = vel[2] = 0.0f;

   accel = 0.0f;
   dorient = 0.0f;

   afterburner_status = 1;
   afterburner_toggle = 0;
   afterburner_timer = 0;

   equip_stat[CRADLE_PRIMARY].current = equip_stat[CRADLE_SECONDARY].current = equip_stat[CRADLE_STATUS_COMPUTER].current = NULL;

   equip_stat[CRADLE_PRIMARY].dest();
   equip_stat[CRADLE_SECONDARY].dest();
   equip_stat[CRADLE_STATUS_COMPUTER].dest();

   primary_mode = PRIMARY_MODE_SINGLE;

   object_id = 0;
   afterburner_burntime = afterburner_iburntime = 1.0f;
}


/* *************************************************************
   update equipment before movement
************************************************************* */
void fighter_desc::update(dbl_llist_manager *hiearchy_manager) {

   float timescale = complex->timer.speedscale;

   object_desc::update(hiearchy_manager);

   if (shields > max_shields)
      shields = max_shields;

   shields_downtime -= timescale;

   // update weapon switch delay
   if (equip_stat[CRADLE_PRIMARY].current)
      ((equip_weapon *)equip_stat[CRADLE_PRIMARY].current->link)->link_delay -= timescale;

   if (equip_stat[CRADLE_SECONDARY].current)
      ((equip_weapon *)equip_stat[CRADLE_SECONDARY].current->link)->link_delay -= timescale;

   // is afterburner on?
   if (afterburner_toggle) {
      if (afterburner_timer < 0) {
         afterburner_timer = complex->timer.speedscale;
         afterburner_status = 1;
      }

      else {
         if (afterburner_status == 1) {
            afterburner_timer += complex->timer.speedscale;
            if (afterburner_timer > afterburner_burntime)
               afterburner_status = -1;
         }

         else {
            afterburner_timer -= complex->timer.speedscale;
            if (afterburner_timer < afterburner_burntime*0.5)
               afterburner_status = 1;
         }

      }

   }

   else
      afterburner_timer -= complex->timer.speedscale;
}


/* *************************************************************
************************************************************* */
void fighter_desc::set_secondary(subcat_type *secondary) {

   int i;
   equip_targeting_computer *tc;
   equip_launcher *weapon = (equip_launcher *)secondary->link;

   weapon->link_delay = (float)LINK_DELAY;
   weapon->current_flag = 1;
   equip_stat[CRADLE_SECONDARY].current = secondary;

   i = weapon->query_guidance();
   if (i) {
      tc = (equip_targeting_computer *)find_specific(EQUIP_TARGETING_COMPUTER);
      if (tc)
         tc->missilelock_time = tc->missilelock_countdown = (float)i;
   }

}


/* *************************************************************
************************************************************* */
void fighter_desc::restock(equip_manager *qmaster, gameatom *source) {

   int primary, secondary;
   int i, j;
   equipment *ptr, *qtr;
   equip_desc *desc;
   subcat_type *str;

   if (!qmaster->master_index[object_id].count)
      return;

   // put weapons into weapon slots
   primary = secondary = 0;
   desc = qmaster->master_index[object_id].equip_template;

   for (i=0; i<qmaster->master_index[object_id].count; i++) {
      inventory.insert(ptr = desc[i].master_template->clone(), NULL);

      // init items
      ptr->reset(source, this);
      desc[i].desc.preprocess(source);

      switch (ptr->query_category()) {
         case EQUIPCAT_PRIMARY_WEAPON:
            if (desc[i].desc.fire_offset_flag) {
               copyarray3(((equip_weapon *)ptr)->offset, desc[i].desc.fire_offset);
            }

            else {
               copyarray3(((equip_weapon *)ptr)->offset, qmaster->master_index[object_id].primary_offset[primary]);
               primary = (primary + 1) % qmaster->master_index[object_id].primary_count;
            }

            equip_stat[CRADLE_PRIMARY].append(str = new subcat_type, NULL);
            str->link = ptr;
            break;

         case EQUIPCAT_SECONDARY_WEAPON:
            if (desc[i].desc.fire_offset_flag) {
               copyarray3(((equip_weapon *)ptr)->offset, desc[i].desc.fire_offset);
            }

            else {
               copyarray3(((equip_weapon *)ptr)->offset, qmaster->master_index[object_id].secondary_offset[secondary]);
               secondary = (secondary + 1) % qmaster->master_index[object_id].secondary_count;
            }

            equip_stat[CRADLE_SECONDARY].append(str = new subcat_type, NULL);
            str->link = ptr;
            break;

         default:
            j = ptr->query_whatami();

            if (j == EQUIP_TARGETING_COMPUTER || j == EQUIP_SYSTEMS_COMPUTER) {
               equip_stat[CRADLE_STATUS_COMPUTER].append(str = new subcat_type, NULL);
               str->link = ptr;
            }

            break;
      }

   }

   for (i=0; i<MAX_CRADLE; i++)
      equip_stat[i].current = (subcat_type *)equip_stat[i].head;

   if (equip_stat[CRADLE_PRIMARY].current)
      ((equip_weapon *)equip_stat[CRADLE_PRIMARY].current->link)->current_flag = 1;

   if (equip_stat[CRADLE_SECONDARY].current)
      set_secondary(equip_stat[CRADLE_SECONDARY].current);

   if (equip_stat[CRADLE_STATUS_COMPUTER].current)
      while (((equip_status_computer *)equip_stat[CRADLE_STATUS_COMPUTER].current->link)->cycle_display())
         equip_stat[CRADLE_STATUS_COMPUTER].current = (subcat_type *)equip_stat[CRADLE_STATUS_COMPUTER].current->next;

   // clear dead weight
   ptr = (equipment *)inventory.head;

   while (ptr) {
      qtr = ptr;
      ptr = (equipment *)ptr->next;

      if (!qtr->hp)
         remove(qtr);
   }

   // misc setup
   hp       = maxhp;
   shields  = max_shields;
   armour   = max_armour;
   afterburner_burntime = qmaster->master_index[object_id].afterburner_burntime;
   afterburner_iburntime = 1.0f/afterburner_burntime;
}


/* *************************************************************
************************************************************* */
void fighter_desc::build_equip_list(equip_manager *qmaster, atom_list_type *source) {

   int i;
    
   // clear object
   init();

   owner = source;

   // define hull type
   for (object_id=0; object_id < qmaster->index_count; object_id++)
      if (!qmaster->master_index[object_id].name.stringcmp(&((fighter *)source->htree)->fighter_name))
         break;

   if (object_id == qmaster->index_count) {
      if (logfile)
         fprintf(logfile, "WARNING:  Object type \"%s\" unidentified... Default setup...\n", ((fighter *)source->htree)->fighter_name.string);

      object_id = 0;
   }

   restock(qmaster, (gameatom *)source->htree);
   
   if (source->htree == global_player)
      for (i=0; i<SOUND_EQUIP_ID_DAMAGE_MAX; i++) {
         sound_id[i].name.stringcpy(&qmaster->master_index[object_id].snd[i].name);
         sound_id[i].flags = qmaster->master_index[object_id].snd[i].flags;
         sound_id[i].volume(qmaster->master_index[object_id].snd[i].db);
         complex->soundmanager->find(&sound_id[i]);
      }

   for (pilot_param = (pilot_template *)qmaster->pilot_pool.head; pilot_param && pilot_param->full_name.stringcmp(&((fighter *)source->htree)->pilot_name); pilot_param = (pilot_template *)pilot_param->next);
}


/* *************************************************************
************************************************************* */
equip_weapon *fighter_desc::query_fire(int type) {

   subcat_type *choice, *ptr;
   equip_weapon *weapon;
   float speed;

   if (!equip_stat[type - EQUIPCAT_PRIMARY_WEAPON].current)
      return NULL;

   if (type == EQUIPCAT_SECONDARY_WEAPON)
      return ((equip_weapon *)equip_stat[CRADLE_SECONDARY].current->link)->query_fire();

   switch (primary_mode) {

      case PRIMARY_MODE_SINGLE:
      case PRIMARY_MODE_ROBIN:
         return ((equip_weapon *)equip_stat[CRADLE_PRIMARY].current->link)->delay <= 0 ? ((equip_weapon *)equip_stat[CRADLE_PRIMARY].current->link)->query_fire() : (equip_weapon *)NULL;

      default: // PRIMARY_MODE_FULL
         choice = NULL;

         ptr = (subcat_type *)equip_stat[CRADLE_PRIMARY].head;
         do {
            weapon = (equip_weapon *)ptr->link;
            if (!weapon->query_fire())
               return NULL;

            // find fastest weapon
            if (!choice || speed < weapon->speed) {
               choice = ptr;
               speed = weapon->speed;
            }

            ptr=(subcat_type *)ptr->next;
         } while (ptr != (subcat_type *)equip_stat[CRADLE_PRIMARY].head);

         return choice ? (equip_weapon *)choice->link : (equip_weapon *)NULL;
   }

}


/* *************************************************************
************************************************************* */
void fighter_desc::select_next_weapon(int type) {

   equip_weapon *weapon;
   int i;

   if (type == EQUIPCAT_PRIMARY_WEAPON)
      primary_mode = PRIMARY_MODE_SINGLE;

   i = type - EQUIPCAT_PRIMARY_WEAPON;
   if (!equip_stat[i].current)
      return;

   if (equip_stat[i].current == (subcat_type *)equip_stat[i].current->next)
      return;

   ((equip_weapon *)equip_stat[i].current->link)->current_flag = 0;

   if (type == EQUIPCAT_SECONDARY_WEAPON) {
      set_secondary((subcat_type *)equip_stat[i].current->next);
      return;
   }

   equip_stat[i].current = (subcat_type *)equip_stat[i].current->next;

   weapon = (equip_weapon *)equip_stat[i].current->link;
   weapon->link_delay = (float)LINK_DELAY;
   weapon->current_flag = 1;
}


/* *************************************************************
************************************************************* */
void fighter_desc::select_secondary(unsigned int type) {

   subcat_type *weapon = NULL;
   subcat_type *ptr;
   int dam;

   if (!equip_stat[CRADLE_SECONDARY].current)
      return;

   switch (type) {

      case SECONDARY_MODE_GUIDED:

         ptr = (subcat_type *)equip_stat[CRADLE_SECONDARY].head;
         do {
            if (((equip_launcher *)ptr->link)->query_guidance()) {
               weapon = ptr;
               break;
            }

            ptr=(subcat_type *)ptr->next;
         } while (ptr != (subcat_type *)equip_stat[CRADLE_SECONDARY].head);

         break;

      case SECONDARY_MODE_MAX_DAMAGE:
         dam = 0;
         ptr = (subcat_type *)equip_stat[CRADLE_SECONDARY].head;
         do {
            if (!weapon || ((equip_launcher *)ptr->link)->max_damage > dam) {
               weapon = ptr;
               dam = ((equip_launcher *)ptr->link)->max_damage;
            }

            ptr=(subcat_type *)ptr->next;
         } while (ptr != (subcat_type *)equip_stat[CRADLE_SECONDARY].head);

         break;

      default: //case SECONDARY_MODE_OTHER:  - guarentees dont fire torpedos by accident unless dont have anything else... (guided and max damage)
         dam = 0;
         ptr = (subcat_type *)equip_stat[CRADLE_SECONDARY].head;
         do {
            if (!weapon || ((equip_launcher *)ptr->link)->max_damage > dam) {
               weapon = ptr;
               dam = ((equip_launcher *)ptr->link)->max_damage;
            }

            ptr=(subcat_type *)ptr->next;
         } while (ptr != (subcat_type *)equip_stat[CRADLE_SECONDARY].head);

         ptr = (subcat_type *)equip_stat[CRADLE_SECONDARY].head;
         do {
            if (ptr != weapon && ((equip_launcher *)ptr->link)->query_guidance()) {
               weapon = ptr;
               break;
            }

            ptr=(subcat_type *)ptr->next;
         } while (ptr != (subcat_type *)equip_stat[CRADLE_SECONDARY].head);

         break;
   }

   if (weapon && weapon != equip_stat[CRADLE_SECONDARY].current) {
      if (equip_stat[CRADLE_SECONDARY].current)
         ((equip_launcher *)equip_stat[CRADLE_SECONDARY].current->link)->current_flag = 0;
      set_secondary(weapon);
   }

}


/* *************************************************************
************************************************************* */
void fighter_desc::cycle_status() {

   if (equip_stat[CRADLE_STATUS_COMPUTER].current)
      while (((equip_status_computer *)equip_stat[CRADLE_STATUS_COMPUTER].current->link)->cycle_display())
         equip_stat[CRADLE_STATUS_COMPUTER].current = (subcat_type *)equip_stat[CRADLE_STATUS_COMPUTER].current->next;
}


/* *************************************************************
************************************************************* */
void fighter_desc::fire_weapon(target_type *target, vector4f *mx, int type) {

   equip_weapon *weapon;
   equipment *ptr, *qtr;

   if (type == EQUIPCAT_SECONDARY_WEAPON) {

      weapon = query_fire(EQUIPCAT_SECONDARY_WEAPON);

      if (weapon) {

         weapon->launch(owner, target, mx);

         if (!weapon->query_active()) {
            hp -= weapon->hp;
            remove(weapon);
         }

      }

      return;
   }

   switch (primary_mode) {

      case PRIMARY_MODE_SINGLE:
         weapon = query_fire(EQUIPCAT_PRIMARY_WEAPON);

         if (!weapon)
            return;

         weapon->launch(owner, target, mx);

         if (!weapon->query_active()) {
            hp -= weapon->hp;
            remove(weapon);
         }

         return;

      case PRIMARY_MODE_ROBIN:
         weapon = query_fire(EQUIPCAT_PRIMARY_WEAPON);

         if (!weapon)
            return;

         weapon->launch(owner, target, mx);

         if (!weapon->query_active()) {
            hp -= weapon->hp;
            remove(weapon);
            return;
         }

         if (equip_stat[CRADLE_PRIMARY].current == (subcat_type *)equip_stat[CRADLE_PRIMARY].current->next)
            return;

         ((equip_weapon *)equip_stat[CRADLE_PRIMARY].current->link)->current_flag = 0;
         equip_stat[CRADLE_PRIMARY].current = (subcat_type *)equip_stat[CRADLE_PRIMARY].current->next;
         weapon = (equip_weapon *)equip_stat[CRADLE_PRIMARY].current->link;
         weapon->link_delay = (float)LINK_DELAY;
         weapon->current_flag = 1;
         return;

      default: // PRIMARY_MODE_FULL
         weapon = query_fire(EQUIPCAT_PRIMARY_WEAPON);

         if (!weapon)
            return;

         ptr = (equipment *)inventory.head;

         while (ptr) {  // Note: cant use circular here - remove()
            qtr = ptr;
            ptr = (equipment *)ptr->next;

            if (qtr->query_category() != EQUIPCAT_PRIMARY_WEAPON)
               continue;

            weapon = (equip_weapon *)qtr;
            weapon->launch(owner, target, mx);

            if (!weapon->query_active()) {
               hp -= weapon->hp;
               remove(weapon);
            }

         }

         return;
   }

}


/* *************************************************************
************************************************************* */
int fighter_desc::apply_damage(unsigned int properties, int *damage, float *pos, vector4f *mx) {

   int amount;
   int i, j;
   union {equipment *item; equip_shields *shield; };
   int ret;
   
   if (*damage <= 0) {
      *damage = 0;
      return 0;
   }

   shield = (equip_shields *)find_specific(EQUIP_SHIELDS);

   // Note: shield sound played by f/x
   if (shield && shields_downtime <= 0) {

      shield->activate((gameatom *)owner->htree, mx, pos);

      i = (int)shields;
      if (i > *damage) {
         shields -= *damage;
         *damage = 0;
         return 0;
      }

      *damage -= i;
      shields = 0;

      shields_downtime = shield->downtime;
   }

   ret = *damage;

   if (armour > *damage) {
      armour -= *damage;
      *damage = 0;

      complex->soundmanager->play(&sound_id[SOUND_EQUIP_ID_DAMAGE]);
      return ret;
   }

   if (armour) {
      *damage -= armour;
      armour = 0;
   }

   j = 0;

   while (*damage && inventory.count) {

      if (*damage <= 5)
         amount = *damage;
      else if (*damage <= 10)
         amount = 5;
      else
         amount = (*damage) >> 1;

      *damage -= amount;

      i = (rand() % inventory.count);

      for (item=(equipment *)inventory.head; i; item=(equipment *)item->next, i--);

      item->apply_damage(&amount);
      *damage += amount;

      if (!item->hp) {
         remove(item);
         j = 1;
      }

   }

   if (j)
      complex->soundmanager->play(&sound_id[SOUND_EQUIP_ID_DEATH]);
   else
      ((player *)owner->htree)->attach_sound(&sound_id[SOUND_EQUIP_ID_DAMAGE], pos);

   return ret - *damage;
}


/* *************************************************************
************************************************************* */
void fighter_desc::remove(equipment *item) {

   subcat_type *ptr;
   int cat;

   cat = item->query_category();

   if (cat == EQUIPCAT_SECONDARY_WEAPON) {
      ptr = equip_stat[CRADLE_SECONDARY].current;
      
      if (item == ptr->link)
         if (ptr != (subcat_type *)ptr->next)
            set_secondary((subcat_type *)ptr->next);
         else
            equip_stat[CRADLE_SECONDARY].current = (subcat_type *)NULL;
      else
         for (ptr=(subcat_type *)equip_stat[CRADLE_SECONDARY].head; ptr->link != item; ptr=(subcat_type *)ptr->next);
	 
      equip_stat[CRADLE_SECONDARY].remove(ptr);
      delete ptr;
   }

   else if (cat == EQUIPCAT_PRIMARY_WEAPON) {
      ptr = equip_stat[CRADLE_PRIMARY].current;

      if (item == ptr->link)
         if (ptr != (subcat_type *)ptr->next) {
            equip_stat[CRADLE_PRIMARY].current = (subcat_type *)ptr->next;
            ((equip_weapon *)((subcat_type *)ptr->next)->link)->link_delay = (float)LINK_DELAY;
            ((equip_weapon *)((subcat_type *)ptr->next)->link)->current_flag = 1;
         }

         else
            equip_stat[CRADLE_PRIMARY].current = (subcat_type *)NULL;
      else
         for (ptr=(subcat_type *)equip_stat[CRADLE_PRIMARY].head; ptr->link != item; ptr=(subcat_type *)ptr->next);

      equip_stat[CRADLE_PRIMARY].remove(ptr);
      delete ptr;
   }

   else {
      cat = item->query_whatami();

      if (cat == EQUIP_TARGETING_COMPUTER || cat == EQUIP_SYSTEMS_COMPUTER) {
         ptr = equip_stat[CRADLE_STATUS_COMPUTER].current;

         if (item == ptr->link)
            if (ptr != (subcat_type *)ptr->next) {
               equip_stat[CRADLE_STATUS_COMPUTER].current = (subcat_type *)ptr->next;
               ((equip_status_computer *)((subcat_type *)ptr->next)->link)->current_flag = 1;
            }
	    
            else
               equip_stat[CRADLE_STATUS_COMPUTER].current = (subcat_type *)NULL;
      else
         for (ptr=(subcat_type *)equip_stat[CRADLE_STATUS_COMPUTER].head; ptr->link != item; ptr=(subcat_type *)ptr->next);

         equip_stat[CRADLE_STATUS_COMPUTER].remove(ptr);
         delete ptr;
      }

   }

   object_desc::remove(item);
}


/* *************************************************************
************************************************************* */
float fighter_desc::query_maxspeed() {

   if (maxspeed < 1.1f)
      return maxspeed;

   if (afterburner_toggle && afterburner_status == 1)
      return maxspeed+maxspeed;
   
   if (afterburner_timer > 0)
      return maxspeed + maxspeed * afterburner_timer*afterburner_iburntime;

   return maxspeed;
}


/* *************************************************************
************************************************************* */
float fighter_desc::query_accel() {

   if (maxspeed < 1.1f)
      return accel;

   if (afterburner_toggle && afterburner_status == 1)
      return accel+accel;
   
   if (afterburner_timer > 0)
      return accel + accel * afterburner_timer*afterburner_iburntime;

   return accel;
}

