

#if !defined __DARKBRAIN_H
#define __DARKBRAIN_H

#include "brain.h"
#include "fxman.h"


/* *****************************************************************************
***************************************************************************** */
class smart_targeting_pathway {

   protected:
     int target_priority[MAX_TARGET_TYPE];
      int count;
      gameatom *source_atom;
      unsigned int target_alliance;
      float range;
      target_type last;

   public:
      smart_targeting_pathway() { count = 0; source_atom = NULL; range = -1; }

      int  parse(FILE *infile, char *token);

      void set_source(gameatom *child) { source_atom = child; }
      void set_target_alliance(unsigned int x) { target_alliance = x; }

      virtual ~smart_targeting_pathway() {}
      
      void set_range(float distance) { range = distance; }
      int  set_target_slot(int slot, unsigned int type);
      void get_next_target(dbl_llist_manager *hiearchy_manager, fxmanager *props, target_type *target);
      void get_nearest_target(dbl_llist_manager *hiearchy_manager, fxmanager *props, target_type *target);
};

#endif

