

#include <stdlib.h>
#include <string.h>

#include "pstring.h"

#include "darkgine.h"
#include "darkbrai.h"


/* *****************************************************************************
***************************************************************************** */
int smart_targeting_pathway::parse(FILE *infile, char *token) {

   if (!strcmp(token, TOKEN_TARGET_TYPE_STR)) {
      get_token(infile, token);
      lower_case(token);

      if (!strcmp(token, TOKEN_FIGHTER_STR)) {
         get_token(infile, token);
         set_target_slot(atoi(token), TARGETFLAG_FIGHTER);
         return 1;
      }

      if (!strcmp(token, TOKEN_BOMBER_STR)) {
         get_token(infile, token);
         set_target_slot(atoi(token), TARGETFLAG_BOMBER);
         return 1;
      }

      if (!strcmp(token, TOKEN_STATION_STR)) {
         get_token(infile, token);
         set_target_slot(atoi(token), TARGETFLAG_STATION);
         return 1;
      }

      if (!strcmp(token, TOKEN_CAPSHIP_STR)) {
         get_token(infile, token);
         set_target_slot(atoi(token), TARGETFLAG_CAPSHIP);
         return 1;
      }

      if (!strcmp(token, TOKEN_TURRENT_STR)) {
         get_token(infile, token);
         set_target_slot(atoi(token), TARGETFLAG_TURRENT);
         return 1;
      }

      if (!strcmp(token, TOKEN_MISSILE_STR)) {
         get_token(infile, token);
         set_target_slot(atoi(token), TARGETFLAG_MISSILE);
         return 1;
	  }

      if (!strcmp(token, TOKEN_MINE_STR)) {
         get_token(infile, token);
         set_target_slot(atoi(token), TARGETFLAG_MINE);
         return 1;
      }

      get_token(infile, token);
   }

   return 0;
}


/* *****************************************************************************
***************************************************************************** */
int smart_targeting_pathway::set_target_slot(int slot, unsigned int type) {

   if (slot >= MAX_TARGET_TYPE)
      return 0;

   if (slot >= count)
      count = slot+1;

   target_priority[slot] = type;
   return 1;
}


/* *****************************************************************************
***************************************************************************** */
void smart_targeting_pathway::get_next_target(dbl_llist_manager *hiearchy_manager, fxmanager *props, target_type *target) {

   master_targeting_pathway atom_detector;
   sub_targeting_pathway subatom_detector;
   type_targeting_pathway quark_detector;

   int i;

   for (i=0; i<count; i++)
      switch (target_priority[i]) {

         case TARGETFLAG_FIGHTER:
            atom_detector.init();
            atom_detector.set_mask(target_alliance | GAMEFLAG_FIGHTER, 0);
            atom_detector.set_source(source_atom);
            atom_detector.set_range(range);
            atom_detector.set_last(&last);
            atom_detector.get_next_target(hiearchy_manager, target);   
			
            if (target->object) {
               subatom_detector.init();
               subatom_detector.get_next_subtarget(target->object, target);
               if (target->specific) {
                  last = *atom_detector.get_last();
                  return;
               }

            }

            break;
	    
         case TARGETFLAG_BOMBER:
            atom_detector.init();
            atom_detector.set_mask(target_alliance | GAMEFLAG_BOMBER, 0);
            atom_detector.set_source(source_atom);
            atom_detector.set_range(range);
            atom_detector.set_last(&last);
            atom_detector.get_next_target(hiearchy_manager, target);   
   
            if (target->object) {
               subatom_detector.init();
               subatom_detector.get_next_subtarget(target->object, target);
               if (target->specific) {
                  last = *atom_detector.get_last();
                  return;
               }

            }

            break;

         case TARGETFLAG_STATION:
            atom_detector.init();
            atom_detector.set_mask(target_alliance | GAMEFLAG_STATION, 0);
            atom_detector.set_source(source_atom);
            atom_detector.set_range(range);
            atom_detector.set_last(&last);
            atom_detector.get_next_target(hiearchy_manager, target);   
   
            if (target->object) {
               subatom_detector.init();
               subatom_detector.get_next_subtarget(target->object, target);
               if (target->specific) {
                  last = *atom_detector.get_last();
                  return;
               }

            }

            break;

         case TARGETFLAG_CAPSHIP:
            atom_detector.init();
            atom_detector.set_mask(target_alliance | GAMEFLAG_CAPSHIP, 0);
            atom_detector.set_source(source_atom);
            atom_detector.set_range(range);
            atom_detector.set_last(&last);
            atom_detector.get_next_target(hiearchy_manager, target);   
   
            if (target->object) {
               subatom_detector.init();
               subatom_detector.get_next_subtarget(target->object, target);
               if (target->specific) {
                  last = *atom_detector.get_last();
                  return;
               }

            }

            break;

         case TARGETFLAG_TURRENT:
            quark_detector.init();
            quark_detector.set_mask(target_alliance, 0);
            quark_detector.set_source(source_atom);
            quark_detector.set_target_type(OBJECT_TURRENT);
            quark_detector.set_range(range);
            quark_detector.set_last(&last);
            quark_detector.get_next_target(hiearchy_manager, target);   

            if (target->specific) {
               last = *quark_detector.get_last();
               return;
            }

            break;

/* asdf
         case TARGETFLAG_MINE:
            quark_detector.init();
            quark_detector.set_mask(target_alliance, 0);
            quark_detector.set_source(source_atom);
            quark_detector.set_target_type(OBJECT_MINE);
            quark_detector.set_range(range);
            quark_detector.set_last(&last);
            quark_detector.get_next_target(hiearchy_manager, target);   

            if (target->specific) {
               last = *quark_detector.get_last();
               return;
            }

            break;

         case TARGETFLAG_MISSILE:
            quark_detector.init();
            quark_detector.set_mask(target_alliance, 0);
            quark_detector.set_source(source_atom);
            quark_detector.set_target_type(OBJECT_MISSILE);
            quark_detector.set_range(range);
            quark_detector.set_last(&last);
            quark_detector.get_next_target(hiearchy_manager, target);   

            if (target->specific) {
               last = *quark_detector.get_last();
               return;
            }

            break;
*/

         default:
            break;
     }

   // last ditch attempt
   atom_detector.init();
   atom_detector.set_mask(target_alliance, 0);
   atom_detector.set_source(source_atom);
   atom_detector.set_range(range);
   atom_detector.set_last(&last);
   atom_detector.get_next_target(hiearchy_manager, target);   
   last = *atom_detector.get_last();
   
   if (target->object) {
      subatom_detector.init();
      subatom_detector.get_next_subtarget(target->object, target);
   }

}


/* *****************************************************************************
***************************************************************************** */
void smart_targeting_pathway::get_nearest_target(dbl_llist_manager *hiearchy_manager, fxmanager *props, target_type *target) {

   master_targeting_pathway atom_detector;
   sub_targeting_pathway subatom_detector;
   type_targeting_pathway quark_detector;

   int i;

   for (i=0; i<count; i++)
      switch (target_priority[i]) {

         case TARGETFLAG_FIGHTER:
            atom_detector.init();
            atom_detector.set_mask(target_alliance | GAMEFLAG_FIGHTER, 0);
            atom_detector.set_source(source_atom);
            atom_detector.set_range(range);
            atom_detector.set_last(&last);
            atom_detector.get_nearest_target(hiearchy_manager, target);   
			
            if (target->object) {
               subatom_detector.init();
               subatom_detector.get_next_subtarget(target->object, target);
               if (target->specific) {
                  last = *atom_detector.get_last();
                  return;
               }

            }

            break;
	    
         case TARGETFLAG_BOMBER:
            atom_detector.init();
            atom_detector.set_mask(target_alliance | GAMEFLAG_BOMBER, 0);
            atom_detector.set_source(source_atom);
            atom_detector.set_range(range);
            atom_detector.set_last(&last);
            atom_detector.get_nearest_target(hiearchy_manager, target);   
   
            if (target->object) {
               subatom_detector.init();
               subatom_detector.get_next_subtarget(target->object, target);
               if (target->specific) {
                  last = *atom_detector.get_last();
                  return;
               }

            }

            break;

         case TARGETFLAG_STATION:
            atom_detector.init();
            atom_detector.set_mask(target_alliance | GAMEFLAG_STATION, 0);
            atom_detector.set_source(source_atom);
            atom_detector.set_range(range);
            atom_detector.set_last(&last);
            atom_detector.get_nearest_target(hiearchy_manager, target);   
   
            if (target->object) {
               subatom_detector.init();
               subatom_detector.get_next_subtarget(target->object, target);
               if (target->specific) {
                  last = *atom_detector.get_last();
                  return;
               }

            }

            break;

         case TARGETFLAG_CAPSHIP:
            atom_detector.init();
            atom_detector.set_mask(target_alliance | GAMEFLAG_CAPSHIP, 0);
            atom_detector.set_source(source_atom);
            atom_detector.set_range(range);
            atom_detector.set_last(&last);
            atom_detector.get_nearest_target(hiearchy_manager, target);   
   
            if (target->object) {
               subatom_detector.init();
               subatom_detector.get_next_subtarget(target->object, target);
               if (target->specific) {
                  last = *atom_detector.get_last();
                  return;
               }

            }

            break;

         case TARGETFLAG_TURRENT:
            quark_detector.init();
            quark_detector.set_mask(target_alliance, 0);
            quark_detector.set_source(source_atom);
            quark_detector.set_target_type(OBJECT_TURRENT);
            quark_detector.set_range(range);
            quark_detector.set_last(&last);
            quark_detector.get_nearest_target(hiearchy_manager, target);   

            if (target->specific) {
               last = *quark_detector.get_last();
               return;
            }

            break;

/* asdf
         case TARGETFLAG_MINE:
            quark_detector.init();
            quark_detector.set_mask(target_alliance, 0);
            quark_detector.set_source(source_atom);
            quark_detector.set_target_type(OBJECT_MINE);
            quark_detector.set_range(range);
            quark_detector.set_last(&last);
            quark_detector.get_nearest_target(hiearchy_manager, target);   

            if (target->specific) {
               last = *quark_detector.get_last();
               return;
            }

            break;

         case TARGETFLAG_MISSILE:
            quark_detector.init();
            quark_detector.set_mask(target_alliance, 0);
            quark_detector.set_source(source_atom);
            quark_detector.set_target_type(OBJECT_MISSILE);
            quark_detector.set_range(range);
            quark_detector.set_last(&last);
            quark_detector.get_nearest_target(hiearchy_manager, target);   

            if (target->specific) {
               last = *quark_detector.get_last();
               return;
            }

            break;
*/

         default:
            break;
   }

   // last ditch attempt
   atom_detector.init();
   atom_detector.set_mask(target_alliance, 0);
   atom_detector.set_source(source_atom);
   atom_detector.set_range(range);
   atom_detector.set_last(&last);
   atom_detector.get_nearest_target(hiearchy_manager, target);   
   last = *atom_detector.get_last();
   
   if (target->object) {
      subatom_detector.init();
      subatom_detector.get_next_subtarget(target->object, target);
   }

}

