

#if !defined __CAM_AI_H
#define __CAM_AI_H

#include "follow.h"

#define VIEW_FORWARD    0
#define VIEW_BACKWARD   1
#define VIEW_LEFT       2
#define VIEW_RIGHT      3
#define VIEW_CHASE      4

/* *************************************************************
   assumed to be the last atom on the list of atoms / first one read in
************************************************************* */
class camera_control : public gameatom {

   protected:
      string_type actor_name, target_name;
      target_type target;
      vector3f internal_xyz, internal_rph;
      vector4f internal_state[4];
      float hat_yaw, hat_pitch;
      int view_type;
      vector4f offset;
      int default_offset;
      vector4f world_mx[4];
      
      int process_view();
      void target_lock(float *offset, float *orient, int offset_flag);

   public:
      // superclass
      int  query_whatami() { return OBJECT_CAMERA_CONTROL; }
      int  query_whatwasi(int type);
      void preprocess(void *data);
      int  parse(FILE *infile, char *token);

      // quark
      void begin(dbl_llist_manager *hiearchy_manager, quark *parent, vector4f *mx);
      void whereami(dbl_llist_manager *hiearchy_manager, quark *parent, vector4f *mx);
      void update(dbl_llist_manager *hiearchy_manager, quark *parent);

      // camera_control
      camera_control();
      virtual ~camera_control() {}
      
      void set_target(char *atomname, char *quarkname, float *offset, float *orient, int offset_flag);
      void set_target(target_type *object, float *offset, float *orient, int offset_flag);
      int query_view_type() { return view_type; }
      target_type *query_target() { return &target; }
};


/* ****************************************************************
**************************************************************** */
class camera_control_loader : public quark_loader {

   public:
      superclass *make_object() { return new camera_control; }
      camera_control_loader() { object_name = alias_name  = TOKEN_CAMERA_CONTROL_STR; }
      
      virtual ~camera_control_loader() {}
};

#endif
