

#include <stdlib.h>
#include <string.h>

#include "darkgine.h"
#include "cam_ai.h"
#include "pstring.h"


#define CAMERA_EXTERNAL     -1
#define CAMERA_INTERNAL     1


/* *************************************************************
************************************************************* */
camera_control::camera_control() {

   init_mx(internal_state);
   default_offset = 1;
}


/* *************************************************************
************************************************************* */
int camera_control::query_whatwasi(int type) {

   return (camera_control::query_whatami() == type) ? 1 : gameatom::query_whatwasi(type);
}


/* ********************************************************
   update data with new event
******************************************************** */
int camera_control::parse(FILE *infile, char *token) {

   if (!strcmp(token, TOKEN_FOLLOW_STR)) {       // change parent of a child
      get_token(infile, token);
      actor_name.stringcpy(token);
      get_token(infile, token);
      target_name.stringcpy(token);

      get_token(infile, token);
      lower_case(token);

      if (strcmp(token, TOKEN_DEFAULT_STR)) {

         internal_xyz[0] = (float)atof(token);
         get_token(infile, token);
         internal_xyz[1] = (float)atof(token);
         get_token(infile, token);
         internal_xyz[2] = (float)atof(token);

         get_token(infile, token);
         internal_rph[0] = (float)deg2rad(atof(token));
         get_token(infile, token);
         internal_rph[1] = (float)deg2rad(atof(token));
         get_token(infile, token);
         internal_rph[2] = (float)deg2rad(atof(token));

         default_offset = 0;
      }

      else
         default_offset = 1;      

      strcpy(token, target_name.string);
      lower_case(token);

      if (!strcmp(token, TOKEN_NULL_STR))
         target_name.stringcpy((char *)NULL);

      target.object = NULL;
      target.specific_parent = NULL;
      target.specific = NULL;

      return 1;
   }

   if (!strcmp(token, TOKEN_NOFOLLOW_STR)) {       // change parent of a child
      target.object = NULL;
      target.specific_parent = NULL;
      target.specific = NULL;
      actor_name.stringcpy((char *)NULL);
      target_name.stringcpy((char *)NULL);
      return 1;
   }

   return gameatom::parse(infile, token);
}


/* *************************************************************
************************************************************* */
void camera_control::preprocess(void *data) {

   gameatom::preprocess(data);

   view_type = VIEW_FORWARD;
   init_mx(initxform);
   hat_yaw = hat_pitch = 0;
}


/* *************************************************************
************************************************************* */
void camera_control::begin(dbl_llist_manager *hiearchy_manager, quark *parent, vector4f *mx) {

   whereami(hiearchy_manager, parent, mx);
}


/* *************************************************************
************************************************************* */
void camera_control::whereami(dbl_llist_manager *hiearchy_manager, quark *parent, vector4f *mx) {

   copymx4x4o(world_mx, mx);
}

/* *************************************************************
************************************************************* */
void camera_control::update(dbl_llist_manager *hiearchy_manager, quark *parent) {

   vector4f nmx[4];                       // local xform mx
   vector4f delta;
   linktype *ptr;
   vector4f dest, tempv;
   float tempf, t, chase_dist;
   atom_list_type *atr;

   if (flags & QUARK_FLAG_ACTIVE) {

      if (!target.object && actor_name.string[0]) {

         for (atr=(atom_list_type *)hiearchy_manager->head; atr && atr->htree->name.stringcmp(&actor_name); atr = (atom_list_type *)atr->next);

         target.object = atr;

         if (!target_name.string[0])
            target_lock(internal_xyz, internal_rph, default_offset);
         else if (atr) {
            target.specific = atr->htree->find(NULL, target_name.string, &target.specific_parent);
            target_lock(internal_xyz, internal_rph, default_offset);
         }

      }

      if (target.object) {
         process_view();

         switch (view_type) {

            case VIEW_CHASE:

               if (!target.object->htree->query_specific_data(DATAFLAG_FOLLOW_DISTANCE, &chase_dist))
	          chase_dist = 0;
	       
//               target.specific ? transpose(nmx, target.specific->state.node) : transpose(nmx, target.object->state.node);
               target.specific ? transpose(nmx, target.specific->old_state.node) : transpose(nmx, target.object->htree->old_state.node);
               normalize3(nmx[0]);
               normalize3(nmx[1]);
               normalize3(nmx[2]);
               transpose(nmx);

               tempv[0] = -nmx[0][2];
               tempv[1] = -nmx[1][2];
               tempv[2] = -nmx[2][2];

               tempf = complex->timer.speedscale + complex->timer.speedscale;

               if (tempf >= ICORRECT) {
                  copyarray3(offset, tempv);
               }

               else {
                  inversemxrt(nmx, state.node);
                  matvecmultv(state.node, offset, dest);

                  if (fabs(dest[2]) < 0.7071) {
                     dest[2] = -0.7071f;
                     normalize3(dest);
                  }

                  else if (dest[2] > 0)
                     dest[2] = -dest[2];

                  tempv[0] = 0.0f;
                  tempv[1] = 0.0f;
                  tempv[2] = -1.0f;

                  vector_interp_setup(dest, tempv, 3, 1.0, delta, &t);

                  tempf *= delta[3];
                  delta[0] -= tempf;
                  delta[1] += tempf;

                  vector_interp_eval(dest, tempv, 3, delta, offset);
                  matvecmultv(nmx, offset);
               }

               // recalc orientation
               state.node[3][0] = nmx[0][3] + offset[0] * chase_dist;
               state.node[3][1] = nmx[1][3] + offset[1] * chase_dist;
               state.node[3][2] = nmx[2][3] + offset[2] * chase_dist;
               state.node[3][3] = 1.0f;

               state.node[2][0] = -offset[0];
               state.node[2][1] = -offset[1];
               state.node[2][2] = -offset[2];
               state.node[2][3] = 0.0f;

               dest[0] = nmx[0][1];
               dest[1] = nmx[1][1];
               dest[2] = nmx[2][1];

               xproduct(state.node[0], dest, state.node[2]);
               normalize3(state.node[0]);
               state.node[0][3] = 0;
               xproduct(state.node[1], state.node[2], state.node[0]);
               state.node[1][3] = 0;

               transpose(state.node);
               break;

            case VIEW_FORWARD:
               target.specific ? matmatmulto(target.specific->old_state.node, internal_state, state.node) : matmatmulto(target.object->htree->old_state.node, internal_state, state.node);
               arotate_mx_y(state.node, hat_yaw);
               arotate_mx_x(state.node, hat_pitch);
               break;

            default:
//            case VIEW_BACKWARD:
               target.specific ? matmatmulto(target.specific->old_state.node, initxform, state.node) : matmatmulto(target.object->htree->old_state.node, initxform, state.node);
               break;
         }

         // backup local state
         inversemx(world_mx, nmx);
         matmatmulto(nmx, state.node, localmx);
      }
      
      else
         matmatmulto(world_mx, localmx, state.node);
   }

   else
      matmatmulto(world_mx, localmx, state.node);
   
   copymx4x4o(state.xmx, state.node);

   for (ptr=(linktype *)edge.head; ptr; ptr=(linktype *)ptr->next)
      if (ptr->link != parent)
         ptr->link->whereami(hiearchy_manager, this, state.node);

   state.center[0] = state.xmx[0][3];
   state.center[1] = state.xmx[1][3];
   state.center[2] = state.xmx[2][3];
   
   gameatom::update(hiearchy_manager, parent);
}


/* *************************************************************
    return 1 - turn on camera
    return -1 - turn off camera
************************************************************* */
int camera_control::process_view() {

   float limit;

   if (complex->userinput->translate(KEYSTROKE_VIEW_FORWARD)) {
      if (view_type == VIEW_FORWARD)
         return 0;

      view_type = VIEW_FORWARD;
      hat_pitch = hat_yaw = 0;
      return CAMERA_INTERNAL;
   }

   if (complex->userinput->translate(KEYSTROKE_VIEW_BACKWARD)) {
      if (view_type == VIEW_BACKWARD)
         return 0;

      view_type = VIEW_BACKWARD;
      copymx4x4o(initxform, internal_state);
      arotate_mx_y(initxform, PI);
      return CAMERA_INTERNAL;
   }

   if (complex->userinput->translate(KEYSTROKE_VIEW_CHASE)) {
      if (view_type == VIEW_CHASE)
         return 0;

      view_type = VIEW_CHASE;
      offset[0] = -old_state.xmx[0][2];
      offset[1] = -old_state.xmx[1][2];
      offset[2] = -old_state.xmx[2][2];

      return CAMERA_EXTERNAL;
   }

   // hat controls
   if (view_type == VIEW_FORWARD) {
      if (complex->userinput->povdegree >= 315.0 ||
          (complex->userinput->povdegree >= 0.0f && complex->userinput->povdegree < 45.0)) {
         hat_pitch += complex->timer.speedscale*HALFPI;
         if (hat_pitch > 0)
            hat_pitch = 0;
      }

      else if (complex->userinput->povdegree >= 135.0f && complex->userinput->povdegree < 225.0) {
         limit = HALFPI*0.8;
         hat_pitch -= complex->timer.speedscale*limit;
         if (hat_pitch < -limit)
            hat_pitch = -limit;
      }

      else if (complex->userinput->povdegree >= 45.0f && complex->userinput->povdegree < 135.0) {
         hat_yaw -= complex->timer.speedscale*HALFPI;
         if (hat_yaw < -HALFPI)
            hat_yaw = -HALFPI;
      }

      else if (complex->userinput->povdegree >= 225.0f && complex->userinput->povdegree < 315.0) {
         hat_yaw += complex->timer.speedscale*HALFPI;
         if (hat_yaw > HALFPI)
            hat_yaw = HALFPI;
      }

      else if (!complex->userinput->translate(KEYSTROKE_HAT_LOCK)) {

         if (hat_yaw > 0) {
            hat_yaw -= (float)(complex->timer.speedscale*HALFPI*0.5);
            if (hat_yaw < 0)
                hat_yaw = 0;
         }

         else {
            hat_yaw += (float)(complex->timer.speedscale*HALFPI*0.5);
            if (hat_yaw > 0)
                hat_yaw = 0;
         }

         if (hat_pitch < 0) {
            hat_pitch += (float)(complex->timer.speedscale*HALFPI*0.4);
            if (hat_pitch > 0)
                hat_pitch = 0;
         }

      }

   }

   return 0;
}


/* ********************************************************
******************************************************** */
void camera_control::set_target(char *atomname, char *quarkname, float *offset, float *orient, int offset_flag) {

   target.object = NULL;
   target.specific_parent = NULL;
   target.specific = NULL;

   if (!atomname) {
      actor_name.stringcpy((char *)NULL);
      target_name.stringcpy((char *)NULL);
      return;
   }      

   if (offset_flag)
      default_offset = 1;
   else {
      default_offset = 0;
      copyarray3(internal_xyz, offset);
      copyarray3(internal_rph, orient);
   }
   
   actor_name.stringcpy(atomname);
   target_name.stringcpy(quarkname);
}


/* ********************************************************
******************************************************** */
void camera_control::set_target(target_type *object, float *offset, float *orient, int offset_flag) {

   target.object = object->object;
   target.specific_parent = object->specific_parent;
   target.specific = object->specific;

   target_lock(offset, orient, offset_flag);
   
   if (!target.object) {
      actor_name.stringcpy((char *)NULL);
      target_name.stringcpy((char *)NULL);
      return;
   }      

   actor_name.stringcpy(&target.object->htree->name);

   if (!object->specific)
      target_name.stringcpy((char *)NULL);
   else   
      target_name.stringcpy(&target.object->htree->name);
}


/* ********************************************************
******************************************************** */
void camera_control::target_lock(float *offset, float *orient, int offset_flag) {

   float *camera_offset;
   quark *object = target.specific ? target.specific : target.object->htree;

   if (!target.object)
      return;

   if (offset_flag) {
      default_offset = 1;
      if (object->query_specific_data(DATAFLAG_DEFAULT_CAMERA_STATE, &camera_offset)) { 
         copyarray3(internal_xyz, camera_offset);
         camera_offset +=3;
         copyarray3(internal_rph, camera_offset);
      }
      
      else {
         internal_xyz[0] = internal_xyz[1] = internal_xyz[2] = 0;
         internal_rph[0] = internal_rph[1] = internal_rph[2] = 0;
      }
      
   }
   
   else {
      default_offset = 0;
      copyarray3(internal_xyz, offset);
      copyarray3(internal_rph, orient);
   }

   init_mx(internal_state);
   rotate_mx_z(internal_state, internal_rph[0]);   
   rotate_mx_x(internal_state, internal_rph[1]);   
   rotate_mx_y(internal_state, internal_rph[2]);   

   internal_state[0][3] = internal_xyz[0];
   internal_state[1][3] = internal_xyz[1];
   internal_state[2][3] = internal_xyz[2];
}

