

#include <stdlib.h>

#include "global.h"
#include "pstring.h"

#include "convert.h"


/* ******************************************************
****************************************************** */
int slide_converter::read_data(char *filename) {

   FILE *infile;
   char token[MAXSTRLEN];
   vector4f vector;
   int i, j;
   int countvertex;
   facet_type *ftr, *gtr;
   cvertex_type *vtr, *wtr;
   cedge_type *etr;
   
   if (!find_file(filename, "r", OBJECT_PATH.string, (char)PLATFORM_SLASH, NULL, &infile))
      return 0;
      
   // dx
   get_token(infile, token);
   vector[0] = (float)atof(token);

   // dy
   get_token(infile, token);
   vector[1] = (float)atof(token);

   // dz
   get_token(infile, token);
   vector[2] = (float)atof(token);

   // length
   get_token(infile, token);
   vector[3] = (float)atof(token);

   normalize3(vector);
   smultarray3(vector, vector[3]);

   // read vertex count
   get_token(infile, token);
   countvertex = atoi(token);
   
   if (countvertex < 2) {
      printf("Sliders must have at least 2 vertices... Aborting...\n");
      return 0;
   }

   // front verticies
   for (i=0; i<countvertex; i++) {
      vlist.append(vtr = new cvertex_type, NULL);

      get_token(infile, token);
      vtr->v[0] = (float)atof(token);

      get_token(infile, token);
      vtr->v[1] = (float)atof(token);

      get_token(infile, token);
      vtr->v[2] = (float)atof(token);

      vtr->v[3] = 1.0f;
   }

   // back verticies      
   for (i=0, vtr = (cvertex_type *)vlist.head; i<countvertex; i++, vtr = (cvertex_type *)vtr->next) {
      vlist.append(wtr = new cvertex_type, NULL);
      addeqarray3(wtr->v, vtr->v, vector);
      wtr->v[3] = 1.0f;
   }

   // front/back face      
   flist.append(ftr = new facet_type, NULL);
   flist.append(gtr = new facet_type, NULL);

   for (i=0, j=countvertex-1; i<countvertex; i++) {
      ftr->elist.append(etr = new cedge_type, NULL);
      etr->index = i;
      
      gtr->elist.append(etr = new cedge_type, NULL);
      etr->index = j - i;
   }

   for (i=0; i<countvertex-1; i++) {
      flist.append(ftr = new facet_type, NULL);

      ftr->elist.append(etr = new cedge_type, NULL);
      etr->index = i;
      ftr->elist.append(etr = new cedge_type, NULL);
      etr->index = i+countvertex;
      ftr->elist.append(etr = new cedge_type, NULL);
      etr->index = i+countvertex+1;
      ftr->elist.append(etr = new cedge_type, NULL);
      etr->index = i+1;
   }

   flist.append(ftr = new facet_type, NULL);

   ftr->elist.append(etr = new cedge_type, NULL);
   etr->index = i;
   ftr->elist.append(etr = new cedge_type, NULL);
   etr->index = vlist.count-1;
   ftr->elist.append(etr = new cedge_type, NULL);
   etr->index = countvertex-1;
   ftr->elist.append(etr = new cedge_type, NULL);
   etr->index = 0;

   fclose(infile);
   return 1;
}

