

#include <stdlib.h>
#include <string.h>

#include "global.h"
#include "pstring.h"

#include "convert.h"


// AutoCAD color table
static float DXFcolors[][3] =    {
       // 0 == black
       {0.0f,  0.0f,  0.0f},
       // 1 == red
       {1.0f,  0.0f,  0.0f},
       // 2 == yellow
       {1.0f,  1.0f,  0.0f},
       // 3 == green
       {0.0f,  1.0f,  0.0f},
       // 4 == cyan
       {0.0f,  1.0f,  1.0f},
       // 5 == blue
       {0.0f,  0.0f,  1.0f},
       // 6 == magenta
       {1.0f,  0.0f,  1.0f},
       // 7 == white
       {1.0f,  1.0f,  1.0f},
       // 8 == dk grey
       {0.5f,  0.5f,  0.5f},
       // 9 == lt grey
       {0.75f, 0.75f, 0.75f}
};


/* ******************************************************
****************************************************** */
dxf_converter::dxf_converter() {

   int i;
   ilm_type *qtr;

   color = 7;

   for (i=0; i < 10; i++) {
      floats[i] = angles[i] = 0.0;
      ints[i] = 0;
      vertex[i][0] = vertex[i][1] = vertex[i][2] = 0;

      ilist.append(qtr = new ilm_type, NULL);

      copyarray3(qtr->ambient, DXFcolors[i]);

      copyarray3(qtr->diffuse, DXFcolors[i]);
      smultarray3(qtr->diffuse, 0.7f);

      copyarray3(qtr->specular, DXFcolors[i]);
      smultarray3(qtr->specular, 0.3f);
   }

}


/* ******************************************************
****************************************************** */
int dxf_converter::query_degenerate(int a, int b, int c) {

   return (similar3(vertex[a], vertex[b]) ||
           similar3(vertex[a], vertex[c]) ||
           similar3(vertex[b], vertex[c]));
}


/* ******************************************************
****************************************************** */
void dxf_converter::store_poly(int a, int b, int c) {

   facet_type *ftr;
   int i;
   cvertex_type *vtr;
   cedge_type *etr;

   flist.append(ftr = new facet_type, NULL);

   ftr->elist.append(etr = new cedge_type, NULL);
   etr->index = vlist.count;
   vlist.append(vtr = new cvertex_type, NULL);
   copyarray3(vtr->v, vertex[a]);
   
   ftr->elist.append(etr = new cedge_type, NULL);
   etr->index = vlist.count;
   vlist.append(vtr = new cvertex_type, NULL);
   copyarray3(vtr->v, vertex[b]);
   
   ftr->elist.append(etr = new cedge_type, NULL);
   etr->index = vlist.count;
   vlist.append(vtr = new cvertex_type, NULL);
   copyarray3(vtr->v, vertex[c]);
   
   if (color < 0 || color > 9)
      color = 7;

   for (i=0, ftr->ilm = (ilm_type *)ilist.head; ftr->ilm && i < color; i++)
      ftr->ilm = (ilm_type *)ftr->ilm->next;
}


/* ******************************************************
****************************************************** */
void dxf_converter::store_data() {

   if (strstr(obname.string, "TRACE") ||  // 2 back-to-back triangles
       strstr(obname.string, "SOLID") ||  // 1 or 2 triangles_
       strstr(obname.string, "3DFACE")) { // 1 or 2 triangles_

      if (!query_degenerate(0, 1, 2))
         store_poly(2, 1, 0);

      if (!query_degenerate(0, 2, 3))
         store_poly(3, 2, 0);
   }

}


/* ******************************************************
   read a group code and the next line from FpIn_
****************************************************** */
int dxf_converter::getline(FILE *infile, char *buffer, int *code) {

   if (!fgets(buffer, MAXSTRLEN, infile))    // get a line from .DXF
      return 1;

   sscanf(buffer, "%3d", code);              // scan out group code

   return !fgets(buffer, MAXSTRLEN, infile); // get a line from .DXF
}


/* ******************************************************
****************************************************** */
int dxf_converter::read_data(char *filename) {

   FILE *infile;
   int errorflag = 0;
   char	buffer[MAXSTRLEN];
   int code;
   cvertex_type *vtr;
   int i;
   
   if (!find_file(filename, "r", OBJECT_PATH.string, (char)PLATFORM_SLASH, NULL, &infile))
      return 0;
      
   while (!errorflag) {

      // run file up to the "ENTITIES" section
      while (!errorflag) {

	  // get a group code and a line
          if ((errorflag = getline(infile, buffer, &code)))
             break;

          // file section mark
          if (!code) {
             if ((errorflag = strstr(buffer, "EOF") != NULL))
                break;

             if (strstr(buffer, "SECTION")) {
                // get a group code and a line
                if ((errorflag = getline(infile, buffer, &code)))
                   break;

                if (code == 2 && (strstr(buffer, "ENTITIES") || strstr(buffer, "OBJECTS")))
                   break;

             }

          }

      }

      // scan ENTITIES section
      while (!errorflag) {
      
         // get a group code and a line
         if ((errorflag = getline(infile, buffer, &code)))
            break;

         if (code <100) {

            // cardinal group codes
            if (code < 10)

               switch(code) {
                  // start of entity, table, file sep
                  case 0:
                     if (obname.string[0])
                        store_data();

                     if ((errorflag = strstr(buffer, "EOF") != NULL))
                        break;

                     if (strstr(buffer, "ENDSEC"))
                        break;

                     // reset object
                     color = 7;
                     obname.stringcpy(buffer);
                     break;

                  default:
                     break;
               }

            // Some X coord
            else if (code < 20)
               sscanf(buffer, "%f", &vertex[code-10][0]);
            // Some Y coord
            else if (code < 30)
               sscanf(buffer, "%f", &vertex[code-20][1]); 
            // Some Z coord
            else if (code < 38)
               sscanf(buffer, "%f", &vertex[code-30][2]);
            //misc floats
            else if (code < 49)
               sscanf(buffer, "%f", &floats[code-40]);
            // misc angles
            else if (code < 60)
               sscanf(buffer, "%f", &angles[code-50]);
            // Color number
            else if (code == 62)
               sscanf(buffer, "%6d", &color);
	    // misc ints
            else if (code < 80) {

               sscanf(buffer, "%d", &ints[code-70]);

               // the following is guesswork... AWH
               switch (ints[code-70]) {

                  // read triangle indices into vertex list
                  case 128:
                     if ((errorflag = getline(infile, buffer, &code)))
                        break;

                     sscanf(buffer, "%d", &ints[code-70]);

                     for (i=1, vtr = (cvertex_type *)vstack.head; i < abs(ints[code-70]) && vtr->next; i++, vtr = (cvertex_type *)vtr->next);
                     copyarray3(vertex[0], vtr->v);

                     if ((errorflag = getline(infile, buffer, &code)))
                        break;

                     sscanf(buffer, "%d", &ints[code-70]);

                     for (i=1, vtr = (cvertex_type *)vstack.head; i < abs(ints[code-70]) && vtr->next; i++, vtr = (cvertex_type *)vtr->next);
                     copyarray3(vertex[1], vtr->v);

                     if ((errorflag = getline(infile, buffer, &code)))
                        break;

                     sscanf(buffer, "%d", &ints[code-70]);

                     for (i=1, vtr = (cvertex_type *)vstack.head; i < abs(ints[code-70]) && vtr->next; i++, vtr = (cvertex_type *)vtr->next);
                     copyarray3(vertex[2], vtr->v);

                     if (!query_degenerate(0, 1, 2))
                        store_poly(2, 1, 0);
                     break;

                  // declare next vertex on vertex stack
                  case 192:
                     vstack.append(vtr = new cvertex_type, NULL);
                     copyarray3(vtr->v, vertex[0]);
                     break;

                  default:
                     break;
               }

            }

         }

      }

   }

   fclose(infile);
   return 1;
}
