

#include <stdlib.h>
#include <string.h>

#include "convert.h"

#include "spb_load.h"
#include "gamegine.h"

#include "3ds_load.h"
#include "raw_load.h"
#include "obj_load.h"
#include "lw_load.h"
#include "byu_load.h"
#include "flt_load.h"
#include "hpx_load.h"


void init_coder();


/* ******************************************************
****************************************************** */
void bad_object_message(char *filename) {

   printf("Error: Invalid data file \"%s\"... Aborting...\n", filename);
   exit(0);
}


/* ******************************************************
****************************************************** */
int main(int argc, char **argv) {

   spg2_loader spg2;
   string_type buffer;
   int i, j, k, l, m;
   vector2f uv;
   string_type spgname, ilmname, uvname, uvwname, sphrname;
   slide_converter sc;
   dxf_converter dxfc;
   
   file_loader *loader;
   
   polytype *dob = NULL;
   shadelist *lob = NULL;
   texpolygon *uvob = NULL;
   shaderlisttype *uvwob = NULL;
   spheretype *sob = NULL;
   polygon_object_type *pot;
   texface *uvblock;
   
   if (argc < 2) {
      printf("usage: convert <filename> <-r>\n");
      printf("\t\tFormats supported:\n");
      printf("\t\t\t(.lw/.lwo), (.obj), (.dxf), (.tpoly), (.byu), (.flt), (.3ds), (.spb), (.slide)\n");
//      printf("\t\t\t(.sor), or (.mirror)\n");

      exit(0);
   }

   init_lut();
   init_coder();

   global_resource_manager->register_resource_object(RESOURCE_POLYGON_LOADER, new spb_loader);
   global_resource_manager->register_resource_object(RESOURCE_POLYGON_LOADER, new sd3_loader);
   global_resource_manager->register_resource_object(RESOURCE_POLYGON_LOADER, new flt_loader);
   global_resource_manager->register_resource_object(RESOURCE_POLYGON_LOADER, new hpx_loader);
   global_resource_manager->register_resource_object(RESOURCE_POLYGON_LOADER, new lightwave_loader);
   global_resource_manager->register_resource_object(RESOURCE_POLYGON_LOADER, new byu_loader);
   global_resource_manager->register_resource_object(RESOURCE_POLYGON_LOADER, new raw_loader);
   global_resource_manager->register_resource_object(RESOURCE_POLYGON_LOADER, new obj_loader);

   loader = (file_loader *)global_resource_manager->find_resource_object(RESOURCE_POLYGON_LOADER, argv[1], NULL);

   if (loader) {

      if (!loader->read_data()) {
         printf("Error: Could not load \"%s\"... Aborting...\n", argv[1]);
         exit(0);
      }

      // extract object
      dob = (polytype *)loader->extract(FILETYPE_SPG, argv[1]);

      if (!dob || !dob->countobject)
         bad_object_message(argv[1]);

      lob = (shadelist *)loader->extract(FILETYPE_ILM, argv[1]);

      uvob = (texpolygon *)loader->extract(FILETYPE_TEX, argv[1]);

      uvwob = (shaderlisttype *)loader->extract(FILETYPE_TEX3D, argv[1]);
  
      sob = (spheretype *)loader->extract(FILETYPE_SPHERE, argv[1]);
   }
   
   else {
      for (i = strlen(argv[1])-1; i > -1 && argv[1][i] != '.'; i--);
      
      if (i == -1)
         bad_object_message(argv[1]);

      // sliders
      if (!strcmp(&argv[1][i], ".slide")) {
         if (!sc.read_data(argv[1]))
            bad_object_message(argv[1]);
	 
         dob = (polytype *)sc.extract_spg();

         if (!dob || !dob->countobject)
            bad_object_message(argv[1]);
      }

      // autocad .dxf
      else if (!strcmp(&argv[1][i], ".dxf")) {

         if (!dxfc.read_data(argv[1]))
            bad_object_message(argv[1]);
	 
         dob = (polytype *)dxfc.extract_spg();
         if (!dob || !dob->countobject)
            bad_object_message(argv[1]);

         lob = (shadelist *)dxfc.extract_ilm();
      }

/*
      else if (!strcmp(argv[1], ".mirror")) {
 asdf
         printf("Mirror converter currently not implemented...\n");
         return 0;
      }

      else if (!strcmp(argv[1], ".sor")) {
 asdf
         printf("Surface Of Revolution converter currently not implemented...\n");
         return 0;
      }
*/

      else
         bad_object_message(argv[1]);
   }

   if (argc == 3 && !strcmp(argv[2], "-r")) {

      pot = (polygon_object_type *)dob->query_data();

      for (i=0; i<dob->countobject; i++) {
         l = pot->flist[i].polynum >> 1;
         m = pot->flist[i].polynum - 1;

         for (j=0; j<l; j++, m--) {
            k = pot->flist[i].edgeptr[j];
            pot->flist[i].edgeptr[j] = pot->flist[i].edgeptr[m];
            pot->flist[i].edgeptr[m] = k;
         }

      }

      if (uvob) {
      
         uvblock = (texface *)uvob->query_data();
      
         for (i=0; i<dob->countobject; i++) {
            l = uvblock[i].count >> 1;
            m = uvblock[i].count - 1;

            for (j=0; j<l; j++, m--) {
               uv[0] = uvblock[i].uv[j][0];
               uv[1] = uvblock[i].uv[j][1];
               uvblock[i].uv[j][0] = uvblock[i].uv[m][0];
               uvblock[i].uv[j][1] = uvblock[i].uv[m][1];
               uvblock[i].uv[m][0] = uv[0];
               uvblock[i].uv[m][1] = uv[1];
            }

         }

      }

   }

   buffer.stringcpy(argv[1]);

   for (i=buffer.stringlen() - 1; i > -1; i--)
      if (buffer.string[i] == '.') {
         buffer.string[i] = 0;
         buffer.recalc();
         break;
      }

   spgname.stringcpy(&buffer);
   spgname.stringcat(".spg");
   
   ilmname.stringcpy(&buffer);
   ilmname.stringcat(".ilm");
   
   uvname.stringcpy(&buffer);
   uvname.stringcat(".tex");
   
   uvwname.stringcpy(&buffer);
   uvwname.stringcat(".3dt");
   
   sphrname.stringcpy(&buffer);
   sphrname.stringcat(".sph");
   
   spg2.write_data(spgname.string, dob, ilmname.string, lob, uvname.string, uvob, uvwname.string, uvwob, sphrname.string, sob);
   return 1;
}

