

#if !defined __CONVERT_H
#define __CONVERT_H


#include "shading.h"
#include "texture.h"


/* ******************************************************
****************************************************** */
class cvertex_type : public dbl_llist {

   public:
      vector3f v;
      
      virtual ~cvertex_type() {}
};


/* ******************************************************
****************************************************** */
class cedge_type : public dbl_llist {

   public:
      int index;
      vector2f uv;

      virtual ~cedge_type() {
         index = 0;
         uv[0] = uv[1] = 0;
      }

};


/* ******************************************************
****************************************************** */
class ilm_type : public dbl_llist {

   public:
      int index;
      int flag_dbl_side;
      vector3f diffuse, ambient, specular, luminate;
      float specn;

      ilm_type() {
         flag_dbl_side = 0;
         diffuse[0] = diffuse[1] = diffuse[2] = 0.7f;
         ambient[0] = ambient[1] = ambient[2] = 1;
         specular[0] = specular[1] = specular[2] = 0.3f;
         specn = 1;
         luminate[0] = luminate[1] = luminate[2] = 0.0;
      }

      virtual ~ilm_type() {}
};


/* ******************************************************
****************************************************** */
class facet_type : public dbl_llist {

   public:
      dbl_llist_manager elist;
      
      ilm_type *ilm;
      string_type texname;
      int flag_dbl_side;

      facet_type() { ilm = NULL; flag_dbl_side = 0; }
      virtual ~facet_type() {}
};


/* ******************************************************
****************************************************** */
class converter {

   protected:
      void copy_ilm(shadetype *dst, ilm_type *src);

   public:
      dbl_llist_manager vlist;
      dbl_llist_manager flist;
      dbl_llist_manager ilist;
      
      virtual ~converter() {}
 
      resource_type *extract_spg();
      resource_type *extract_ilm();
//      resource_type *extract_tex();
      
      virtual int read_data(char *filename) { return 0; }
};


/* ******************************************************
****************************************************** */
class slide_converter : public converter {

   public:
      int read_data(char *filename);
};


/* ******************************************************
****************************************************** */
class dxf_converter : public converter {

   protected:
      vector3f vertex[10];
      float floats[10], angles[10];
      int ints[10];
      int color;
      string_type obname;
      dbl_llist_manager vstack;
      
      int  query_degenerate(int a, int b, int c);
      int  getline(FILE *infile, char *buffer, int *code);
      void store_poly(int a, int b, int c);
      void store_data();

   public:

      dxf_converter();
      virtual ~dxf_converter() {}

      int read_data(char *filename);
};


/* ******************************************************
****************************************************** */
class dive_converter : public converter {

   public:
      int read_data(char *filename);
};

#endif
