

#include <string.h>

#include "polygon.h"
#include "global.h"

#include "convert.h"


/* ******************************************************
****************************************************** */
resource_type *converter::extract_spg() {

   polytype *ob;
   polygon_object_type *pot;
   int *iptr;
   int i, j;
   facet_type *ftr;
   cvertex_type *vtr;
   cedge_type *etr;
   
   if (!vlist.count || !flist.count)
      return NULL;

   for (i=0, ftr=(facet_type *)flist.head; ftr; ftr=(facet_type *)ftr->next) {
      i += ftr->elist.count;
      if (ftr->flag_dbl_side)
         i += ftr->elist.count;
   }
    
   if (!i)
      return NULL;
   
   ob = new polytype;
   ob->build(vlist.count, flist.count, i);
   pot = (polygon_object_type *)ob->query_data();

   for (i=0, vtr = (cvertex_type *)vlist.head; vtr; i++, vtr = (cvertex_type *)vtr->next) {
      copyarray3(pot->vlist[i], vtr->v);
      pot->vlist[i][3] = 1.0f;
   }

   for (i=0, iptr=pot->vindex, ftr=(facet_type *)flist.head; ftr; i++, ftr=(facet_type *)ftr->next) {
      pot->flist[i].polynum = ftr->elist.count;
      pot->flist[i].edgeptr = iptr;
      iptr += pot->flist[i].polynum;

      for (j=0, etr=(cedge_type *)ftr->elist.head; etr; j++, etr=(cedge_type *)etr->next)
         pot->flist[i].edgeptr[j] = etr->index;

      if (ftr->flag_dbl_side) {
         i++;
         pot->flist[i].polynum = ftr->elist.count;
         pot->flist[i].edgeptr = iptr;
         iptr += pot->flist[i].polynum;

         for (j=0, etr=(cedge_type *)ftr->elist.tail; etr; j++, etr=(cedge_type *)etr->back)
            pot->flist[i].edgeptr[j] = etr->index;
      }

   }

   return ob;
}


/* ******************************************************
****************************************************** */
void converter::copy_ilm(shadetype *dst, ilm_type *src) {

   copyarray3(dst->fka, src->ambient);
   copyarray3(dst->fkp, src->diffuse);
   copyarray3(dst->fks, src->specular);
   copyarray3(dst->flum, src->luminate);
   dst->specn = src->specn; 
}


/* ******************************************************
****************************************************** */
resource_type *converter::extract_ilm() {

   int *index;
   int countobject;
   int i;
   facet_type *ftr;
   ilm_type *base, *itr;
   shadelist *ob;
   shade_block *sblock;

   if (!ilist.count || !flist.count)
      return NULL;

   // find most common used material
   index = new int[ilist.count];

   memset(index, 0, ilist.count*sizeof(int));
	
   for (i=countobject = 0, ftr=(facet_type *)flist.head; ftr; ftr=(facet_type *)ftr->next)
      if (ftr->ilm)
         if (ftr->flag_dbl_side) {
            index[ftr->ilm->index]+=2;
            countobject+=2;
         }

         else {
            index[ftr->ilm->index]++;
            countobject++;
         }

   for (base = (ilm_type *)ilist.head, itr = (ilm_type *)ilist.head->next; itr; itr = (ilm_type *)itr->next)
      if (index[itr->index] > index[base->index])
         base = itr;

   delete [] index;

   ob = new shadelist;

   ob->replace_data(sblock = new shade_block);
   sblock->shade_palette = new shadetype[sblock->shade_count = ilist.count];

   copy_ilm(&sblock->shade_palette[0], base);
   memcpy(&ob->base, &sblock->shade_palette[0], sizeof(shadetype));

   for (itr = (ilm_type *)ilist.head, i=1; itr; itr = (ilm_type *)itr->next)
      if (itr != base) {
         copy_ilm(&sblock->shade_palette[i], itr);
         i++;
      }


   sblock->index_palette = new int[sblock->index_count = countobject];

   for (i=0, ftr=(facet_type *)flist.head; ftr; i++, ftr=(facet_type *)ftr->next) {
      if (!ftr->ilm || ftr->ilm == base)
         sblock->index_palette[i] = 0;
      else if (ftr->ilm->index < base->index)
         sblock->index_palette[i] = ftr->ilm->index+1;
      else
         sblock->index_palette[i] = ftr->ilm->index;

      if (ftr->flag_dbl_side) {
         i++;
         sblock->index_palette[i] = sblock->index_palette[i-1];
      }

   }

   return ob;
}


/* ******************************************************
****************************************************** */
/*
resource_type *converter::extract_tex() {

   texpolygon *ob;
   int i, j;
   facet_type *ftr;
   vector2f *uv;
   int count;
   cedge_type *etr; 
   texbase *tob;
   
   if (!flist.count)
      return NULL;

   for (i=0, ftr=(facet_type *)flist.head; ftr; ftr=(facet_type *)ftr->next) {
      if (ftr->texname.string[0] && ftr->elist.count > count)
         count = ftr->elist.count;

      if (ftr->flag_dbl_side)
         i += 2;
      else
         i++;
   }

   if (!i || !count)
      return NULL;

   // build texture object
   ob = new texpolygon;
   ob->setup(i);
   uv = new vector2f[count];
   
   for (i=0, ftr=(facet_type *)flist.head; ftr; i++, ftr=(facet_type *)ftr->next) {

      if (!ftr->texname.string[0]) {
         if (ftr->flag_dbl_side)
            i++;

         continue;
      }

      tob = (texture *)((frame_manager *)global_resource_manager)->read_tex(ftr->texname.string);

      if (!tob) {
         printf("Warning: Unable to locate \"%s\".  Ignored...\n", ftr->texname.string);
         if (ftr->flag_dbl_side)
            i++;

         continue;
      }

      for (j=0, etr = (cedge_type *)ftr->elist.head; etr; j++, etr = (cedge_type *)etr->next)
         copyarray2(uv[j], etr->uv);

      ob->direct2Dmap(i, uv, tob, ftr->elist.count, 0);

      if (ftr->flag_dbl_side) {
         i++;

         for (j=0, etr = (cedge_type *)ftr->elist.tail; etr; j++, etr = (cedge_type *)etr->back)
            copyarray2(uv[j], etr->uv);

         ob->direct2Dmap(i, uv, tob, ftr->elist.count, 0);
      }

   }

   delete [] uv;
   return ob;
}
*/
