

#include <string.h>
#include "anitroll.h"


#define RENDERFLAG_SOLID   3
#define RENDERFLAG_TRANS   4
#define RENDERFLAG_SPOT    5
#define RENDERFLAG_SHADOW  6


/* *************************************************************
************************************************************* */
void aengine::render_list(pc *ptr, light *lctr, pc **shadptr, int frame_id, int transflag) {

   pc *qtr;

   switch (transflag) {
   
      case RENDERFLAG_SPOT:

         while (ptr) {
            ptr->begin_scan();
            ptr->datacopy();

            if (ptr->beamscan((spotlight *)lctr, this))
               ptr->beamrender((spotlight *)lctr, this);

            ptr->end_scan();
            ptr = (pc *)ptr->next;
         }

         return;   

      // render "solids"
      case RENDERFLAG_SOLID:

         while (ptr) {
            ptr->frame = frame_id;
            ptr->begin_scan();
            ptr->datacopy();

            ptr->scan(frame.camdtr, frame.lightdtr, this);

            if (ptr->shadptr) {
               for (qtr=ptr->shadptr; qtr->next; qtr=(pc *)qtr->next);
               qtr->next = *shadptr;
               *shadptr = ptr->shadptr;
            }

            if (ptr->renderflag)
               ptr->render(frame.camdtr, frame.lightdtr, frame.beamdtr, this);

            ptr->end_scan();
         }

         return;   

      // render "transparents"
      case RENDERFLAG_TRANS:
      
         while (ptr) {
            ptr->frame = frame_id;
            ptr->begin_scan();
            ptr->datacopy();

            if (ptr->scan(frame.camdtr, frame.lightdtr, this))
               ptr->render(frame.camdtr, frame.lightdtr, frame.beamdtr, this);

            ptr->end_scan();
         }
	 
         return;

      // scan/render shadow list
      case RENDERFLAG_SHADOW:
      	 
         while (ptr) {
            ptr->frame = frame_id;
            if (ptr->scan(frame.camdtr, frame.lightdtr, this))
               ptr->render(frame.camdtr, (light *)NULL, (light *)NULL, this);

            ptr->end_scan();

            qtr = ptr;
            ptr = (pc *)ptr->next;
            delete qtr;
         }

         return;

      default:
         return;
   }

}


/* *************************************************************
    render for anitroll
************************************************************* */
void aengine::spawn(int frame_id, mapul *mapbuffer) {

   light *lctr;
   pc    *ptr;
   pc    *shadptr = (pc *)NULL;
   int   i;

   zbuff.initbuff(mapbuffer->data, mapbuffer->pdata, adata.data, zdata.data, mapbuffer->maxx, mapbuffer->maxy, back);

   if (!frame.camdtr || !(frame.lightdtr || frame.beamdtr)) {
      zbuff.pdata = NULL;
      zbuff.data = NULL;
      zbuff.adata = NULL;
      zbuff.zdata = NULL;
      return;
   }

   // render shadowmaps
   for (lctr=frame.beamdtr; lctr!=(light *)NULL; lctr=(light *)lctr->next) {

      ((spotlight *)lctr)->lbuff = (lightbufftype *)control->pop(MM_LIGHTBUFF);
      ((spotlight *)lctr)->init_buff(control);

      for (i=0; i<MAXGROUND; i++) {
         cullnsort(lctr, frame.solidtr[i], &ptr, &frame.solidtr[i]);
         render_list(ptr, lctr, NULL, frame_id, RENDERFLAG_SPOT);

         cullnsort(lctr, frame.invisotr[i], &ptr, &frame.invisotr[i]);
         render_list(ptr, lctr, NULL, frame_id, RENDERFLAG_SPOT);
      }

      lctr->xform(frame.camdtr);
   }

   for (lctr=frame.lightdtr; lctr!=(light *)NULL; lctr=(light *)lctr->next)
      lctr->xform(frame.camdtr);

   for (i=0; i<MAXGROUND; i++) {

      // render "solids"
      cullnsort(frame.camdtr, frame.solidtr[i], &ptr, &frame.solidtr[i]);
      render_list(ptr, NULL, &shadptr, frame_id, RENDERFLAG_SOLID);

      // render "solids"
      cullnsort(frame.camdtr, frame.invisotr[i], &ptr, &frame.invisotr[i]);
      render_list(ptr, NULL, &shadptr, frame_id, RENDERFLAG_SOLID);

      // render transparent objects
      cull(frame.camdtr, frame.transtr[i], &ptr, &frame.transtr[i]);
      render_list(ptr, NULL, NULL, frame_id, RENDERFLAG_TRANS);

      // render "shadows" - no cull cause dont have bound spheres
      render_list(ptr, NULL, NULL, frame_id, RENDERFLAG_SHADOW);
      shadptr = NULL;
   }

   for (lctr=frame.beamdtr; lctr; lctr=(light *)frame.beamdtr->next) {
      control->push(MM_LIGHTBUFF, ((spotlight *)lctr)->lbuff);
      ((spotlight *)lctr)->lbuff = (lightbufftype *)NULL;
   }

   zbuff.pdata = NULL;
   zbuff.data = NULL;
   zbuff.adata = NULL;
   zbuff.zdata = NULL;
}
