

/* **************************************************************
************************************************************** */

#include "csphrlib.h"

#include "polygon.h"
#include "pstring.h"

#include "gamegine.h"

#include "flt_load.h"

atom_list_type *sphere_tree = NULL;
int sphere_current_level = 0;
spheretype *sob = NULL;


/* **************************************************
************************************************** */
void rebuild_sphere_tree(unsigned int flags) {

   int i, j;
   sphere_block *sblock;
   antineutron *dtr;
   polygon *ob;
   geneological_type ani_param;
   char filename[] = "config/usphere.spb";
   gameatom *ptr;
   char buffer[MAXSTRLEN];
  
   if (sphere_tree) {
      complex->animation_manager.remove(sphere_tree);
      delete sphere_tree;
      sphere_tree = NULL;
   }

   if (!sphere_current_level  || !sob)
      return;

   ptr = new gameatom;
   ptr->name.stringcpy("spherelist");

   sblock = (sphere_block *)sob->query_data();

   for (i=0, j = sphere_current_level-1; i<sblock->countsphere; i++)
      if (sblock->slist[i].level == j) {
         dtr = new antineutron;

         ptr->create_link(dtr);
         sprintf(buffer, "sphere%d", i);
         dtr->name.stringcpy(buffer);   
         dtr->iscale = sblock->slist[i].radius;
         dtr->initxform[0][3] = sblock->slist[i].center[0];
         dtr->initxform[1][3] = sblock->slist[i].center[1];
         dtr->initxform[2][3] = sblock->slist[i].center[2];
	 
         ob = (polygon *)dtr->get_render_object();
         ob->filename.stringcpy(filename);   
         ob->colorname.stringcpy(filename);
         ob->mctype.set_master(GOURAUD);
         if (flags & FLAG_TRANSPARENT)
            ob->mcinfo.mask_or(CITRANSPARENT);
      }

   complex->animation_manager.append(sphere_tree = new atom_list_type, NULL);
   sphere_tree->htree = ptr;

   ani_param.tree = sphere_tree;
   ani_param.parent = NULL;
   ptr->preprocess(&ani_param);
}


/* **************************************************
************************************************** */
void sphere_tree_opacity(unsigned int flags) {

   linktype *ptr;
   polygon *ob;

   if (!sphere_tree)
      return;

   for (ptr = (linktype *)sphere_tree->htree->edge.head; ptr; ptr = (linktype *)ptr->next) {
      ob = (polygon *)((antineutron *)ptr->link)->get_render_object();

      if (flags & FLAG_TRANSPARENT)
         ob->mcinfo.mask_or(CITRANSPARENT);
      else
         ob->mcinfo.mask_and(~CITRANSPARENT);
   }
   
}


/* *************************************************************
************************************************************* */
gameatom *load_obj(char *filename, dbl_llist_manager *hiearchy_manager) {

   gameatom *ptr;
   antineutron *dtr;

   ptr = load_game_object(filename, hiearchy_manager);

   dtr = (antineutron *)((linktype *)ptr->edge.head)->link;
   sob = dtr->colsphere;

   return ptr;
}


/* **************************************************
************************************************** */
void init_game() {

   global_resource_manager->register_resource_object(RESOURCE_POLYGON_LOADER, new flt_loader);

   object_tree = load_obj(SDEFLST.string, &complex->animation_manager);
   
   sphere_tree = NULL;
   sphere_current_level = 0;

   RFACTOR = 10.0f;
   TFACTOR = 10.0f;
}


/* **************************************************
************************************************** */
void shutdown_game() {

}


/* **************************************************
************************************************** */
void process_io(vector4f *mx, vector4f *tmx, camera *cparam, unsigned int *flags) {

   sphere_block *sblock;
   int tempi = 0;

   if (sob) {
      sblock = (sphere_block *)sob->query_data();
      
      if (complex->userinput->key_stroke(KEYSTROKE_0)) {
         sphere_current_level = 0;
         tempi = 1;
      }

      else if (complex->userinput->key_stroke(KEYSTROKE_1)) {
         sphere_current_level = 1;
         tempi = 1;
      }

      else if (complex->userinput->key_stroke(KEYSTROKE_2)) {
         sphere_current_level = 2;
         tempi = 1;
      }

      else if (complex->userinput->key_stroke(KEYSTROKE_3)) {
         sphere_current_level = 3;
         tempi = 1;
      }

      else if (complex->userinput->key_stroke(KEYSTROKE_4)) {
         sphere_current_level = 4;
         tempi = 1;
      }

      else if (complex->userinput->key_stroke(KEYSTROKE_5)) {
         sphere_current_level = 5;
         tempi = 1;
      }

      else if (complex->userinput->key_stroke(KEYSTROKE_6)) {
         sphere_current_level = 6;
         tempi = 1;
      }

      else if (complex->userinput->key_stroke(KEYSTROKE_7)) {
         sphere_current_level = 7;
         tempi = 1;
      }

      else if (complex->userinput->key_stroke(KEYSTROKE_8)) {
         sphere_current_level = 8;
         tempi = 1;
      }

      else if (complex->userinput->key_stroke(KEYSTROKE_9)) {
         sphere_current_level = 9;
         tempi = 1;
      }

      if (tempi) {
         if (sphere_current_level > sblock->slist[0].level+1)
            sphere_current_level = sblock->slist[0].level+1;
         rebuild_sphere_tree(*flags);
      }

      if (complex->userinput->key_stroke(KEYSTROKE_T)) {
         if (*flags & FLAG_TRANSPARENT)
	    *flags &= ~FLAG_TRANSPARENT;
	 else
	    *flags |= FLAG_TRANSPARENT;
	 
         sphere_tree_opacity(*flags);
      }

   }
   
}


/* **************************************************
************************************************** */
void other3d(vector4f *mx, vector4f *frustum, int framecount, VIRTUALwindow *win) {

}


/* **************************************************
************************************************** */
void other2d(VIRTUALwindow *win, int flags) {

   float rowsize = (float)(win->mapbuffer.maxy/64.0);
   int x = (int)(win->mapbuffer.maxx*0.75);
   float y;
   char spherestr[32];
   sphere_block *sblock;
   int i;
   int current_count, face_count;

   if (sob && complex->font) {
      sblock = (sphere_block *)sob->query_data();
    
      complex->font->set_color((char)0, (char)200, (char)0);
      complex->font->set_scale((float)(rowsize*0.85));
   
      for (i=face_count=0; i<sblock->countsphere; i++)
         if (!sblock->slist[i].level)
            face_count += sblock->slist[i].count;

      if (!sphere_current_level)
         current_count = face_count;
      else 
         for (i=current_count=0; i<sblock->countsphere; i++)
            if (sblock->slist[i].level+1 == sphere_current_level)
               current_count++;

      y = 0.025f*win->mapbuffer.maxy;

      sprintf(spherestr, "Totals S:%d F:%d", sblock->countsphere, face_count);
      complex->font->print(x, (int)y, (unsigned char *)spherestr, &win->mapbuffer);
      y += rowsize;
   
      sprintf(spherestr, "Current %d", current_count);
      complex->font->print(x, (int)y, (unsigned char *)spherestr, &win->mapbuffer);
      y += rowsize;
   
      sprintf(spherestr, "Level %d:%d", sphere_current_level, sblock->slist[0].level+1);
      complex->font->print(x, (int)y, (unsigned char *)spherestr, &win->mapbuffer);
      y += rowsize;
   }

}


/* **************************************************
************************************************** */
int main(int argc, char **argv) {

   return main_body(argc, argv);
}

