#!/bin/tcsh

# generate "stars" background
cd ../../gallery
../../bin/render -l lists/stars.list -rgb a -noscreen
mv a0000.rgb ../theater/earth/textures/stars.rgb
cd ../theater/earth

# convert Wavefront globe
cd models 
../../../../bin/convert globe.obj globe
\mv globe.ilm ../materials
cd ..

# generate spinning animation
../../../bin/anitroll -in animation/spin.cnt -out animation/spin.list
../../../bin/render -l animation/spin.list -rgb spin

# generate unravelled earth
../../../bin/morph models/shell2.sp models/square3.sp 60 models/morph
../../../bin/render -l animation/morph.list -rgb morph

# view
../../../bin/mflip 0.03333 spin*.rgb morph*.rgb

# cleanup
\rm textures/stars.rgb
\rm models/globe.spg
\rm models/morph*.sp
\rm materials/globe.ilm
\rm animation/spin.list
\rm *.rgb

