#ifndef OGRE_SCRIPT
    #define OGRE_SCRIPT 1

#include <stdio.h>

#include "ogreobj.hpp"

struct color_decl {
    char *varname;
    unsigned char red;
    unsigned char green;
    unsigned char blue;
};


struct number_decl {
    char *varname;
    float value;
};


struct object_decl {
    char *varname;
    OgreObject *obj;
};


class OgreScript {
protected:
    int max_color_decl;
    int max_number_decl;
    int max_object_decl;

    int user_lines;
    char **user_script;

    int current_line;

    // Tells if everything went OK
    int err_flag;

    color_decl  SCRIPT_colors[256];
    number_decl SCRIPT_numbers[256];
    object_decl SCRIPT_objects[256];

    // For loading a script
    int line_count(char *fname);
    int load_script(char *fname);
    void unload_script(void);

    // For accessing user-variables
    int find_color(char *varname);
    int find_number(char *varname);
    int find_object(char *varname);
    float get_value(char *varname, int *ok);

    // For script execution
    int do_line(int line_num);
    int get_opcode(char *opname);
    int get_objcmd(char *opname);
    int creation_op(int opcode);

    // For variable declarations
#ifdef MFX
    int _color_decl(char *varname);
    int _number_decl(char *varname);
    int _object_decl(char *varname);
#else
    int color_decl(char *varname);
    int number_decl(char *varname);
    int object_decl(char *varname);
#endif

    // For error messages
    void err_header(void);
    void missing_file_err(char *fname);
    void undecl_color_err(char *varname);
    void undecl_number_err(char *varname);
    void undecl_object_err(char *varname);

public:
    OgreScript(void);
    ~OgreScript(void);

    int Execute(char *fname);
    int get_errflag(void);
};

#endif

