#ifndef OGRE_OBJECT
    #define OGRE_OBJECT 1

#include <stdio.h>
#ifdef MFX
#include <float.h>
#endif

typedef struct {
    float x;
    float y;
    float z;
} Vertex;


typedef struct {
    float x;
    float y;
    float z;
} Vector;


typedef struct {
    unsigned char red;
    unsigned char green;
    unsigned char blue;
} Color_struct;


typedef struct {
    int num_points;
    Color_struct color;
    Vector norm_vect;

    int *points;
} Poly;


class OgreObject {
protected:
    int num_verts;
    int num_polys;

    float bsphere;

    Vertex *verts;
    Poly   *polys;

    char *get_next_line(char *str, int len, FILE *fp);
    void calc_normals(void);
    void calc_bsphere(void);
public:

    OgreObject(void);
    OgreObject(char *fname);
    OgreObject(OgreObject *oldobj);
    OgreObject(OgreObject *obj1, OgreObject *obj2);
    ~OgreObject(void);

    int  save(char *fname);       // Defaults to OGR
    int  saveOGR(char *fname);
    int  savePLG(char *fname);
    int  saveNFF10(char *fname);
    int  saveNFF17(char *fname);
    int  saveFLOB(char *fname);
    int  saveOBT(char *fname);

    int get_num_verts(void);
    int get_num_polys(void);

    void invert(void);
    void doubleside(void);
    void scale(float x, float y, float z);
    void trans(float x, float y, float z);
    void rotx(float angle);
    void roty(float angle);
    void rotz(float angle);

    void re_center(void);
    void re_floor(void);
    void optimize_verts(float threshold = 0.0);

    void paint(unsigned char r, unsigned char g, unsigned char b);
    void paintpoly(int pnum, unsigned char r, unsigned char g, unsigned char b);

    int  backface(int face);
};

#endif

