#include <math.h>

#include "ogreobj.hpp"
#include "o-wedge.hpp"


OgreWedge::OgreWedge(float arc_angle, float radius, float height,
                     int rim_sides) : OgreObject()
{
    int i, rim_verts;
    float temp_angle, delta_angle;
    float half_rim, half_rad;

    num_verts = (2 * rim_sides) + 4;
    num_polys = rim_sides + 4;

    verts = new Vertex[num_verts];
    polys = new Poly[num_polys];

    half_rim  = height / 2;
    half_rad  = radius     / 2;
    rim_verts = rim_sides+1;

    delta_angle =  ((M_PI / 180.0) * arc_angle) / ((float) rim_sides);

    temp_angle  = -((M_PI / 360.0) * arc_angle);

    for (i=0; i < rim_verts; i++) {
        verts[i].x = radius * sin(temp_angle);
        verts[i].y = half_rim;
        verts[i].z = (radius * cos(temp_angle)) - half_rad;

        temp_angle = temp_angle + delta_angle;
    }

    temp_angle  = -((M_PI / 360.0) * arc_angle);

    for (i=rim_verts; i < (2 * rim_verts); i++) {
        verts[i].x = radius * sin(temp_angle);
        verts[i].y = -half_rim;
        verts[i].z = (radius * cos(temp_angle)) - half_rad;

        temp_angle = temp_angle + delta_angle;
    }

    verts[(2 * rim_verts)    ].x = 0.0;
    verts[(2 * rim_verts)    ].y = half_rim;
    verts[(2 * rim_verts)    ].z = -half_rad;

    verts[(2 * rim_verts) + 1].x = 0.0;
    verts[(2 * rim_verts) + 1].y = -half_rim;
    verts[(2 * rim_verts) + 1].z = -half_rad;

    for (i=0; i < rim_sides; i++) {
        polys[i].num_points  = 4;
        polys[i].color.red   = 128;
        polys[i].color.green = 128;
        polys[i].color.blue  = 128;
        polys[i].points      = new int[4];
        polys[i].points[0]   = i;
        polys[i].points[1]   = i + 1;
        polys[i].points[2]   = i + rim_verts + 1;
        polys[i].points[3]   = i + rim_verts;
    }

    polys[rim_sides  ].num_points  = 4;
    polys[rim_sides  ].color.red   = 128;
    polys[rim_sides  ].color.green = 128;
    polys[rim_sides  ].color.blue  = 128;
    polys[rim_sides  ].points      = new int[4];
    polys[rim_sides  ].points[0]    = 0;
    polys[rim_sides  ].points[1]    = rim_verts;
    polys[rim_sides  ].points[2]    = num_verts-1;
    polys[rim_sides  ].points[3]    = num_verts-2;


    polys[rim_sides+1].num_points  = 4;
    polys[rim_sides+1].color.red   = 128;
    polys[rim_sides+1].color.green = 128;
    polys[rim_sides+1].color.blue  = 128;
    polys[rim_sides+1].points      = new int[4];
    polys[rim_sides+1].points[0]    = rim_verts-1;
    polys[rim_sides+1].points[1]    = num_verts-2;
    polys[rim_sides+1].points[2]    = num_verts-1;
    polys[rim_sides+1].points[3]    = num_verts-3;


    polys[rim_sides+2].num_points  = rim_verts + 1;
    polys[rim_sides+2].color.red   = 128;
    polys[rim_sides+2].color.green = 128;
    polys[rim_sides+2].color.blue  = 128;
    polys[rim_sides+2].points      = new int[rim_verts+1];

    for (i=0; i < rim_verts; i++) {
        polys[rim_sides+2].points[i] = rim_verts - i - 1;
    }
    polys[rim_sides+2].points[rim_verts] = num_verts-2;

    polys[rim_sides+3].num_points  = rim_verts + 1;
    polys[rim_sides+3].color.red   = 128;
    polys[rim_sides+3].color.green = 128;
    polys[rim_sides+3].color.blue  = 128;
    polys[rim_sides+3].points      = new int[rim_verts+1];

    for (i=0; i < rim_verts; i++) {
        polys[rim_sides+3].points[i] = i + rim_verts;
    }
    polys[rim_sides+3].points[rim_verts] = num_verts-1;

    // Calculate polygon normal vectors
    calc_normals();
    calc_bsphere();
}


OgreWedge::~OgreWedge(void)
{
    // Do nothing
}

