#include <math.h>

#include "ogreobj.hpp"
#include "o-triang.hpp"


OgreTriangle::OgreTriangle(float width, float height,
    float point3_x) : OgreObject()
{
    float half_x;

    num_verts = 3;
    num_polys = 1;

    verts = new Vertex[3];
    polys = new Poly[1];

    half_x = width / 2;

    // Do the base vertices
    verts[0].x = -half_x;
    verts[0].y = 0.0;
    verts[0].z = 0.0;

    verts[1].x = half_x;
    verts[1].y = 0.0;
    verts[1].z = 0.0;

    verts[2].x = point3_x;
    verts[2].y = height;
    verts[2].z = 0.0;


    // Do the poly info
    polys[0].num_points  = 3;
    polys[0].color.red   = 128;
    polys[0].color.green = 128;
    polys[0].color.blue  = 128;
    polys[0].points      = new int[3];

    // Construct the polygon points
    if (height > 0.0) {
        polys[0].points[0] = 0;
        polys[0].points[1] = 1;
        polys[0].points[2] = 2;
    } else {
        polys[0].points[0] = 2;
        polys[0].points[1] = 1;
        polys[0].points[2] = 0;
    }

    // Calculate polygon normal vectors
    calc_normals();
    calc_bsphere();
}


OgreTriangle::~OgreTriangle(void)
{
    // Do nothing
}

