#include <math.h>

#include "ogreobj.hpp"
#include "o-torus.hpp"


OgreTorus::OgreTorus(float orbit_radius, float ring_radius,
                     int orbit_around, int ring_around)
{
    long i,j,vnum,pnum;
    float angle_cos, angle_sin;
    float tempx,tempy;
    float ring_angle, orbit_angle;

    num_verts = orbit_around * ring_around;
    num_polys = orbit_around * ring_around;

    verts = new Vertex[num_verts];
    polys = new Poly[num_polys];

    // Create Vertices
    vnum = 0;
    for (i=0; i < orbit_around; i++) {
        orbit_angle = ((M_PI * 2 * i) / orbit_around);

        for (j=0; j < ring_around; j++) {
            ring_angle = ((M_PI * 2 * j) + M_PI) / ring_around;

            verts[vnum].x = 0.0;
            verts[vnum].y = (cos(ring_angle) * ring_radius) + orbit_radius;
            verts[vnum].z =  sin(ring_angle) * ring_radius;

            // Now sweep it
            angle_cos = cos(orbit_angle);
            angle_sin = sin(orbit_angle);

            tempx = (verts[vnum].x * angle_cos) - (verts[vnum].y * angle_sin);
            tempy = (verts[vnum].x * angle_sin) + (verts[vnum].y * angle_cos);

            verts[vnum].x = tempx;
            verts[vnum].y = tempy;

            vnum++;
        }
    }

    // Create Polygons
    pnum = 0;
    for (i=0; i < orbit_around; i++) {
        for (j=0; j < ring_around; j++) {
            polys[pnum].num_points  = 4;
            polys[pnum].color.red   = 128;
            polys[pnum].color.green = 128;
            polys[pnum].color.blue  = 128;
            polys[pnum].points      = new int[4];

            polys[pnum].points[0] = (i * ring_around) + j;
            polys[pnum].points[1] = (i * ring_around) + ((j + 1) % ring_around);
            polys[pnum].points[2] = (((i+1) % orbit_around) * ring_around) +
                                    ((j+1) % ring_around);
            polys[pnum].points[3] = (((i+1) % orbit_around) * ring_around) + j;

            pnum++;
        }
    }

    // Calculate polygon normal vectors
    calc_normals();
    calc_bsphere();
}


OgreTorus::~OgreTorus(void)
{
    // Do nothing
}

