#include <math.h>

#include "ogreobj.hpp"
#include "o-sphere.hpp"


OgreSphere::OgreSphere(float radius, int bands_tall, int bands_around) : OgreObject()
{
    float horiz_angle, vert_angle;
    long i,j;
    int vnum,pnum;


    num_verts = ((bands_around * (bands_tall-1)) + 2);
    num_polys =  (bands_around * bands_tall);

    verts = new Vertex[num_verts];
    polys = new Poly[num_polys];


    for (i=1; i < bands_tall; i++) {
        vert_angle = ((M_PI * i) / bands_tall);

        for (j=0; j < bands_around; j++) {
            horiz_angle = ((M_PI * 2 * j) + M_PI) / bands_around;

            vnum = (((i-1) * bands_around) + j);
            verts[vnum].x = sin( vert_angle) * sin(horiz_angle) * radius;
            verts[vnum].y = cos( vert_angle) * radius;
            verts[vnum].z = sin(-vert_angle) * cos(horiz_angle) * radius;
        }
    }

    vnum = num_verts - 2;
    verts[vnum].x = 0;
    verts[vnum].y = radius;
    verts[vnum].z = 0;

    vnum = num_verts - 1;
    verts[vnum].x = 0;
    verts[vnum].y = -radius;
    verts[vnum].z = 0;


    pnum = 0;
    for (i=0; i < (bands_tall - 2); i++) {
        for (j=0; j < bands_around; j++) {
            polys[pnum].num_points  = 4;
            polys[pnum].color.red   = 128;
            polys[pnum].color.green = 128;
            polys[pnum].color.blue  = 128;
            polys[pnum].points      = new int[4];

            pnum++;
        }
    }

    pnum = ((bands_tall - 2) * bands_around);
    for (i=0; i < (bands_around << 1); i++) {
        polys[pnum].num_points  = 3;
        polys[pnum].color.red   = 128;
        polys[pnum].color.green = 128;
        polys[pnum].color.blue  = 128;
        polys[pnum].points      = new int[3];
        pnum++;
    }

    for (i=0; i < (bands_tall-2); i++) {
        for (j=0; j < bands_around; j++) {
            pnum = (i * bands_around) + j;

            polys[pnum].points[0] =
                (((i+1) * bands_around) + ((j + 1) % bands_around));
            polys[pnum].points[1] =
                ((i * bands_around) + ((j + 1) % bands_around));
            polys[pnum].points[2] =
                ((i * bands_around) + j);
            polys[pnum].points[3] =
                (((i+1) * bands_around) + j);
        }
    }

    pnum = ((bands_tall - 2) * bands_around);
    for (i=0; i < bands_around; i++) {
        polys[pnum].points[0] = ((i + 1) % bands_around);
        polys[pnum].points[1] = (bands_around*(bands_tall-1));
        polys[pnum].points[2] = i;
        pnum++;
    }

    for (i=0; i < bands_around; i++) {
        polys[pnum].points[0] =
            (i + (bands_around * (bands_tall - 2)));
        polys[pnum].points[1] =
            ((bands_around * (bands_tall - 1)) + 1);
        polys[pnum].points[2] =
            (((i + 1) % bands_around) + (bands_around * (bands_tall - 2)));

        pnum++;
    }

    // Calculate polygon normal vectors
    calc_normals();
    calc_bsphere();
}


OgreSphere::~OgreSphere(void)
{
    // Do nothing
}

