#include <math.h>

#include "ogreobj.hpp"
#include "o-soccer.hpp"


OgreSoccer::OgreSoccer(float radius)
{
    int i, pnum;
    float centerx, centery, centerz, centerx2, centerz2;
    float factor, factor2, yfactor;
    float adjust, sidelen, height;
    float pent_theta, hex_theta;
    float pent_radius, hex_radius;

    num_verts = 60;
    num_polys = 32;

    verts = new Vertex[60];
    polys = new Poly[32];

    // Calculate length of a side
    sidelen = radius * 0.43;

    // Angle of arc of a section of a pentagon
    pent_theta  = 0.4 * M_PI;

    // Pentagon radius relative to side length
    pent_radius = sidelen / sqrt(2 - (2 * cos(pent_theta)));

    // Base
    for (i=0; i < 5; i++) {
        verts[i].x = pent_radius * cos(i * pent_theta);
        verts[i].y = 0.0;
        verts[i].z = pent_radius * sin(i * pent_theta);
    }

    height = sqrt((sidelen * sidelen) - (pent_radius * pent_radius));
    for( i = 0; i < 5; i++) {
        verts[i + 5].x = 2 * pent_radius * cos(i * pent_theta);
        verts[i + 5].y = height;
        verts[i + 5].z = 2 * pent_radius * sin(i * pent_theta);
    }

    height *= 2;
    for(i=0; i < 5; i++) {
        verts[ 10 + i * 2 ].y = height;
        verts[ 11 + i * 2 ].y = height;
        centerx = verts[i + 5].x + verts[(i + 1) % 5 + 5].x;
        centerz = verts[i + 5].z + verts[(i + 1) % 5 + 5].z;
        verts[10 + (i * 2)].x = centerx - verts[(i + 1) % 5].x;
        verts[10 + (i * 2)].z = centerz - verts[(i + 1) % 5].z;
        verts[11 + (i * 2)].x = centerx - verts[i].x;
        verts[11 + (i * 2)].z = centerz - verts[i].z;
    }

    factor = pent_radius / (sidelen * cos((M_PI - pent_theta) / 2));
    factor2 = 1 / sin((M_PI - pent_theta) / 2);

    yfactor = (pent_radius + sqrt((pent_radius * pent_radius) - ((sidelen/2) * (sidelen/2))))
           / (sidelen * cos((M_PI - pent_theta) / 2));

    height = verts[5].y + (verts[10].y - verts[5].y) * yfactor;

    for (i=0; i < 5; i++) {
        verts[20 + (i * 2)].y = height;
        verts[21 + (i * 2)].y = height;

        // Find center of chord connecting the two non-adjacent vertices
        centerx = (verts[10 + (2 * i)].x +
            verts[10 + (9 + (2 * i)) % 10].x) / 2.0;
        centerz = (verts[10 + (2 * i)].z +
            verts[10 + (9 + (2 * i)) % 10].z) / 2.0;

        // The center of the pentagon is a factored step from the remaining
        // known vertex through the bisector center just found
        centerx = verts[5 + i].x + (centerx - verts[5 + i].x) * factor;
        centerz = verts[5 + i].z + (centerz - verts[5 + i].z) * factor;

        // Finally step from a bisection point connecting two
        // adjacent known vertices through the pentagon center

        verts[20 + (i * 2)].x = centerx + (centerx - (verts[5 + i].x +
            verts[10 + (2 * i)].x) / 2) * factor2;

        verts[20 + (i * 2)].z = centerz + (centerz - (verts[5 + i].z +
            verts[10 + (2 * i)].z) / 2) * factor2;

        verts[21 + (i * 2)].x = centerx + (centerx - (verts[5 + i].x +
            verts[10 + (9 + (2 * i)) % 10].x) / 2) * factor2;

        verts[21 + (i * 2)].z = centerz + (centerz - (verts[5 + i].z +
            verts[10 + (9 + (2 * i)) % 10].z) / 2) * factor2;
    } /* End of for loop for inverted pentagons. Whew! */

    /* Now for some more hexagons.  Invert through centers again. */

    height = 2.0 * verts[20].y - verts[10].y;
    for (i = 0; i < 5; i++) {
        verts[30 + (i * 2)].y = height;
        verts[31 + (i * 2)].y = height;

        centerx = verts[21 + (2 * i)].x + verts[20 + (i + 1) * 2 % 10].x;
        centerz = verts[ 21 + 2 * i ].z + verts[20 + (i + 1) * 2 % 10].z;

        verts[30 + (i * 2)].x = centerx - verts[11 + (i * 2)].x;
        verts[30 + (i * 2)].z = centerz - verts[11 + (i * 2)].z;
        verts[31 + (i * 2)].x = centerx - verts[10 + (i * 2)].x;
        verts[31 + (i * 2)].z = centerz - verts[10 + (i * 2)].z;
    } /* End of loop calculating second batch of hexagons */

    /* Now for the third row of hexagons.  Invert through centers again. */

    height = 2.0 * verts[30].y - verts[20].y;

    for (i=0; i < 5; i++) {
        verts[40 + (i * 2)].y = height;
        verts[41 + (i * 2)].y = height;

        centerx = verts[30 + (2 * i)].x + verts[30 + (9 + (i * 2)) % 10].x;
        centerz = verts[30 + (2 * i)].z + verts[30 + (9 + (i * 2)) % 10].z;

        verts[40 + (i * 2)].x = centerx - verts[21 + (i * 2)].x;
        verts[40 + (i * 2)].z = centerz - verts[21 + (i * 2)].z;
        verts[41 + (i * 2)].x = centerx - verts[20 + (i * 2)].x;
        verts[41 + (i * 2)].z = centerz - verts[20 + (i * 2)].z;
    } /* End of loop calculating third batch of hexagons */

    // Now for a row of pentagons right side up. Four vertices are
    // already known, so this is a ( relatively ) simple factored
    // step from one chord bisector through another.

    factor = sidelen * cos((M_PI - pent_theta) / 2) / (pent_radius +
        sqrt((pent_radius * pent_radius) - (sidelen * sidelen) / 4 ) -
        sidelen * cos((M_PI - pent_theta) / 2));

    height = verts[40].y + (verts[40].y - verts[30].y) * factor;

    for (i=0; i < 5; i++) {
        verts[50 + i].y = height;
        centerx = (verts[41 + (2 * i)].x + verts[40 + ((2 * i) + 2) % 10].x) / 2;
        centerx2 = (verts[30 + (i * 2)].x + verts[31 + (i * 2)].x) / 2;

        verts[50 + i].x = centerx + (centerx - centerx2) * factor;
        centerz = (verts[41 + (2 * i)].z + verts[40 + ((2 * i) + 2) % 10].z) / 2;
        centerz2 = (verts[30 + (i * 2)].z + verts[31 + (i * 2)].z) / 2;
        verts[50 + i].z = centerz + (centerz - centerz2) * factor;
    } /* End of loop for right side up pentagons */

    /* Finally the five base vertices on the top.  This is another
	   simple pentagon like the base, but offset by half a pent segment. */

    height = (2 * verts[50].y) - verts[40].y;
    for (i=0; i < 5; i++) {
        verts[55 + i].x = pent_radius * cos((i * pent_theta) + (pent_theta / 2));
        verts[55 + i].y = height;
        verts[55 + i].z = pent_radius * sin((i * pent_theta) + (pent_theta / 2));
    }


    /* Base is a pentagon */
    polys[0].num_points  = 5;
    polys[0].color.red   = 128;
    polys[0].color.green = 128;
    polys[0].color.blue  = 128;
    polys[0].points      = new int[5];
    polys[0].points[0]   = 4;
    polys[0].points[1]   = 3;
    polys[0].points[2]   = 2;
    polys[0].points[3]   = 1;
    polys[0].points[4]   = 0;

    pnum = 1;

    /* First row of hexagons */
    for (i=0; i < 5; i++) {
        polys[pnum].num_points  = 6;
        polys[pnum].color.red   = 128;
        polys[pnum].color.green = 128;
        polys[pnum].color.blue  = 128;
        polys[pnum].points      = new int[6];
        polys[pnum].points[0]   =   i;
        polys[pnum].points[1]   =  (i + 1) % 5;
        polys[pnum].points[2]   = ((i + 1) % 5) + 5;
        polys[pnum].points[3]   =  (i * 2) + 11;
        polys[pnum].points[4]   =  (i * 2) + 10;
        polys[pnum].points[5]   =  (i + 5);
        pnum++;
    }

	/* Row of inverted pentagons */
    for (i=0; i < 5; i++) {
        polys[pnum].num_points  = 5;
        polys[pnum].color.red   = 128;
        polys[pnum].color.green = 128;
        polys[pnum].color.blue  = 128;
        polys[pnum].points      = new int[5];
        polys[pnum].points[0]   =   (i * 2) + 10;
        polys[pnum].points[1]   =   (i * 2) + 21;
        polys[pnum].points[2]   =   (i * 2) + 20;
        polys[pnum].points[3]   = (((i * 2) + 9) % 10) + 10;
        polys[pnum].points[4]   =   (i + 5);
        pnum++;
    }

	/* Second row of hexagons */
    for (i=0; i < 5; i++) {
        polys[pnum].num_points  = 6;
        polys[pnum].color.red   = 128;
        polys[pnum].color.green = 128;
        polys[pnum].color.blue  = 128;
        polys[pnum].points      = new int[6];
        polys[pnum].points[0]   =   (i * 2) + 11;
        polys[pnum].points[1]   = (((i + 1) * 2) % 10) + 20;
        polys[pnum].points[2]   =   (i * 2) + 31;
        polys[pnum].points[3]   =   (i * 2) + 30;
        polys[pnum].points[4]   =   (i * 2) + 21;
        polys[pnum].points[5]   =   (i * 2) + 10;
        pnum++;
    }

	/* Third row of hexagons */
    for (i=0; i < 5; i++) {
        polys[pnum].num_points  = 6;
        polys[pnum].color.red   = 128;
        polys[pnum].color.green = 128;
        polys[pnum].color.blue  = 128;
        polys[pnum].points      = new int[6];
        polys[pnum].points[0]   =   (i * 2) + 21;
        polys[pnum].points[1]   =   (i * 2) + 30;
        polys[pnum].points[2]   =   (i * 2) + 41;
        polys[pnum].points[3]   =   (i * 2) + 40;
        polys[pnum].points[4]   = (((i * 2) + 9) % 10) + 30;
        polys[pnum].points[5]   =   (i * 2) + 20;
        pnum++;
    }

	/* Right side up pentagons */
    for (i=0; i < 5; i++) {
        polys[pnum].num_points  = 5;
        polys[pnum].color.red   = 128;
        polys[pnum].color.green = 128;
        polys[pnum].color.blue  = 128;
        polys[pnum].points      = new int[5];
        polys[pnum].points[0]   =   (i * 2) + 30;
        polys[pnum].points[1]   =   (i * 2) + 31;
        polys[pnum].points[2]   = (((i * 2) + 2) % 10) + 40;
        polys[pnum].points[3]   =   (i + 50);
        polys[pnum].points[4]   =   (i * 2) + 41;
        pnum++;
    }

	/* Last row of hexagons */
    for (i=0; i < 5; i++) {
        polys[pnum].num_points  = 6;
        polys[pnum].color.red   = 128;
        polys[pnum].color.green = 128;
        polys[pnum].color.blue  = 128;
        polys[pnum].points      = new int[6];
        polys[pnum].points[0]   =  (i * 2) + 40;
        polys[pnum].points[1]   =  (i * 2) + 41;
        polys[pnum].points[2]   =  (i + 50);
        polys[pnum].points[3]   =  (i + 55);
        polys[pnum].points[4]   = ((i + 4) % 5) + 55;
        polys[pnum].points[5]   = ((i + 4) % 5) + 50;
        pnum++;
    }

	/* And finally the top */
    polys[31].num_points  = 5;
    polys[31].color.red   = 128;
    polys[31].color.green = 128;
    polys[31].color.blue  = 128;
    polys[31].points      = new int[5];
    polys[31].points[0]   = 55;
    polys[31].points[1]   = 56;
    polys[31].points[2]   = 57;
    polys[31].points[3]   = 58;
    polys[31].points[4]   = 59;


    // Make the soccer ball centered, instead of zero on up...
    adjust = verts[num_verts-1].y / 2;
    for (i=0; i < num_verts; i++) {
        verts[i].y = verts[i].y - adjust;
    }


    // Calculate polygon normal vectors
    calc_normals();
    calc_bsphere();
}


OgreSoccer::~OgreSoccer(void)
{
    // Do nothing
}

