#include <math.h>

#include "ogreobj.hpp"
#include "o-revolv.hpp"


OgreRevolution::OgreRevolution(float band_height,
    int bands_tall, int bands_around, float threshold, float *data) : OgreObject()
{
    float temp_radius, temp_angle;
    int *reduce_flags;
    int i,j,k,vnum,pnum,diff,orig_diff;

    num_verts =  (bands_around *  bands_tall);
    num_polys = ((bands_around * (bands_tall - 1)) + 2);

    verts = new Vertex[num_verts];

    for (i=0; i < bands_tall; i++) {
        temp_radius = data[i];

        for (j=0; j < bands_around; j++) {
            temp_angle = ((M_PI * 2 * j) + M_PI) / bands_around;

            vnum = (i * bands_around) + j;

            verts[vnum].x =  sin(temp_angle) * temp_radius;
            verts[vnum].y = ((((bands_tall-1) - (i * 2)) * band_height) / 2);
            verts[vnum].z = -cos(temp_angle) * temp_radius;
        }
    }


    /* Start Polygon Reduction Mod */

    if (threshold >= 0) {
        reduce_flags = new int[bands_tall];

        for (i=1; i < (bands_tall-1); i++) {
            if (fabs((data[i] - data[i-1]) - (data[i+1] - data[i])) <= threshold) {
                reduce_flags[i] = 1;
            } else {
                reduce_flags[i] = 0;
            }
        }

        for (i=1; i < (bands_tall-1); i++) {
            if (reduce_flags[i]) {
                for (j = i; j < (bands_tall - 1); j++) {
                    for (k=0; k < bands_around; k++) {
                        pnum = (j * bands_around) + k;

                        verts[pnum].x = verts[pnum+bands_around].x;
                        verts[pnum].y = verts[pnum+bands_around].y;
                        verts[pnum].z = verts[pnum+bands_around].z;
                    }

                    data[j] = data[j+1];
                    reduce_flags[j] = reduce_flags[j+1];
                }
                i--;
                bands_tall--;
            }
        }

        delete reduce_flags;

        num_verts =  (bands_around *  bands_tall);
        num_polys = ((bands_around * (bands_tall - 1)) + 2);
    }

    /* End   Polygon Reduction Mod */


    polys = new Poly[num_polys];

    pnum = 0;
    for (i=0; i < (bands_tall - 1); i++) {
        for (j=0; j < bands_around; j++) {
            polys[pnum].num_points  = 4;
            polys[pnum].color.red   = 128;
            polys[pnum].color.green = 128;
            polys[pnum].color.blue  = 128;
            polys[pnum].points      = new int[4];
            pnum++;
        }
    }

    for (i=0; i < 2; i++) {
        pnum = (bands_around * (bands_tall - 1)) + i;

        polys[pnum].num_points  = bands_around;
        polys[pnum].color.red   = 128;
        polys[pnum].color.green = 128;
        polys[pnum].color.blue  = 128;
        polys[pnum].points      = new int[bands_around];
    }

    pnum = 0;
    for (i=0; i < (bands_tall - 1); i++) {
        for (j=0; j < bands_around; j++) {
            polys[pnum].points[0] =
                (((i+1) * bands_around) + ((j+1) % bands_around));
            polys[pnum].points[1] =
                ((i * bands_around) + ((j+1) % bands_around));
            polys[pnum].points[2] =
                ((i * bands_around) + j);
            polys[pnum].points[3] =
                (((i+1) * bands_around) + j);
            pnum++;
        }
    }

    for (i=0; i < bands_around; i++) {
        polys[(bands_around * (bands_tall-1))].points[i] = i;
    }

    for (i=0; i < bands_around; i++) {
        polys[(bands_around * (bands_tall-1))+1].points[i] =
            (bands_around * (bands_tall)) - 1 - i;
    }

    // Calculate polygon normal vectors
    calc_normals();
    calc_bsphere();
}


OgreRevolution::~OgreRevolution(void)
{
    // Do Nothing
}

