#include <math.h>

#include "ogreobj.hpp"
#include "o-rect.hpp"


OgreRectangle::OgreRectangle(float x_size, float y_size) : OgreObject()
{
    float half_x, half_y;

    num_verts = 4;
    num_polys = 1;

    verts = new Vertex[4];
    polys = new Poly[1];

    half_x = x_size / 2;
    half_y = y_size / 2;

    // Do the base vertices
    verts[0].x = -half_x;
    verts[0].y = -half_y;
    verts[0].z = 0.0;

    verts[1].x = half_x;
    verts[1].y = -half_y;
    verts[1].z = 0.0;

    verts[2].x = half_x;
    verts[2].y = half_y;
    verts[2].z = 0.0;

    verts[3].x = -half_x;
    verts[3].y = half_y;
    verts[3].z = 0.0;

    // Do the poly info
    polys[0].num_points  = 4;
    polys[0].color.red   = 128;
    polys[0].color.green = 128;
    polys[0].color.blue  = 128;
    polys[0].points      = new int[4];

    // Construct the polygon points
    polys[0].points[0] = 0;
    polys[0].points[1] = 1;
    polys[0].points[2] = 2;
    polys[0].points[3] = 3;

    // Calculate polygon normal vectors
    calc_normals();
    calc_bsphere();
}


OgreRectangle::~OgreRectangle(void)
{
    // Do nothing
}

