#include <math.h>

#include "ogreobj.hpp"
#include "o-pyramd.hpp"


OgrePyramid::OgrePyramid(float radius, float height, int sides) : OgreObject()
{
    int i;
    float temp_angle, half_height;

    num_verts = (sides + 1);
    num_polys = (sides + 1);

    verts = new Vertex[num_verts];
    polys = new Poly[num_polys];

    half_height = height / 2;

    // Do the base vertices
    for (i=0; i < sides; i++) {
        temp_angle = ((M_PI * 2 * i) + M_PI) / sides;

        verts[i].x = radius * sin(temp_angle);
        verts[i].y = -half_height;
        verts[i].z = radius * cos(temp_angle);
    }

    // Do the pointy vertex
    verts[sides].x = 0;
    verts[sides].y = half_height;
    verts[sides].z = 0;


    // Allocate the polygons
    for (i=0; i < sides; i++) {
        polys[i].num_points  = 3;
        polys[i].color.red   = 128;
        polys[i].color.green = 128;
        polys[i].color.blue  = 128;
        polys[i].points      = new int[3];
    }

    // Allocate the base polygon
    polys[sides].num_points = sides;
    polys[sides].color.red   = 128;
    polys[sides].color.green = 128;
    polys[sides].color.blue  = 128;
    polys[sides].points      = new int[sides];


    // Construct the polygons
    for (i=0; i < sides; i++) {
        polys[i].points[0] = i;
        polys[i].points[1] = sides;
        polys[i].points[2] = ((i+1) % sides);
    }

    // Construct the base polygon
    for (i=0; i < sides; i++) {
        polys[sides].points[i] = i;
    }

    // Calculate polygon normal vectors
    calc_normals();
    calc_bsphere();
}


OgrePyramid::~OgrePyramid(void)
{
    // Do nothing
}

