#include <stdio.h>
#include <time.h>

#include "garand.hpp"
#include "ogreobj.hpp"
#include "o-post.hpp"


OgrePostField::OgrePostField(int xdim, int ydim, float patch_xsize,
               float patch_ysize, int maxheight) : OgreObject()
{
    int i, tx, ty;

    GArand_seed(time(NULL));

    num_verts = (xdim+1) * (ydim+1);
    num_polys = (xdim * ydim) * 2;    // Triangular Patches

    verts = new Vertex[num_verts];
    polys = new Poly[num_polys];

    for (i=0; i < num_polys; i++) {
        polys[i].num_points  = 3;
        polys[i].color.red   = 128;
        polys[i].color.green = 128;
        polys[i].color.blue  = 128;
        polys[i].points      = new int[3];
    }

    for (i=0; i < num_polys; i+=2) {
        tx = (i/2) % xdim;
        ty = (i/2) / xdim;

        if (GArand() & 4) {
            polys[i  ].points[0] = (ty * (xdim + 1)) + tx + 1;
            polys[i  ].points[1] = ((ty + 1) * (xdim + 1)) + tx + 1;
            polys[i  ].points[2] = (ty * (xdim + 1)) + tx;

            polys[i+1].points[0] = ((ty + 1) * (xdim + 1)) + tx + 1;
            polys[i+1].points[1] = ((ty + 1) * (xdim + 1)) + tx;
            polys[i+1].points[2] = (ty * (xdim + 1)) + tx;
        } else {
            polys[i  ].points[0] = (ty * (xdim + 1)) + tx + 1;
            polys[i  ].points[1] = ((ty + 1) * (xdim + 1)) + tx;
            polys[i  ].points[2] = (ty * (xdim + 1)) + tx;

            polys[i+1].points[0] = ((ty + 1) * (xdim + 1)) + tx + 1;
            polys[i+1].points[1] = ((ty + 1) * (xdim + 1)) + tx;
            polys[i+1].points[2] = (ty * (xdim + 1)) + tx + 1;
        }
    }

    for (i=0; i < num_verts; i++) {
        tx = i % (xdim+1);
        ty = i / (xdim+1);

        verts[i].x = ((tx - (xdim / 2)) * patch_xsize);
        verts[i].y = ((ty - (ydim / 2)) * patch_ysize);
        verts[i].z = -(GArand() % maxheight);
    }
}


OgrePostField::OgrePostField(char *fname)
{
    FILE *fp;
    char tempstr[256];
    int i, tx, ty, xdim, ydim;
    float patch_xsize, patch_ysize;

    fp = fopen(fname, "rt");

    if (fp != NULL) {
        get_next_line(tempstr, 256, fp);

        sscanf(tempstr,"%d %d %f %f",&xdim,&ydim,&patch_xsize,&patch_ysize);

        num_verts = (xdim+1) * (ydim+1);
        num_polys = (xdim * ydim) * 2;    // Triangular Patches

        verts = new Vertex[num_verts];
        polys = new Poly[num_polys];

        for (i=0; i < num_polys; i++) {
            polys[i].num_points  = 3;
            polys[i].color.red   = 128;
            polys[i].color.green = 128;
            polys[i].color.blue  = 128;
            polys[i].points      = new int[3];
        }

        for (i=0; i < num_polys; i+=2) {
            tx = (i/2) % xdim;
            ty = (i/2) / xdim;

            if (GArand() & 4) {
                polys[i  ].points[0] = (ty * (xdim + 1)) + tx + 1;
                polys[i  ].points[1] = ((ty + 1) * (xdim + 1)) + tx + 1;
                polys[i  ].points[2] = (ty * (xdim + 1)) + tx;

                polys[i+1].points[0] = ((ty + 1) * (xdim + 1)) + tx + 1;
                polys[i+1].points[1] = ((ty + 1) * (xdim + 1)) + tx;
                polys[i+1].points[2] = (ty * (xdim + 1)) + tx;
            } else {
                polys[i  ].points[0] = (ty * (xdim + 1)) + tx + 1;
                polys[i  ].points[1] = ((ty + 1) * (xdim + 1)) + tx;
                polys[i  ].points[2] = (ty * (xdim + 1)) + tx;

                polys[i+1].points[0] = ((ty + 1) * (xdim + 1)) + tx + 1;
                polys[i+1].points[1] = ((ty + 1) * (xdim + 1)) + tx;
                polys[i+1].points[2] = (ty * (xdim + 1)) + tx + 1;
            }
        }

        for (i=0; i < num_verts; i++) {
            tx = i % (xdim+1);
            ty = i / (xdim+1);

            verts[i].x = ((tx - (xdim / 2)) * patch_xsize);
            verts[i].y = ((ty - (ydim / 2)) * patch_ysize);

            fscanf(fp, "%f", &verts[i].z);
            verts[i].z = -(verts[i].z);
        }

        fclose(fp);
    }

    // Calculate polygon normal vectors
    calc_normals();
    calc_bsphere();
}


OgrePostField::~OgrePostField(void)
{
    // Do Nothing
}

