#include <math.h>

#include "ogreobj.hpp"
#include "o-poly.hpp"


OgrePolygon::OgrePolygon(int sides, float radius) : OgreObject()
{
    int i;
    float temp_angle;

    num_verts = sides;
    num_polys = 1;

    verts = new Vertex[sides];
    polys = new Poly[1];

    // Do the base vertices
    for (i=0; i < sides; i++) {
        temp_angle = ((M_PI * 2 * i) + M_PI) / sides;

        verts[i].x = radius * sin(temp_angle);
        verts[i].y = -radius * cos(temp_angle);
        verts[i].z = 0.0;
    }

    // Do the poly info
    polys[0].num_points  = sides;
    polys[0].color.red   = 128;
    polys[0].color.green = 128;
    polys[0].color.blue  = 128;
    polys[0].points      = new int[sides];

    // Construct the polygon points
    for (i=0; i < sides; i++) {
        polys[0].points[i] = i;
    }

    // Calculate polygon normal vectors
    calc_normals();
    calc_bsphere();
}


OgrePolygon::~OgrePolygon(void)
{
    // Do nothing
}

