#include <math.h>

#include "ogreobj.hpp"
#include "o-panel.hpp"

#define ZERO_FUZZ  (0.0)

OgrePanel::OgrePanel(int num_points, float band_width, float thickness,
                     float threshold, float *data) : OgreObject()
{
    float half_width, half_thick, diff, slope1, slope2;
    float x1, x2, y1, y2;
    float *x_vals;
    float *loc_data;
    int i, j, points_left, num_splits, last_split, vnum, pnum;
    int *splits;

    half_thick = thickness / 2;
    half_width = ((band_width * (num_points - 1)) / 2);

    points_left = num_points;
    x_vals = new float[num_points];

    loc_data = new float[num_points];
    for (i=0; i < num_points; i++) {
        loc_data[i] = data[i];
    }

    for (i=0; i < num_points; i++) {
        x_vals[i] = (band_width * i) - half_width;
    }


    /* Start Polygon Reduction Mod */

    if (threshold >= 0) {
        for (i=1; i < (points_left-1); i++) {
            slope1 = (loc_data[i] - loc_data[i-1]) / (x_vals[i] - x_vals[i-1]);
            slope2 = (loc_data[i+1] - loc_data[i]) / (x_vals[i+1] - x_vals[i]);

            diff = fabs(slope1 - slope2);

#ifdef MFX
            if (diff <= threshold / 40.0) {
                for (j=i; j < (points_left-1); j++) {
#else
            if (diff <= threshold) {
                for (j=i; j < (num_points-1); j++) {
#endif
                    loc_data[j] = loc_data[j+1];
                    x_vals[j]   = x_vals[j+1];
                }
                i--;
                points_left--;
            }
        }
    }

    /* End   Polygon Reduction Mod */


    /* Begin Concave Poly Splitting Mod */

    splits = new int[points_left];
    for (i=0; i < points_left; i++) {
        splits[i] = 0;
    }

    splits[0] = 1;
    splits[points_left-1] = 1;
    num_splits = 1;

    for (i=1; i < (points_left - 1); i++) {
        x1 = x_vals[i+1] - x_vals[i];
        x2 = x_vals[i-1] - x_vals[i];
        y1 = loc_data[i+1]   - loc_data[i];
        y2 = loc_data[i-1]   - loc_data[i];

        if (((x2 * y1) - (x1 * y2)) < ZERO_FUZZ) {
            /* We found a concavity */
            splits[i] = 1;
            num_splits++;
        }
    }

    /* End   Concave Poly Splitting Mod */

    num_verts = (points_left << 1) + (num_splits << 1) + 2;
    num_polys =  points_left       + (num_splits << 1) + 2;

    verts = new Vertex[num_verts];
    polys = new Poly[num_polys];


    /* Create Vertices */

    for (i=0; i < points_left; i++) {
        verts[(i << 1)    ].x =  x_vals[i];
        verts[(i << 1)    ].y =  loc_data[i];
        verts[(i << 1)    ].z = -half_thick;

        verts[(i << 1) + 1].x =  x_vals[i];
        verts[(i << 1) + 1].y =  loc_data[i];
        verts[(i << 1) + 1].z =  half_thick;
    }


    vnum = points_left * 2;
    for (i=points_left-1; i > 0; i--) {
        if (splits[i]) {
            verts[vnum  ].x = x_vals[i];
            verts[vnum  ].y = 0.0;
            verts[vnum  ].z = -half_thick;
            verts[vnum+1].x = x_vals[i];
            verts[vnum+1].y = 0.0;
            verts[vnum+1].z = half_thick;
            vnum+=2;
        }
    }

    // Create last 2 verts on bottom
    verts[vnum  ].x = x_vals[0];
    verts[vnum  ].y = 0.0;
    verts[vnum  ].z = -half_thick;
    verts[vnum+1].x = x_vals[0];
    verts[vnum+1].y = 0.0;
    verts[vnum+1].z = half_thick;

    /* Finish Vertices */


    /* Create Polygons */

    for (i=0; i < points_left; i++) {
        polys[i].num_points  = 4;
        polys[i].color.red   = 128;
        polys[i].color.green = 128;
        polys[i].color.blue  = 128;
        polys[i].points      = new int[4];

        polys[i].points[0] = (i << 1);
        polys[i].points[1] = ((i + 1) << 1)       % ((points_left << 1) + 4);
        polys[i].points[2] = (((i + 1) << 1) + 1) % ((points_left << 1) + 4);
        polys[i].points[3] = (i << 1) + 1;
    }

    // Bottom Polygon
    polys[points_left].num_points  = 4;
    polys[points_left].color.red   = 128;
    polys[points_left].color.green = 128;
    polys[points_left].color.blue  = 128;
    polys[points_left].points      = new int[4];

    polys[points_left].points[0] = (points_left << 1);
    polys[points_left].points[1] = num_verts-2;
    polys[points_left].points[2] = num_verts-1;
    polys[points_left].points[3] = (points_left << 1) + 1;

    // Left Side Polygon
    polys[points_left+1].num_points  = 4;
    polys[points_left+1].color.red   = 128;
    polys[points_left+1].color.green = 128;
    polys[points_left+1].color.blue  = 128;
    polys[points_left+1].points      = new int[4];

    polys[points_left+1].points[0] = num_verts-2;
    polys[points_left+1].points[1] = 0;
    polys[points_left+1].points[2] = 1;
    polys[points_left+1].points[3] = num_verts-1;


    last_split = points_left-1;
    vnum = (points_left * 2);
    pnum = (points_left + 2);

    for (i=points_left-2; i >= 0; i--) {
        if (splits[i]) {
            polys[pnum].num_points  = (last_split-i) + 3;
            polys[pnum].color.red   = 128;
            polys[pnum].color.green = 128;
            polys[pnum].color.blue  = 128;
            polys[pnum].points      = new int[polys[pnum].num_points];

            for (j=last_split; j >= i; j--) {
                polys[pnum].points[j-i] = (j << 1) + 1;
            }
            polys[pnum].points[last_split - i + 1] = vnum + 1;
            polys[pnum].points[last_split - i + 2] = vnum + 3;

            polys[pnum+1].num_points  = polys[pnum].num_points;
            polys[pnum+1].color.red   = 128;
            polys[pnum+1].color.green = 128;
            polys[pnum+1].color.blue  = 128;
            polys[pnum+1].points      = new int[polys[pnum].num_points];

            for (j=last_split; j >= i; j--) {
                polys[pnum+1].points[last_split-j] = (j << 1);
            }
            polys[pnum+1].points[last_split - i + 1] = vnum+2;
            polys[pnum+1].points[last_split - i + 2] = vnum;

            last_split = i;
            vnum+=2;
            pnum+=2;
        }
    }

    /* Finish Polygons */


    delete x_vals;
    delete splits;
    delete loc_data;

    // Calculate polygon normal vectors
    calc_normals();
    calc_bsphere();
}


OgrePanel::~OgrePanel(void)
{
    // Do Nothing
}

