#include <math.h>

#include "ogreobj.hpp"
#include "o-maze.hpp"


OgreMaze::OgreMaze(char *fname) : OgreObject()
{
    FILE *fp;
    char tempstr[256];
    int xdim, ydim;
    float patch_xsize, patch_ysize, wall_height;

    fp = fopen(fname, "rt");

    if (fp != NULL) {
        get_next_line(tempstr, 256, fp);
#ifdef MFX
        fclose(fp); fp = NULL;
#endif

        sscanf(tempstr,"%d %d %f %f %f", &xdim, &ydim,
               &patch_xsize, &patch_ysize, &wall_height);
    }

    // Calculate polygon normal vectors
    calc_normals();
    calc_bsphere();
}


OgreMaze::~OgreMaze(void)
{
    // Do nothing
}

