#include <math.h>

#include "ogreobj.hpp"
#include "o-gear.hpp"


OgreGear::OgreGear(float major_radius, float minor_radius,
                   float height, int teeth) : OgreObject()
{
    int i, sides;
    float temp_angle, half_height;

    num_verts = (teeth * 4);
    num_polys = (teeth * 4) + 2;

    verts = new Vertex[num_verts];
    polys = new Poly[num_polys];

    half_height = height / 2;

    sides = 2 * teeth;

    for (i=0; i < sides; i++) {
        temp_angle = ((M_PI * 2 * i) + M_PI) / sides;

        if (i % 2) {
            verts[i].x = major_radius * sin(temp_angle);
            verts[i].y = -half_height;
            verts[i].z = major_radius * cos(temp_angle);
        } else {
            verts[i].x = minor_radius * sin(temp_angle);
            verts[i].y = -half_height;
            verts[i].z = minor_radius * cos(temp_angle);
        }
    }

    for (i=sides; i < (2 * sides); i++) {
        temp_angle = ((M_PI * 2 * (i-sides)) + M_PI) / sides;

        if (i % 2) {
            verts[i].x = major_radius * sin(temp_angle);
            verts[i].y = half_height;
            verts[i].z = major_radius * cos(temp_angle);
        } else {
            verts[i].x = minor_radius * sin(temp_angle);
            verts[i].y = half_height;
            verts[i].z = minor_radius * cos(temp_angle);
        }
    }


    for (i=0; i < sides; i++) {
        polys[i].num_points  = 4;
        polys[i].color.red   = 128;
        polys[i].color.green = 128;
        polys[i].color.blue  = 128;
        polys[i].points      = new int[4];
    }

    for (i=sides; i < (2 * sides); i++) {
        polys[i].num_points  = 3;
        polys[i].color.red   = 128;
        polys[i].color.green = 128;
        polys[i].color.blue  = 128;
        polys[i].points      = new int[3];
    }

    for (i=2 * sides; i < num_polys; i++) {
        polys[i].num_points = teeth;
        polys[i].color.red   = 128;
        polys[i].color.green = 128;
        polys[i].color.blue  = 128;
        polys[i].points     = new int[teeth];
    }


    for (i=0; i < sides; i++) {
        polys[i].points[0] = (i + sides);
        polys[i].points[1] = (((i+1) % sides) + sides);
        polys[i].points[2] = ((i+1) % sides);
        polys[i].points[3] = i;
    }

    for (i=(2 * teeth); i < (3 * teeth); i++) {
        polys[i].points[0] = (((i - (2 * teeth)) * 2) + 0) % sides;
        polys[i].points[1] = (((i - (2 * teeth)) * 2) + 1) % sides;
        polys[i].points[2] = (((i - (2 * teeth)) * 2) + 2) % sides;
    }

    for (i=(3 * teeth); i < (4 * teeth); i++) {
        polys[i].points[0] = ((((i - (3 * teeth)) * 2) + 2) % sides) + sides;
        polys[i].points[1] = ((((i - (3 * teeth)) * 2) + 1) % sides) + sides;
        polys[i].points[2] = ((((i - (3 * teeth)) * 2) + 0) % sides) + sides;
    }

    for (i=0; i < teeth; i++) {
        polys[4 * teeth].points[i] = (i * 2);
    }

    for (i=0; i < teeth; i++) {
        polys[(4 * teeth) + 1].points[i] = (((teeth << 1) - 1) - i) * 2;
    }

    // Calculate polygon normal vectors
    calc_normals();
    calc_bsphere();
}


OgreGear::~OgreGear(void)
{
    // Do nothing
}

