#include <math.h>
#include <time.h>

#include "garand.hpp"
#include "ogreobj.hpp"
#include "o-fuzzy.hpp"


OgreFuzzy::OgreFuzzy(float base_radius, int rand_radius,
                     int bands_tall,    int bands_around) : OgreObject()
{
    float horiz_angle, vert_angle;
    long i,j;
    int vnum,pnum,polys_around;

    // For Fuzzyness
    GArand_seed(time(NULL));

    num_verts = ((bands_around * (bands_tall-1)) + 2);
    num_polys =  (bands_around * ((bands_tall * 2) - 2));
    polys_around = 2 * bands_around;

    verts = new Vertex[num_verts];
    polys = new Poly[num_polys];


    for (i=1; i < bands_tall; i++) {
        vert_angle = ((M_PI * i) / bands_tall);

        for (j=0; j < bands_around; j++) {
            horiz_angle = ((M_PI * 2 * j) + M_PI) / bands_around;

            vnum = (((i-1) * bands_around) + j);
            verts[vnum].x = sin( vert_angle) * sin(horiz_angle) *
                            (base_radius + (GArand() % rand_radius));
            verts[vnum].y = cos( vert_angle) *
                            (base_radius + (GArand() % rand_radius));
            verts[vnum].z = sin(-vert_angle) * cos(horiz_angle) *
                            (base_radius + (GArand() % rand_radius));
        }
    }

    vnum = num_verts - 2;
    verts[vnum].x = 0;
    verts[vnum].y = (base_radius + (GArand() % rand_radius));
    verts[vnum].z = 0;

    vnum = num_verts - 1;
    verts[vnum].x = 0;
    verts[vnum].y = -(base_radius + (GArand() % rand_radius));
    verts[vnum].z = 0;


    for (i=0; i < num_polys; i++) {
        polys[i].num_points  = 3;
        polys[i].color.red   = 128;
        polys[i].color.green = 128;
        polys[i].color.blue  = 128;
        polys[i].points      = new int[3];
    }

    pnum = 0;
    for (i=0; i < (bands_tall-2); i++) {
        for (j=0; j < bands_around; j++) {
            if (GArand() & 4) {
                polys[pnum].points[0] =
                    (((i+1) * bands_around) + ((j + 1) % bands_around));
                polys[pnum].points[1] =
                    ((i * bands_around) + ((j + 1) % bands_around));
                polys[pnum].points[2] =
                    (((i+1) * bands_around) + j);


                polys[pnum+1].points[0] =
                    (((i+1) * bands_around) + j);
                polys[pnum+1].points[1] =
                    ((i * bands_around) + ((j + 1) % bands_around));
                polys[pnum+1].points[2] =
                    ((i * bands_around) + j);
            } else {
                polys[pnum].points[0] =
                    (((i+1) * bands_around) + ((j + 1) % bands_around));
                polys[pnum].points[1] =
                    ((i * bands_around) + ((j + 1) % bands_around));
                polys[pnum].points[2] =
                    ((i * bands_around) + j);


                polys[pnum+1].points[0] =
                    (((i+1) * bands_around) + j);
                polys[pnum+1].points[1] =
                    (((i+1) * bands_around) + ((j + 1) % bands_around));
                polys[pnum+1].points[2] =
                    ((i * bands_around) + j);
            }
            pnum += 2;
        }
    }

    pnum = ((bands_tall - 2) * polys_around);
    for (i=0; i < bands_around; i++) {

        polys[pnum].points[0] = ((i + 1) % bands_around);
        polys[pnum].points[1] = (bands_around*(bands_tall-1));
        polys[pnum].points[2] = i;

        pnum++;
    }

    for (i=0; i < bands_around; i++) {
        polys[pnum].points[0] =
            (i + (bands_around * (bands_tall - 2)));
        polys[pnum].points[1] =
            ((bands_around * (bands_tall - 1)) + 1);
        polys[pnum].points[2] =
            (((i + 1) % bands_around) + (bands_around * (bands_tall - 2)));

        pnum++;
    }
    // Calculate polygon normal vectors
    calc_normals();
    calc_bsphere();
}


OgreFuzzy::OgreFuzzy(char *fname)
{
    FILE *fp;
    char tempstr[256];
    float vert_radius1, vert_radius2, radius, base_radius;
    float vert_angle, horiz_angle;
    int i,j,vnum,pnum,dnum;
    int point0, point1, point2, point3;
    float rad0, rad1, rad2, rad3;
    int bands_tall, bands_around;
    float *data;

    // For Fuzzyness
    GArand_seed(time(NULL));

    fp = fopen(fname, "rt");

    if (fp != NULL) {
        get_next_line(tempstr, 256, fp);

        sscanf(tempstr,"%d %d %f %f %f", &bands_around, &bands_tall,
                                         &base_radius,  &vert_radius1,
                                                        &vert_radius2);

        data = new float[bands_around * bands_tall];
        bands_tall++;

        num_verts = ((bands_around * (bands_tall-1)) + 2);
        num_polys =  (bands_around * ((bands_tall * 2) - 2));

        verts = new Vertex[num_verts];
        polys = new Poly[num_polys];

        for (i=0; i < (bands_around * (bands_tall-1)); i++) {
            fscanf(fp, "%f", &data[i]);
        }
#ifdef MFX
        fclose(fp); fp = NULL;
#endif

        dnum = 0;
        for (i=1; i < bands_tall; i++) {
            vert_angle = ((M_PI * i) / bands_tall);

            for (j=0; j < bands_around; j++) {
                horiz_angle = ((M_PI * 2 * j) + M_PI) / bands_around;

                radius = data[dnum] + base_radius;
                dnum++;

                vnum = (((i-1) * bands_around) + j);
                verts[vnum].x = sin( vert_angle) * sin(horiz_angle) * radius;
                verts[vnum].y = cos( vert_angle) * radius;
                verts[vnum].z = sin(-vert_angle) * cos(horiz_angle) * radius;
            }
        }

        vnum = num_verts - 2;
        verts[vnum].x = 0;
        verts[vnum].y = vert_radius1;
        verts[vnum].z = 0;

        vnum = num_verts - 1;
        verts[vnum].x = 0;
        verts[vnum].y = -vert_radius2;
        verts[vnum].z = 0;


        pnum = 0;
        for (i=0; i < (bands_tall-2); i++) {
            for (j=0; j < bands_around; j++) {
                point0 = (((i+1) * bands_around) + ((j + 1) % bands_around));
                point1 = ((i * bands_around) + ((j + 1) % bands_around));
                point2 = ((i * bands_around) + j);
                point3 = (((i+1) * bands_around) + j);

                rad0 = data[point0];
                rad1 = data[point1];
                rad2 = data[point2];
                rad3 = data[point3];

                if ((rad0 == rad2) && (rad1 == rad3)) {
                    // If the patch is coplanar, do a rectangle instead
                    // of triangularizing it!
                    polys[pnum].num_points  = 4;
                    polys[pnum].color.red   = 128;
                    polys[pnum].color.green = 128;
                    polys[pnum].color.blue  = 128;
                    polys[pnum].points      = new int[4];

                    polys[pnum].points[0] = point0;
                    polys[pnum].points[1] = point1;
                    polys[pnum].points[2] = point2;
                    polys[pnum].points[3] = point3;

                    pnum++;
                    num_polys--;
                } else if (GArand() & 4) {
                    polys[pnum].num_points  = 3;
                    polys[pnum].color.red   = 128;
                    polys[pnum].color.green = 128;
                    polys[pnum].color.blue  = 128;
                    polys[pnum].points      = new int[3];

                    polys[pnum].points[0] = point0;
                    polys[pnum].points[1] = point1;
                    polys[pnum].points[2] = point3;

                    polys[pnum+1].num_points  = 3;
                    polys[pnum+1].color.red   = 128;
                    polys[pnum+1].color.green = 128;
                    polys[pnum+1].color.blue  = 128;
                    polys[pnum+1].points      = new int[3];

                    polys[pnum+1].points[0] = point1;
                    polys[pnum+1].points[1] = point2;
                    polys[pnum+1].points[2] = point3;
                    pnum += 2;
                } else {
                    polys[pnum].num_points  = 3;
                    polys[pnum].color.red   = 128;
                    polys[pnum].color.green = 128;
                    polys[pnum].color.blue  = 128;
                    polys[pnum].points      = new int[3];
                    polys[pnum].points[0] =
                        (((i+1) * bands_around) + ((j + 1) % bands_around));
                    polys[pnum].points[1] =
                        ((i * bands_around) + ((j + 1) % bands_around));
                    polys[pnum].points[2] =
                        ((i * bands_around) + j);


                    polys[pnum+1].num_points  = 3;
                    polys[pnum+1].color.red   = 128;
                    polys[pnum+1].color.green = 128;
                    polys[pnum+1].color.blue  = 128;
                    polys[pnum+1].points      = new int[3];
                    polys[pnum+1].points[0] =
                        (((i+1) * bands_around) + j);
                    polys[pnum+1].points[1] =
                        (((i+1) * bands_around) + ((j + 1) % bands_around));
                    polys[pnum+1].points[2] =
                        ((i * bands_around) + j);
                    pnum += 2;
                }
            }
        }

        pnum = num_polys - (2 * bands_around);
        for (i=0; i < bands_around; i++) {
            polys[pnum].num_points  = 3;
            polys[pnum].color.red   = 128;
            polys[pnum].color.green = 128;
            polys[pnum].color.blue  = 128;
            polys[pnum].points      = new int[3];
            polys[pnum].points[0] = ((i + 1) % bands_around);
            polys[pnum].points[1] = (bands_around*(bands_tall-1));
            polys[pnum].points[2] = i;

            pnum++;
        }

        for (i=0; i < bands_around; i++) {
            polys[pnum].num_points  = 3;
            polys[pnum].color.red   = 128;
            polys[pnum].color.green = 128;
            polys[pnum].color.blue  = 128;
            polys[pnum].points      = new int[3];
            polys[pnum].points[0] =
                (i + (bands_around * (bands_tall - 2)));
            polys[pnum].points[1] =
                ((bands_around * (bands_tall - 1)) + 1);
            polys[pnum].points[2] =
                (((i + 1) % bands_around) + (bands_around * (bands_tall - 2)));

            pnum++;
        }

        delete data;
    }

    // Calculate polygon normal vectors
    calc_normals();
    calc_bsphere();
}


OgreFuzzy::~OgreFuzzy(void)
{
    // Do nothing
}

