#include <math.h>
#include <time.h>

#include "ogreobj.hpp"
#include "o-frame.hpp"


OgreFramework::OgreFramework(float radius, int sides, int closed_flag,
                             char *fname)
{
    FILE *fp;
#ifdef MFX
    char tempstr[256];
#else
    tempstr[256];
#endif
    int i, num_junctions;
    float *x_junct;
    float *y_junct;
    float *z_junct;

    fp = fopen(fname, "rt");

    if (fp != NULL) {
        get_next_line(tempstr, 256, fp);
        sscanf(tempstr, "%d", &num_junctions);

        x_junct = new float[num_junctions];
        y_junct = new float[num_junctions];
        z_junct = new float[num_junctions];

        for (i=0; i < num_junctions; i++) {
            get_next_line(tempstr, 256, fp);
            sscanf(tempstr, "%f %f %f", &x_junct[i], &y_junct[i], &z_junct[i]);
        }
#ifdef MFX
        fclose(fp); fp = NULL;
#endif

        num_verts = num_junctions * sides;
        if (closed_flag) {
            num_polys = num_junctions * sides;
        } else {
            num_polys = ((num_junctions-1) * sides) + 2;
        }

        verts = new Vertex[num_verts];
        polys = new Poly[num_polys];

        if (closed_flag) {
            for (i=0; i < num_polys; i++) {
                polys[i].num_points  = 4;
                polys[i].color.red   = 128;
                polys[i].color.green = 128;
                polys[i].color.blue  = 128;
                polys[i].points      = new int[4];

                polys[i].points[0] = 0;
                polys[i].points[1] = 0;
                polys[i].points[2] = 0;
                polys[i].points[3] = 0;
            }
        }

        delete x_junct;
        delete y_junct;
        delete z_junct;
    }

    // Calculate polygon normal vectors
    calc_normals();
    calc_bsphere();
}


OgreFramework::~OgreFramework(void)
{
    // Do nothing
}

