#include <math.h>

#include "ogreobj.hpp"
#include "o-cylndr.hpp"


OgreCylinder::OgreCylinder(float top_radius, float bottom_radius,
                           float height, int sides) : OgreObject()
{
    float temp_angle, half_height;
    int i;

    num_verts = (sides * 2);
    num_polys = (sides + 2);

    verts = new Vertex[num_verts];
    polys = new Poly[num_polys];

    half_height = height / 2;

    for (i=0; i < sides; i++) {
        temp_angle = ((M_PI * 2 * i) + M_PI) / sides;

        verts[i].x = bottom_radius * sin(temp_angle);
        verts[i].y = -half_height;
        verts[i].z = bottom_radius * cos(temp_angle);
    }

    for (i=sides; i < (2 * sides); i++) {
        temp_angle = ((M_PI * 2 * (i-sides)) + M_PI) / sides;

        verts[i].x = top_radius * sin(temp_angle);
        verts[i].y = half_height;
        verts[i].z = top_radius * cos(temp_angle);
    }


    for (i=0; i < sides; i++) {
        polys[i].num_points  = 4;
        polys[i].color.red   = 128;
        polys[i].color.green = 128;
        polys[i].color.blue  = 128;
        polys[i].points      = new int[4];
    }

    for (i=sides; i < num_polys; i++) {
        polys[i].num_points = sides;
        polys[i].color.red   = 128;
        polys[i].color.green = 128;
        polys[i].color.blue  = 128;
        polys[i].points     = new int[sides];
    }


    for (i=0; i < sides; i++) {
        polys[i].points[0] = (i + sides);
        polys[i].points[1] = (((i+1) % sides) + sides);
        polys[i].points[2] = ((i+1) % sides);
        polys[i].points[3] = i;
    }

    for (i=0; i < sides; i++) {
        polys[sides].points[i] = i;
    }

    for (i=0; i < sides; i++) {
        polys[sides+1].points[i] = ((sides << 1) - 1) - i;
    }

    // Calculate polygon normal vectors
    calc_normals();
    calc_bsphere();
}


OgreCylinder::~OgreCylinder(void)
{
    // Do nothing
}

