#include <stdio.h>

#include "ogreobj.hpp"
#include "o-checkr.hpp"


OgreCheckerBoard::OgreCheckerBoard(int xdim, int ydim, float patch_xsize,
    float patch_ysize, float thickness,
    unsigned char r1, unsigned char g1, unsigned char b1,
    unsigned char r2, unsigned char g2, unsigned char b2) : OgreObject()
{
    int i, tx, ty;

    num_verts = ((xdim+1) * (ydim+1)) + 4;
    num_polys = (xdim * ydim) + 5;

    verts = new Vertex[num_verts];
    polys = new Poly[num_polys];

    for (i=0; i < (num_polys-5); i++) {
        tx = i % xdim;
        ty = i / xdim;

        polys[i].num_points  = 4;

        if ((tx + ty) % 2) {
            polys[i].color.red   = r1;
            polys[i].color.green = g1;
            polys[i].color.blue  = b1;
        } else {
            polys[i].color.red   = r2;
            polys[i].color.green = g2;
            polys[i].color.blue  = b2;
        }

        polys[i].points      = new int[4];

        polys[i].points[0] = (ty * (xdim + 1)) + tx + 1;
        polys[i].points[1] = ((ty + 1) * (xdim + 1)) + tx + 1;
        polys[i].points[2] = ((ty + 1) * (xdim + 1)) + tx;
        polys[i].points[3] = (ty * (xdim + 1)) + tx;
    }

    for (i=0; i < (num_verts-4); i++) {
        tx = i % (xdim+1);
        ty = i / (xdim+1);

        verts[i].x = ((tx - (xdim / 2)) * patch_xsize) -
            ((patch_xsize * (xdim & 0x01)) / 2);
        verts[i].y = ((ty - (ydim / 2)) * patch_ysize) -
            ((patch_ysize * (ydim & 0x01)) / 2);
        verts[i].z = -(thickness / 2);
    }

    verts[num_verts-4].x = -(xdim * patch_xsize) / 2;
    verts[num_verts-4].y =  (ydim * patch_ysize) / 2;
    verts[num_verts-4].z =  (thickness / 2);

    verts[num_verts-3].x =  (xdim * patch_xsize) / 2;
    verts[num_verts-3].y =  (ydim * patch_ysize) / 2;
    verts[num_verts-3].z =  (thickness / 2);

    verts[num_verts-2].x =  (xdim * patch_xsize) / 2;
    verts[num_verts-2].y = -(ydim * patch_ysize) / 2;
    verts[num_verts-2].z =  (thickness / 2);

    verts[num_verts-1].x = -(xdim * patch_xsize) / 2;
    verts[num_verts-1].y = -(ydim * patch_ysize) / 2;
    verts[num_verts-1].z =  (thickness / 2);

    for (i=num_polys-5; i < num_polys; i++) {
        polys[i].num_points  = 4;

        polys[i].color.red   = (r1+r2) / 2;
        polys[i].color.green = (g1+g2) / 2;
        polys[i].color.blue  = (b1+b2) / 2;

        polys[i].points      = new int[4];
    }

    polys[num_polys-5].points[0] = num_verts - 5 - xdim;
    polys[num_polys-5].points[1] = num_verts - 5;
    polys[num_polys-5].points[2] = num_verts - 3;
    polys[num_polys-5].points[3] = num_verts - 4;

    polys[num_polys-4].points[0] = num_verts - 5;
    polys[num_polys-4].points[1] = xdim;
    polys[num_polys-4].points[2] = num_verts - 2;
    polys[num_polys-4].points[3] = num_verts - 3;

    polys[num_polys-3].points[0] = xdim;
    polys[num_polys-3].points[1] = 0;
    polys[num_polys-3].points[2] = num_verts - 1;
    polys[num_polys-3].points[3] = num_verts - 2;

    polys[num_polys-2].points[0] = 0;
    polys[num_polys-2].points[1] = num_verts - 5 - xdim;
    polys[num_polys-2].points[2] = num_verts - 4;
    polys[num_polys-2].points[3] = num_verts - 1;

    polys[num_polys-1].points[0] = num_verts - 4;
    polys[num_polys-1].points[1] = num_verts - 3;
    polys[num_polys-1].points[2] = num_verts - 2;
    polys[num_polys-1].points[3] = num_verts - 1;

    // Calculate polygon normal vectors
    calc_normals();
    calc_bsphere();
}


OgreCheckerBoard::~OgreCheckerBoard(void)
{
    // Do Nothing
}

