#include <math.h>

#include "ogreobj.hpp"
#include "o-block.hpp"


OgreBlock::OgreBlock(float xsize, float ysize, float zsize) : OgreObject()
{
    int i;
    float xhalf, yhalf, zhalf;

    num_verts = 8;
    num_polys = 6;

    verts = new Vertex[8];
    polys = new Poly[6];

    xhalf = xsize / 2;
    yhalf = ysize / 2;
    zhalf = zsize / 2;

    verts[0].x = -xhalf;
    verts[0].y =  yhalf;
    verts[0].z = -zhalf;

    verts[1].x =  xhalf;
    verts[1].y =  yhalf;
    verts[1].z = -zhalf;

    verts[2].x =  xhalf;
    verts[2].y = -yhalf;
    verts[2].z = -zhalf;

    verts[3].x = -xhalf;
    verts[3].y = -yhalf;
    verts[3].z = -zhalf;

    verts[4].x = -xhalf;
    verts[4].y =  yhalf;
    verts[4].z =  zhalf;

    verts[5].x =  xhalf;
    verts[5].y =  yhalf;
    verts[5].z =  zhalf;

    verts[6].x =  xhalf;
    verts[6].y = -yhalf;
    verts[6].z =  zhalf;

    verts[7].x = -xhalf;
    verts[7].y = -yhalf;
    verts[7].z =  zhalf;


    for (i=0; i < 6; i++) {
        polys[i].num_points  = 4;
        polys[i].color.red   = 128;
        polys[i].color.green = 128;
        polys[i].color.blue  = 128;
        polys[i].points      = new int[4];
    }

    polys[0].points[0] = 3;
    polys[0].points[1] = 2;
    polys[0].points[2] = 1;
    polys[0].points[3] = 0;

    polys[1].points[0] = 6;
    polys[1].points[1] = 7;
    polys[1].points[2] = 4;
    polys[1].points[3] = 5;

    polys[2].points[0] = 0;
    polys[2].points[1] = 1;
    polys[2].points[2] = 5;
    polys[2].points[3] = 4;

    polys[3].points[0] = 2;
    polys[3].points[1] = 3;
    polys[3].points[2] = 7;
    polys[3].points[3] = 6;

    polys[4].points[0] = 2;
    polys[4].points[1] = 6;
    polys[4].points[2] = 5;
    polys[4].points[3] = 1;

    polys[5].points[0] = 7;
    polys[5].points[1] = 3;
    polys[5].points[2] = 0;
    polys[5].points[3] = 4;

    // Calculate polygon normal vectors
    calc_normals();
    calc_bsphere();
}


OgreBlock::~OgreBlock(void)
{
    // Do nothing
}

