#include <math.h>

#include "ogreobj.hpp"
#include "o-bicone.hpp"


OgreBiCone::OgreBiCone(float radius, float top_height,
                       float bottom_height, int sides) : OgreObject()
{
    int i, pcount;
    float temp_angle;

    num_verts = (sides + 2);
    num_polys = (sides * 2);

    pcount = num_polys;

    verts = new Vertex[num_verts];
    polys = new Poly[num_polys];

    // Do the base vertices
    for (i=0; i < sides; i++) {
        temp_angle = ((M_PI * 2 * i) + M_PI) / sides;

        verts[i].x = radius * sin(temp_angle);
        verts[i].y = 0;
        verts[i].z = radius * cos(temp_angle);
    }

    // Do the top pointy vertex
    verts[sides].x = 0;
    verts[sides].y = top_height;
    verts[sides].z = 0;

    // Do the bottom pointy vertex
    verts[sides+1].x = 0;
    verts[sides+1].y = -bottom_height;
    verts[sides+1].z = 0;


    // Allocate the polygons
    for (i=0; i < pcount; i++) {
        polys[i].num_points  = 3;
        polys[i].color.red   = 128;
        polys[i].color.green = 128;
        polys[i].color.blue  = 128;
        polys[i].points      = new int[3];
    }

    // Construct the polygons
    for (i=0; i < sides; i++) {
        // Top
        polys[i].points[0] = i;
        polys[i].points[1] = sides;
        polys[i].points[2] = ((i+1) % sides);

        // Bottom
        polys[i+sides].points[0] = ((i+1) % sides);
        polys[i+sides].points[1] = sides+1;
        polys[i+sides].points[2] = i;
    }

    // Calculate polygon normal vectors
    calc_normals();
    calc_bsphere();
}


OgreBiCone::~OgreBiCone(void)
{
    // Do nothing
}

