#ifndef __LIST__
#define __LIST__

#include <stdio.h>
#include <stdlib.h>

template<class type>
class list
{
protected:

	int		size,pos,last;
	type		*lptr;
	type		errorvalue;

public:

	list();
	list(type ev); 
	~list();

	void		setErrorValue(type ev)
	{
		errorvalue = ev;
	}
	type		getErrorValue()
	{
		return errorvalue;
	}

	int		insert(type l);			// Element an aktueller Position einfgen
	type		deleteCurrent();		// Aktuelles Element lschen
	int		operator+=(type l);		// Element anfgen

	int		isEmpty();			// prft ob die Liste leer ist, -1 bei Fehler
	void		empty();			// leert die Liste

	int		length()			// Anzahl der Elemente
	{
		return size;
	}

	type		operator--();			// Eine Position zurck, NULL=Kettenanfang erreicht
	type		operator++();			// Eine Position vor, NULL=Kettenende erreicht
	type		getFirst();
	type		getLast();
	type		getCurrent();
	type		at(int);
	type		operator[](int);			

	int		find(type);
};


template<class type>
list<type>::list()
{
	size=0;
	pos=last=0;
	lptr=NULL;
//	errorvalue = (type)0;
}

template<class type>
list<type>::~list()
{
	empty();
}

template<class type>
void	list<type>::empty()
{
	if(lptr != NULL)
	{
		getFirst();
		while(!isEmpty()) deleteCurrent();
		free(lptr);
		lptr = NULL;
	} 
}

template<class type>
type	list<type>::deleteCurrent()
{
	int		i;
	type		elem;

	if(isEmpty()) return errorvalue;

	elem = lptr[pos];

	for (i=pos;i<size;i++) 
		lptr[i]=lptr[i+1];
	size--;
	lptr=(type*)realloc(lptr,size * sizeof(type));	

	if(pos >= size) pos = size - 1;

	if(lptr == NULL && size != 0)
	{
		// fehler

		size = 0;
		pos = 0;

		return elem;
	}

	return elem;
}

template<class type>
type	list<type>::operator++()
{
	if(pos >= size - 1 || isEmpty())
	{
		// fehler ???
	 	return errorvalue;
	}	

	return(lptr[++pos]);
}

template<class type>
type	list<type>::operator--()
{
	if(pos <= 1 || isEmpty())
	{
		// fehler ???
	 	return errorvalue;
	}

	return(lptr[--pos]);
}


template<class type>
int	list<type>::operator+=(type l)
{
	lptr=(type*)realloc(lptr,(size + 1) * sizeof(type));
	if(lptr)
	{
		lptr[size]=l;
		size++;
		return 0;
	}
	size = 0;
	pos = 0;

	return(-1);
}

template<class type>
int	list<type>::insert(type l)
{
int i;
	printf("inserting...\n");
	lptr=(type *)realloc(lptr,(size + 1) * sizeof(type));
	if (lptr) {
		for (i=pos;i<size;i++) { printf("%d\n",i);lptr[i+1]=lptr[i]; }
		lptr[pos]=l;
		size++;
		return 0;
	}
	return(-1);
}

template<class type>
int	list<type>::isEmpty()
{
	if(!lptr && size == 0) return !0;
	if((!lptr && size != 0) || (lptr && size == 0)) return -1;

	return 0;
}

template<class type>
type	list<type>::getFirst()
{
	if(isEmpty()) return errorvalue;

	pos = 0;
	return lptr[pos];
}

template<class type>
type	list<type>::getLast()
{
	if(isEmpty()) return errorvalue;

	pos = size  - 1;
	return lptr[pos];
}

template<class type>
type	list<type>::getCurrent()
{
	if(isEmpty()) return errorvalue;

	return lptr[pos];
}

template<class type>
int	list<type>::find(type x)
{
	int	t;

	if(isEmpty()) return -1;

	for(t = 0;t < size;t++)
		if(x == lptr[t]) return (pos = t);

	return -1;
}

template<class type>
type	list<type>::at(int t)
{
	if(isEmpty()) return errorvalue;

	if(t < 0 || t >= size) return errorvalue;

	return lptr[(pos = t)];
}

template<class type>
type	list<type>::operator[](int t)
{
	return at(t);
}


#endif
