#ifndef vector_included
#define vector_included

#include <matrix.h>


class Vector : public TMatrix
{
public:
	Vector(int n = 3):TMatrix(n) {};

	void	operator()(double x, double y)
	{
		(*this)(x,y,0,1);
	}
	void	operator()(double x, double y, double z) 
	{ 
		(*this)(x,y,z,1);
	} 
	void	operator()(double x, double y, double z,double w) 
	{ 
		if(row > 0) elements[0]=x; 
		if(row > 1) elements[1]=y; 
		if(row > 2) elements[2]=z; 
		if(row > 3) elements[3]=w; 
	} 
	inline double&	operator[](int i)
	{
		return elements[i];
	}
	inline double	operator[](int i) const
	{ 
		return (row > i ? elements[i] : 1); 
	} 


};


class Vector2d : public Vector
{
public:
	Vector2d() : Vector(2) {};
};

class Vector3d : public Vector
{
public:
	Vector3d() : Vector(3) {};
};

class Vector4d : public Vector
{
public:
	Vector4d() : Vector(4) {};
};


#endif
