// matrix.h
// Header-Datei zur Matrizenrechnng

#ifndef __matrix_h__
#define __matrix_h__

#include <iostream.h>

class TMatrix
{
protected:

	int row,col;
	double *elements;

public:

	TMatrix(int,int);
	TMatrix(int);
	TMatrix(); 
	TMatrix(TMatrix &);
	~TMatrix() { delete elements;}
	void		resize(int);
	void		resize(int,int);
	TMatrix		operator+(const TMatrix &);
	TMatrix		operator-(const TMatrix &); 
	TMatrix		operator*(const TMatrix &);
	TMatrix 	operator*(const double &); 
	TMatrix 	&operator=(const TMatrix &);
	TMatrix 	&operator+=(const TMatrix &m);
	TMatrix 	&operator-=(const TMatrix &m);
	TMatrix 	&operator*=(const TMatrix &m);
	TMatrix		&operator*=(const double &d);
	inline double	&operator()(int,int) const;
	inline double	&operator()(int) const;
	inline double	&operator()(int,int); 
	inline double	&operator()(int); 
	void		Print();
	double		Sum();
	TMatrix		operator~();
	void		unify();

	friend istream &operator>>(istream &,TMatrix &);
};

#endif
