// matrix.h
// Header-Datei zur Matrizenrechnng


#include <memory.h>
#include <iostream.h>
#include <stdlib.h>
#include <iomanip.h>
#ifdef _MSC_VER
 #include <memory.h>
#endif
#ifdef _BORLANDC_
 #include <mset.h>
#endif
#include "matrix.h"

TMatrix::TMatrix(int r,int c)
{
	int a,b;

	row = r; col = c; 
	elements = new double[r*c];
	for (a=0;a<r;a++)
		for (b=0;b<c;b++)
		{
			(*this)(a,b)=0;
		}
}

TMatrix::TMatrix(int r)
{
	int	a;

	row = r;col = 1; 
	elements = new double[r];
	for(a = 0;a < r;a++)
	{
		(*this)(a)=0;
	} 
}

TMatrix::TMatrix() 
{
	TMatrix(4,4);
}

TMatrix::TMatrix(TMatrix &copy)
{
	int a,b; 

	row = copy.row;
	col = copy.col;
	elements = new double[row * col];
	for (a = 0;a < row;a++)
		for (b = 0;b < col;b++)
		{
			(*this)(a,b) = copy(a,b);
		} 
}

void	TMatrix::resize(int r,int c) 
{ 
	int a,b; 

	row = r; col = c; 
	elements = new double[r*c]; 
	for(a = 0;a < r;a++)
		for(b = 0;b < c;b++)
		{
			(*this)(a,b)=0;
		} 
	row = r; col = c; 
} 
 
void	TMatrix::resize(int r) 
{ 
	int	a;

	row = r;col = 1; 
	elements = new double[r]; 
	for(a = 0;a < r;a++)
	{
		(*this)(a)=0;
	} 
} 
 
TMatrix TMatrix::operator+(const TMatrix &right)
{
	TMatrix		temp(*this);
	int		i;

	for(i = 0; i < row * col; i++)
		temp.elements[i] = temp.elements[i] + right.elements[i];
	return temp;
}

TMatrix TMatrix::operator-(const TMatrix &right) 
{ 
	TMatrix		temp(*this); 
	int		i;

	for(i = 0; i < row * col; i++) 
		temp.elements[i] = temp.elements[i] - right.elements[i]; 
	return temp; 
} 
 
TMatrix TMatrix::operator*(const TMatrix &right)
{
	TMatrix		prod(row,right.col);
	int		i,j,k;

	for(i = 0; i < row; i++)
	{
		for(j = 0; j < right.col; j++)
		{
			prod(i,j) = 0;
			for(k = 0; k < col; k++)
				prod(i,j) += (*this)(i,k) * right(k,j);
		}
	}

	return prod;
}

TMatrix TMatrix::operator*(const double &right) 
{ 
	TMatrix	prod(row,col); 

	for (int i = 0; i < row; i++) 
	{ 
		for (int j = 0; j < col; j++) 
		{ 
			prod(i,j) = prod(i,j) * right; 
		} 
	} 
	return prod; 
} 
 
TMatrix &TMatrix::operator=(const TMatrix &right)
{
	int	i,j;

	delete elements;

	elements = new double[row * col];

	for(i = 0; i < row; i++) 
	{ 
		for(j = 0; j < col; j++) 
		{ 
			(*this)(i,j) = right(i,j); 
		} 
	} 

	return *this;
}

double &TMatrix::operator()(int r,int c)
{
	return elements[r * col + c];
}

double &TMatrix::operator()(int r)
{
	return elements[r];
}

double &TMatrix::operator()(int r,int c) const
{ 
	return elements[r * col + c]; 
} 
 
double &TMatrix::operator()(int r) const
{ 
	return elements[r]; 
} 
 
void TMatrix::Print()
{
	cout.setf(ios::fixed);
	cout << setprecision(4);
	for (int i = 0; i < row; i++)
	  {
	  for (int j = 0; j < col; j++)
		  cout << setw(8) << (*this)(i,j);
	  cout << endl;
	  }
}

double TMatrix::Sum()
{
	double	temp = 0;
	int	i,j;

	for(i = 0; i < row; i++)
		for(j = 0; j < col; j++)
			temp += (*this)(i,j);

	return temp;
}

TMatrix TMatrix::operator~()
// Inverse durch Gauss-Elimination mit Pivotsuche
{
	int i, j, k, n;
	int pivrow, tarrow;
	double pivelt, tarelt;

	n = row; // Zahl d.Gleich.
	TMatrix aug(n,2*col);
	TMatrix inverse(n,col);
	for (i = 0; i < n; i++)
	for (j = 0; j < col; j++)
	  aug(i,j) = (*this)(i,j);
	for (i = 0; i < n; i++)
	for (j = n+1; j < aug.col; j++)
	  if (i == j-n) aug(i,j) = 1; // Einheitsmatrix
	for (pivrow = 0; pivrow < n; pivrow++)
	{
		pivelt = aug(pivrow,pivrow);
		if (pivelt == 0)
		  {
		  k = pivrow + 1;	// Pivotsuche
		  while (pivelt == 0 && k <= n)
		  {
			  pivelt = aug(k,pivrow);
			  k++;
		  }
		  if (pivelt == 0)
		  { cout << "Fehler - Matrix singulaer"; exit(1); }
		  }
		else
		  {k--;
		  TMatrix dum(2*col);
		  for (i = 0; i < 2*col; i++)
			  dum(i) = aug(pivrow,i);
		  for (i = 0; i < 2*col; i++)
			  aug(pivrow,i) = aug(k,i);
		  for (i = 0; i < 2*col; i++)
			  aug(k,i) = dum(i);
		  }
		 }
		for (j = 0; j < 2*col; j++)
		  aug(pivrow,j) = aug(pivrow,j)/pivelt;
		for (tarrow = 0; tarrow < n; tarrow++)
		  if (tarrow != pivrow)
		  {
		  tarelt = aug(tarrow,pivrow);
		  for (j = 0; j< 2*col; j++)
		  aug(tarrow,j) = aug(tarrow,j) - aug(pivrow,j)*tarelt;
		  }
		for (i = 0; i < n; i++)
		for (j = n+1; j < aug.col; j++)
		  inverse(i,j-n) = aug(i,j);
	return inverse;
}

istream &operator>>(istream &is,TMatrix &m)
{
	for (int i = 0; i < m.row; i++)
		for (int j = 0; j < m.col; j++)
		  is >> m(i,j);
	return is;
}

TMatrix &TMatrix::operator+=(const TMatrix &m)
{
	TMatrix	t(row,col);

	t = (*this) + m;

	return (*this = t);
}

TMatrix &TMatrix::operator-=(const TMatrix &m)
{
	TMatrix	t(row,col);

	t = (*this) - m;

	return (*this = t);
}

TMatrix &TMatrix::operator*=(const TMatrix &m)
{
	TMatrix	t(row,col);

	t = (*this) * m;

	return (*this = t);
}

TMatrix &TMatrix::operator*=(const double &d)
{
	TMatrix	t1(row,col),t2(this->row,this->col);

	t2 = *this;
	t1 = t2 * d;

	return (*this = t1);
}

void	TMatrix::unify()
{
	int	x,y;

	for(x = 0;x < row;x++)
	{
		for(y = 0;y < col;y++)
		{
			(*this)(x,y) = (x == y ? 1 : 0);
		}
	}
}

