#ifndef __matmath_h__
#define __matmath_h__

#include <stdio.h>
#include <math.h>

class Vector2;
class Vector3;
class Vector4;

class Matrix44
{
protected:

	double 	elements[4][4];

public:

	Matrix44(); 
	Matrix44(Matrix44 &);

	Matrix44	operator+(const Matrix44 &);
	Matrix44	operator-(const Matrix44 &); 
	Matrix44	operator-(); 
	Matrix44	operator*(const Matrix44 &);
	Matrix44 	operator*(const double &); 
	Matrix44 	&operator=(const Matrix44 &);
	Matrix44 	&operator+=(const Matrix44 &m);
	Matrix44 	&operator-=(const Matrix44 &m);
	Matrix44 	&operator*=(const Matrix44 &m);
	Matrix44	&operator*=(const double &d);
	double		&operator()(int,int); 
	double		operator()(int,int) const; 
	Matrix44	operator~();
	void		unify();
	Matrix44	&scaleVector(Vector3&);
	Matrix44	&transposeVector(Vector3&);
	Matrix44	&rotateVector(Vector3&);

	void		print()
	{
		int	x,y;

		for(y = 0;y < 4;y++)
		{
			for(x = 0;x < 4;x++)
				printf("%f\t",elements[y][x]);
			printf("\n");
		}
	}
};

class Vector4
{
	friend class Matrix44;
	friend class Vector3;
	friend class Vector2;
protected:
	double		elements[4];
 
public:
	Vector4(); 
	Vector4(double,double,double,double); 
	Vector4(Vector4 &); 
	Vector4(Vector3 &); 
	Vector4(Vector2 &); 

	Vector4		operator+(const Vector4 &); 
	Vector4		operator-(const Vector4 &); 
	Vector4 	operator*(const Matrix44 &); 
	Vector4 	operator*(const double &); 
	Vector4 	operator/(const double &); 
	Vector4 	&operator=(const Vector4 &); 
	Vector4 	&operator+=(const Vector4 &);
	Vector4 	&operator-=(const Vector4 &);
	Vector4		&operator*=(const Matrix44 &);
	Vector4		&operator*=(const double &);
	Vector4		&operator/=(const double &);
	double		&operator()(int); 
	Vector4		operator-(); 
	void		normalize();
	double		length();
	double		scalarprod(const Vector4 &);

	void		print()
	{
		printf("%f\t%f\t%f\t%f\n",elements[0],elements[1],elements[2],elements[3]);
	}
};


class Vector3
{
	friend class Vector4;
	friend class Vector2;
protected:
	double		elements[3];
 
public:
	Vector3(); 
	Vector3(double,double,double); 
	Vector3(Vector4 &); 
	Vector3(Vector3 &); 
	Vector3(Vector2 &); 

	Vector3		operator+(const Vector3 &); 
	Vector3		operator-(const Vector3 &); 
	Vector3		operator-(); 
	Vector3		operator*(const Vector3 &); 
	Vector3 	operator*(const double &); 
	Vector3 	operator/(const double &); 
	Vector3 	&operator=(const Vector3 &); 
	Vector3 	&operator+=(const Vector3 &m);
	Vector3 	&operator-=(const Vector3 &m);
	Vector3 	&operator*=(const Vector3 &m);
	Vector3		&operator*=(const double &d);
	Vector3		&operator/=(const double &d);
	double		&operator()(int); 
	double		&operator[](int); 
	void		normalize();
	double		length();
	double		scalarprod(const Vector3 &);

	void		print()
	{
		printf("%f\t%f\t%f\n",elements[0],elements[1],elements[2]);
	}
};
	

class Vector2
{
	friend class Vector4;
	friend class Vector3;
protected:
	double		elements[2];
 
public:
	Vector2(); 
	Vector2(double,double); 
	Vector2(Vector4 &); 
	Vector2(Vector3 &); 
	Vector2(Vector2 &); 

	Vector2		operator+(const Vector2 &); 
	Vector2		operator-(const Vector2 &); 
	Vector2		operator-(); 
	Vector2 	operator*(const double &); 
	Vector2 	operator/(const double &); 
	Vector2 	&operator=(const Vector2 &); 
	Vector2 	&operator+=(const Vector2 &m);
	Vector2 	&operator-=(const Vector2 &m);
	Vector2		&operator*=(const double &d);
	Vector2		&operator/=(const double &d);
	double		&operator()(int); 
	void		normalize();
	double		length();
	double		scalarprod(const Vector2 &);

	void		print()
	{
		printf("%f\t%f\n",elements[0],elements[1]);
	}
};

#endif
