#ifndef __WORLDTREE__
#define __WORLDTREE__

#include <qwidget.h>
#include <qpixmap.h>
#include <qpopmenu.h>
//#include <ktreelist.h>
#include <qlistview.h>

#include <objects.h>
#include <texture.h>
#include <view.h>

class TreeListItem : public QListViewItem
{
public:

	TreeListItem(QListView *p,int h) :
		QListViewItem(p)
	{
		setHeight(h);
	}
	TreeListItem(QListView *p,const char* t1,int h) :
		QListViewItem(p,t1)
	{
		setHeight(h);
	}
	TreeListItem(QListViewItem *p,int h) :
		QListViewItem(p)
	{
		setHeight(h);
	}
	TreeListItem(QListViewItem *p,const char* t1,int h) :
		QListViewItem(p,t1)
	{
		setHeight(h);
	}

	void		setHeight(int h)
	{
		QListViewItem::setHeight(h);
	}

	void		setup(){}
/*
	const char	*key(int,bool)
	{
		return " ";
	}
*/	
};

class TreeList : public QListView
{
Q_OBJECT
public:
	TreeList(QWidget *p,char* n=NULL) :
		QListView(p,n)
	{};
	~TreeList() {};

	void addChildItem(QListViewItem *p,QListViewItem *c)
	{
		p->insertItem(c);
	}
	QListViewItem*	getRoot()
	{
		return firstChild();
	}
	void	addToRoot(QListViewItem *nr)
	{
		addChildItem(getRoot(),nr);
	}

protected:
	void	mouseReleaseEvent(QMouseEvent *re)
	{
		if(re->button() == RightButton)
		{
			QListViewItem	*li;

			li = currentItem();

			if(li)
			{
				emit popupMenu(li,re->x(),re->y());
				return;
			}
		}
		QListView::mouseReleaseEvent(re);
	}

signals:
	void	popupMenu(QListViewItem*,int,int);
};

class WorldTree : public QWidget
{
	Q_OBJECT

protected:
	TreeList	*treelist;

	QPixmap		*pixmap[50];

	world		*w;
	base		*cap;

public:
	WorldTree(QWidget*,char *name = 0L);
	~WorldTree();

	int	load(char*);
	int	save(char*);
	int	empty();

	void	dump();

	void	draw();

	int	exportPOV(char *fn,view*);

	int	addX(base*);

	void	addObject();
	void	addCSG();
	void	addBlob();
	void	addRef();
	void	addSphere();
	void	addCylinder();
	void	addBox();
	void	addMesh();
	void	addCone();
	void	addPlane();
	void	addTorus();
	void	addRefPtr();
	void	addTriangle();
	void	addHeightfield();

	void	addLightPoint();
	void	addSpotLight();
	void	addAreaLight();

private:
	void	layout();

	void	createWidgets();
	void	createTree();
	void	createTree(base *,QListViewItem*,int);

	void	paintEvent(QPaintEvent *);

public slots:
	void	popupMenu(QListViewItem*,int,int);
	void	rename(QListViewItem*,const char *newname);
	void	remove(QListViewItem*);
	void	cut(QListViewItem*);
	void	paste(QListViewItem*);
	void	getSelected(QListViewItem*);
	void	setTexture(texture*);

signals:

	void	redraw();
	void	setWorld(world*);
	void	setSelected(base*);

};

#endif

