#include <klocale.h>


#define stloc(a)	((char*)klocale->translate((a)))

#include <qpoint.h>

#include "dialogs.h"

#include "worldtree.h"
#include "worldtree.moc"

#include "objects.h"

#include "icons/x.xpm"

#include "icons/world.xpm"
#include "icons/obj.xpm"
#include "icons/csg.xpm"
#include "icons/blob.xpm"
#include "icons/box.xpm"
#include "icons/sphere.xpm"
#include "icons/cylinder.xpm"
#include "icons/cone.xpm"
#include "icons/torus.xpm"
#include "icons/mesh.xpm"
#include "icons/text.xpm"
#include "icons/script.xpm"
#include "icons/heightfield.xpm"
#include "icons/plane.xpm"
#include "icons/ref.xpm"
#include "icons/refptr.xpm"
#include "icons/lightpoint.xpm"
#include "icons/spotlight.xpm"
#include "icons/arealight.xpm"

WorldTree::WorldTree(QWidget *p,char *name) :
	QWidget(p,name)
{
	int		t;

	cap = NULL;

	createWidgets();

	for(t = 0;t < 50;t++) 
	{
		if(t == NUM_WORLD) pixmap[t] = new QPixmap(world_xpm);
		else if(t == NUM_OBJ) pixmap[t] = new QPixmap(obj_xpm);
		else if(t == NUM_CSG) pixmap[t] = new QPixmap(csg_xpm);
		else if(t == NUM_BLOB) pixmap[t] = new QPixmap(blob_xpm);
		else if(t == NUM_SPHERE) pixmap[t] = new QPixmap(sphere_xpm);
		else if(t == NUM_CYLINDER) pixmap[t] = new QPixmap(cylinder_xpm);
		else if(t == NUM_BOX) pixmap[t] = new QPixmap(box_xpm);
		else if(t == NUM_CONE) pixmap[t] = new QPixmap(cone_xpm);
		else if(t == NUM_TORUS) pixmap[t] = new QPixmap(torus_xpm);
		else if(t == NUM_MESH) pixmap[t] = new QPixmap(mesh_xpm);
		else if(t == NUM_PLANE) pixmap[t] = new QPixmap(plane_xpm);
		else if(t == NUM_TEXT) pixmap[t] = new QPixmap(text_xpm);
		else if(t == NUM_SCRIPT) pixmap[t] = new QPixmap(script_xpm);
		else if(t == NUM_HEIGHTFIELD) pixmap[t] = new QPixmap(heightfield_xpm);
		else if(t == NUM_REF) pixmap[t] = new QPixmap(ref_xpm);
		else if(t == NUM_REFPTR) pixmap[t] = new QPixmap(refptr_xpm);
		else if(t == NUM_SPOTLIGHT) pixmap[t] = new QPixmap(spotlight_xpm);
//		else if(t == NUM_AREALIGHT) pixmap[t] = new QPixmap(arealight_xpm);
		else if(t == NUM_LIGHTPOINT) pixmap[t] = new QPixmap(lightpoint_xpm);
		else pixmap[t] = new QPixmap(x_xpm);
	}

	layout();
	empty();
}

WorldTree::~WorldTree()
{
	if(w) delete w;

	if(cap) delete cap;

//?	if(treelist) delete treelist;
}

void	WorldTree::createWidgets()
{
	treelist = new TreeList(this);

/*
	treelist->setShowItemText(TRUE);
	treelist->setTreeDrawing(TRUE);
	treelist->setSmoothScrolling(TRUE);
	treelist->setScrollBar(TRUE);
	treelist->setBottomScrollBar(TRUE);
*/
	treelist->addColumn("Object tree",120);
	treelist->addColumn("Texture",120);
	treelist->addColumn("Sort",1);
	treelist->setColumnWidthMode(0,QListView::Maximum);
	treelist->setColumnWidthMode(1,QListView::Maximum);
	treelist->setColumnWidthMode(2,QListView::Manual);
	treelist->setMultiSelection(FALSE);
	treelist->setSorting(2,TRUE);

	connect(treelist,SIGNAL(popupMenu(QListViewItem*,int,int)),this,SLOT(popupMenu(QListViewItem*,int,int)));
	connect(treelist,SIGNAL(selectionChanged(QListViewItem*)),this,SLOT(getSelected(QListViewItem*)));

	layout();
}

void	WorldTree::createTree()
{
	treelist->clear();
	
	createTree(w,NULL,0);

	treelist->repaint(TRUE);
//	treelist->show();
}

void	WorldTree::createTree(base *b,QListViewItem *pit,int num)
{
	base		**children = NULL;
	int		t;
	TreeListItem	*li;
	char		str[16];

	if(!b) return;

	if(!pit)
		li = new TreeListItem((QListView*)treelist,b->getName(),20);
	else
		li = new TreeListItem(pit,b->getName(),20);

	if(!li) return;

	if(!pit)
	{
		li->setOpen(TRUE);
	}
	else
	{
		pit->setExpandable(TRUE);
	}
	li->setHeight(20);

	li->setPixmap(0,*pixmap[b->getType()]);

	if(b->getType() != NUM_WORLD && b->getType() != NUM_REF)
	{
		if(((body*)b)->getTexture())
			li->setText(1,((body*)b)->getTexture()->getName());
	}

	sprintf(str,"%i",num);
	li->setText(2,str);

	b->getChildren(&children);
	if(!children)	return;

	t = 0;
	while(children[t])
	{
		createTree(children[t],li,t);
		t++;
	}
	if(children) free(children);
}

void	WorldTree::layout()
{
	int	w,h;

	w = width();
	h = height();

	treelist->resize(w,h);
}

void	WorldTree::draw()
{
	layout();
	treelist->repaint();
}

int	WorldTree::exportPOV(char *filename,view *v)
{
	FILE	*fp; 
	int	error;

	fp = fopen(filename,"wb"); 
 
	if(fp == NULL) return -3;

	error = v->exportPOV(fp,4);
	error = w->exportPOV(fp,0,4);

	fclose(fp); 

	return error;
}

int	WorldTree::save(char *filename)
{
	int	error;
	world	x;

	error = x.save3DDS(filename,w);

	return error;
}

int	WorldTree::load(char *filename)
{
	world	x;
	int	error;
	base	*b;

	error = x.load3DDS(filename,&b); 

	if(!b) return error;

	if(b->getType() == NUM_WORLD)
	{
		empty();
		delete w;
		w = (world*)b;
		w->setParent(NULL); 
		emit setWorld(w);
	}
 	else delete b;

	createTree();

	draw();

	return error;
}

int	WorldTree::empty()
{
	if(w) delete w;
	w = new world("World");
	createTree();

	emit setWorld(w);
	emit redraw();

	return 0;
}

void	WorldTree::paintEvent(QPaintEvent *pe)
{
	if(pe == NULL) return;

	layout();
}

void	WorldTree::dump()
{
	w->dumpNames(0,4);
}

int	WorldTree::addX(base *child)
{
	QListViewItem	*i;
	QListViewItem	*li;
	base		*b;
	char		*n;

	if(!child) return -5;

	n = w->createName((char*)child->getName());
	if(!n)
	{
		delete child;
		return -4;
	}
	child->setName(n);

	if(!(i = treelist->currentItem()))
	{
		delete child;
		return -3;
	}

	if(!(b = w->searchName((char*)i->text(0))))
	{
		delete child;
		return -2;
	}

	if(child->addToParent(b) != 0)
	{
		delete child;
		return -1;
	}

	li = new TreeListItem(i,child->getName(),20);
	li->setPixmap(0,*pixmap[child->getType()]);
	i->setOpen(TRUE);

	emit redraw();

	return 0;
}

void	WorldTree::addObject()
{
	addX(new obj(NULL,"Object"));
}

void	WorldTree::addCSG()
{
	addX(new csg(NULL,"CSGObject"));
}

void	WorldTree::addBlob()
{
	addX(new blob(NULL,"Blob"));
}

void	WorldTree::addRef()
{
	addX(new ref(NULL,"ReferenceObject"));
}

void	WorldTree::addSphere()
{
	addX(new sphere(NULL,"Sphere"));
}

void	WorldTree::addCylinder()
{
	addX(new cylinder(NULL,"Cylinder"));
}

void	WorldTree::addBox()
{
	addX(new box(NULL,"Box"));
}

void	WorldTree::addMesh()
{
	addX(new mesh(NULL,"Mesh"));
}

void	WorldTree::addRefPtr()
{
	addX(new refptr(NULL,"Reference"));
}

void	WorldTree::addPlane()
{
	addX(new plane(NULL,"Plane"));
}

void	WorldTree::addCone()
{
	addX(new cone(NULL,"Cone"));
}

void	WorldTree::addTorus()
{
	addX(new torus(NULL,"Torus"));
}

void	WorldTree::addHeightfield()
{
	addX(new heightfield(NULL,"HeightField"));
}

void	WorldTree::addTriangle()
{
	addX(new triangle(NULL,"Triangle"));
}

void	WorldTree::addSpotLight()
{
	addX(new spotlight(NULL,"Spotlight"));
}

void	WorldTree::addAreaLight()
{
	//addX(new arealight(NULL,"Arealight"));
}

void	WorldTree::addLightPoint()
{
	addX(new lightpoint(NULL,"Lightpoint"));
}

void	WorldTree::popupMenu(QListViewItem *li,int x,int y)
{
	base		*b;
	QPopupMenu	*pm;
	QPoint		mp = mapToGlobal(QPoint(x,y));
	int		id;

	b = w->searchName((char*)li->text(0));

	if(!b)
	{
		printf("Object %s not found\n",li->text(0));
		return;
	}

	pm = new QPopupMenu();
	pm->insertItem("Rename",1);

	switch(b->getType())
	{
		case NUM_WORLD:
			pm->insertItem("Paste",21);
			pm->setItemEnabled(21,!(!cap));		
		break;
		case NUM_REF:
			pm->insertItem("Cut",20);
			pm->insertItem("Paste",21);
			pm->setItemEnabled(21,!(!cap));		
			pm->insertSeparator();
			id = pm->insertItem("Hide",25);
			if(b->isFlag(base::HIDE))
				pm->setItemChecked(id,!0);
		break;
		case NUM_OBJ:
		case NUM_CSG:
		case NUM_BLOB:
			pm->insertItem("Cut",20);
			pm->insertItem("Paste",21);
			pm->setItemEnabled(21,!(!cap));		
			pm->insertSeparator();
			id = pm->insertItem("Hide",25);
			if(b->isFlag(base::HIDE))
				pm->setItemChecked(id,!0);
			pm->insertSeparator();
			pm->insertItem("Dim",3);
		break;
		default:
			pm->insertItem("Cut",20);
			pm->insertSeparator();
			id = pm->insertItem("Hide",25);
			if(b->isFlag(base::HIDE))
				pm->setItemChecked(id,!0);
			pm->insertSeparator();
			pm->insertItem("Dim",3);
	}


	switch(b->getType())
	{
		case NUM_CONE:
			pm->insertSeparator();
			pm->insertItem("Cone",4);
		break;
		case NUM_TORUS:
			pm->insertSeparator();
			pm->insertItem("Torus",5);
		break;
		case NUM_REFPTR:
			pm->insertSeparator();
			pm->insertItem("Reference",6);
		break;
		case NUM_CSG:
			pm->insertSeparator();
			id = pm->insertItem("Union",11);
			if(((csg*)b)->getCSGType() == csg::UNION)
				pm->setItemChecked(id,!0);
			id = pm->insertItem("Merge",12);
			if(((csg*)b)->getCSGType() == csg::MERGE)
				pm->setItemChecked(id,!0);
			id = pm->insertItem("Intersection",13);
			if(((csg*)b)->getCSGType() == csg::INTERSECTION)
				pm->setItemChecked(id,!0);
			id = pm->insertItem("Difference",14);
			if(((csg*)b)->getCSGType() == csg::DIFFERENCE)
				pm->setItemChecked(id,!0);
			id = pm->insertItem("Invert",15);
			if(((csg*)b)->getCSGType() == csg::INVERT)
				pm->setItemChecked(id,!0);
		break;
		case NUM_BLOB:
			pm->insertSeparator();
			pm->insertItem("Blob",8);
		break;
		case NUM_TRIANGLE:
			pm->insertSeparator();
			pm->insertItem("Triangle",9);
		break;
		case NUM_HEIGHTFIELD:
			pm->insertSeparator();
			pm->insertItem("Heightfield",10);
		break;
		case NUM_LIGHTPOINT:
			pm->insertSeparator();
			pm->insertItem("Lightpoint",16);
		break;
		case NUM_SPOTLIGHT:
			pm->insertSeparator();
			pm->insertItem("Spotlight",17);
		break;
		case NUM_AREALIGHT:
			pm->insertSeparator();
			pm->insertItem("Arealight",18);
		break;
	}

	pm->popup(mp);
	pm->show();
	switch(pm->exec())
	{
		case 1: // rename
		{
			namedialog	*nd;
			QString		s;

			s = b->getName();
			nd = new namedialog(this,"Name");
			nd->setName(s);
			nd->show();
			if(nd->result())
				rename(li,nd->getName());
			delete nd;
		}
		break;
		case 20: // cut
			cut(li);
		break;
		case 21: // paste
			paste(li);
		break;
		case 25: // hide
			b->setFlag(base::HIDE,!(b->isFlag(base::HIDE)));
			emit redraw();
		break;
		case 3: // dim
		{
			dimdialog	*dd;
			Vector3		v[3];

			v[0] = ((dim*)b)->getVScale();
			v[1] = ((dim*)b)->getVRotate();
			v[2] = ((dim*)b)->getVTranslate();

			dd = new dimdialog(this,"Dimensions");

			dd->load(v[0],v[1],v[2]);

			dd->show();
			if(dd->result())
			{
				dd->save(v[0],v[1],v[2]);
				((dim*)b)->getVScale() = v[0];
				((dim*)b)->getVRotate() = v[1];
				((dim*)b)->getVTranslate() = v[2];
			}
			delete dd;
		}
		break;
		case 6: // reference
		{
			namedialog	*nd;
			base		*bt;
			QString		s;

			if(((refptr*)b)->getPTR())
				s = ((refptr*)b)->getPTR()->getName();

			nd = new namedialog(this,"Name of Referenceobject");
			nd->setName(s);
			nd->show();
			if(nd->result())
			{
				bt = w->searchName(nd->getName().data());
				if(bt && bt->getType() == NUM_REF)
				{
					if(bt->addToParent(b) == 0)
					{
						QListViewItem *tli;

						while(li->childCount())
						{
							tli = li->firstChild();
							li->removeItem(tli);
							delete tli;
						}
						//createTree(bt,li);
					}
				}
			}
			delete nd;
		}
		break;
		case 11: // union
			((csg*)b)->setCSGType(csg::UNION);
		break;
		case 12: // merge
			((csg*)b)->setCSGType(csg::MERGE);
		break;
		case 13: // intersection
			((csg*)b)->setCSGType(csg::INTERSECTION);
		break;
		case 14: // difference
			((csg*)b)->setCSGType(csg::DIFFERENCE);
		break;
		case 15: // invert
			((csg*)b)->setCSGType(csg::INVERT);
		break;
		case 16: // pointlight
		break;
		case 17: // spotlight
		break;
		case 18: // arealight
		break;
	}

	delete pm;
}

void	WorldTree::rename(QListViewItem *li,const char *newname)
{
	base		*b;

	if(w->existsName((char*)newname)) return;

	if(!(b = w->searchName((char*)li->text(0)))) return;
	
	b->setName((char*)newname);
	li->setText(0,b->getName());
	draw();
}

void	WorldTree::remove(QListViewItem *li)
{
	base		*b;
	QListViewItem	*i;

	if(!(b = w->searchName((char*)li->text(0)))) return;

	i = li->parent();

	i->removeItem(li);
	delete li;

	delete b;
}

void	WorldTree::cut(QListViewItem *li)
{
	base		*b;
	QListViewItem	*i;

	if(!(b = w->searchName((char*)li->text(0)))) return;

	if(b->removeFromParent() == 0)
	{
		i = li->parent();

		i->removeItem(li);
		delete li;

		if(cap) delete cap;
		cap = b;
	}	
}

void	WorldTree::paste(QListViewItem *li)
{
	base		*parent,*child;
	QListViewItem	*i = NULL;
	int		num;

	if(!(parent = w->searchName((char*)li->text(0)))) return;

	child = cap;

	if(child)
	{
		if(child->addToParent(parent) != 0)
		{
			delete child;
			return;
		}
		if((i = li->firstChild()))
		{
			while(i->nextSibling())
				i = i->nextSibling();
		}
		if(i)
			num = atoi(i->text(2));
		else
			num = 0;
		createTree(child,li,num);
	}

	cap = NULL;
}

void	WorldTree::getSelected(QListViewItem *li)
{
	base		*b;

	if(!(b = w->searchName((char*)li->text(0)))) return;

	emit setSelected(b);
}

void	WorldTree::setTexture(texture *t)
{
	QListViewItem	*i;
	base		*b;

	if(!(i = treelist->currentItem())) return;

	if(!(b = w->searchName((char*)i->text(0)))) return;

	if(b->getType() != NUM_WORLD &&
		b->getType() != NUM_REF)
	{
		((body*)b)->setTexture(t);
		i->setText(1,t->getName());
	}
}


