#ifndef __VIEWWIDGET__
#define __VIEWWIDGET__

#include <qwidget.h>
#include <qframe.h>
#include <qpainter.h>
#include <qpixmap.h>

#include <view.h>


class ViewWidget : public QWidget  ,public view
{
	Q_OBJECT

protected:

	QColor		backcolor,drawcolor,selcolor,boxcolor,gridcolor;
	QPainter	*qp;
	int		viewmode;
	int		xo,yo;

public:

	ViewWidget(QWidget*p=0,char*n=0);
	~ViewWidget();



	int		drawLine(Vector3,Vector3,Matrix44,QColor);
	int		drawLine(Vector3,Vector3,Matrix44);
	int		drawCross(Vector3,Matrix44);
	int		drawTriangle(Vector3,Vector3,Vector3,Matrix44);
	int		drawTrapezium(Vector3,Vector3,Vector3,Matrix44);
	int		drawCircle(Vector3,Vector3,Vector3,Matrix44);
	int		drawSemiCircle(Vector3,Vector3,Vector3,Matrix44);
	int		drawSymbol(Vector3,const char *,Matrix44);

	int		drawSphere(Vector3,Vector3,Vector3,Vector3,Matrix44);
	int		drawSemiSphere(Vector3,Vector3,Vector3,Vector3,Matrix44);
	int		drawBox(Vector3,Vector3,Vector3,Vector3,Matrix44);
	int		drawCone(Vector3,Vector3,Vector3,Vector3,double,Matrix44);
	int		drawCylinder(Vector3,Vector3,Vector3,Vector3,Matrix44);
	int		drawTorus(Vector3,Vector3,Vector3,Vector3,double,Matrix44);


	int		drawIcon(Vector3,QPixmap,int,int,Matrix44);

protected:
	virtual void	paintEvent(QPaintEvent*);
	void		mouseMoveEvent(QMouseEvent*);
	void		mousePressEvent(QMouseEvent*);

signals:

	void		selected(char *name);

public slots:

	void		draw();
	void		setWorld(world *);

	void		rotateView(double,double,double);
	void		rotate0View(double,double,double);
	void		moveView(double,double,double);
	void		changeFOV(double);

	void		setViewMode(int);
	void		setProjectionMode(int);

	void		setSelected(base *bp);

protected:

	void		setColor(int )
	{
		qp->setPen(drawcolor);
	}

};


#endif

