#ifndef __TEXTURETABLE__
#define __TEXTURETABLE__

#include "selecttable.h"
#include "texture.h"

class TextureTable;

class TextureTableItem : public SelectTableItem
{
protected:

	const texture	*texptr;

public:

	TextureTableItem(TextureTable *parent,int id=-1,const char *title=0,QPixmap &p=0,texture *t=0) :
		SelectTableItem((SelectTable*)parent,id,title,p)
	{
		texptr = t;
	}
	~TextureTableItem()
	{
	}

	void		setTexture(const texture *t)
	{
		texptr = t;
	}
	const texture	*getTexture() const
	{
		return texptr;
	}
};

class TextureTable : public SelectTable
{
Q_OBJECT

public:

	TextureTable(QWidget *parent = 0,const char *name = 0,WFlags f=0);
	~TextureTable();

	bool			insertItem(TextureTableItem *);
	TextureTableItem	*item(int id);

signals:

	void			setTexture(texture *);

private slots:

	void			selectedTexture(int);

};


#endif


