#include "texturetable.h"
#include "texturetable.moc"

TextureTable::TextureTable(QWidget *parent,const char *name,WFlags f) :
	SelectTable(parent,name,f)
{
	connect(this,SIGNAL(selected(int)),this,SLOT(selectedTexture(int)));

	// scandir("data/texture");

	//new TextureTableItem(this,-1,"Crackle",* new QPixmap("data/texture/crackle.ppm"),new texture("red",1,0,0));
	//new TextureTableItem(this,-1,"Marble",* new QPixmap("data/texture/marble.ppm"),new texture("blue",0,0,1));
}

TextureTable::~TextureTable()
{
}

bool		TextureTable::insertItem(TextureTableItem *i)
{
	bool	ok;

	ok = itemlist.insert(i->id(),i);

	if(ok)
	{
		if((unsigned)(numRows() * numCols()) < itemlist.count())
		{
			if(numCols() * cellWidth() < width())
			{
				setNumCols(numCols() + 1);
				return ok;
			}
			if(numRows() * cellHeight() < height())
			{
				setNumRows(numRows() + 1);
				return ok;
			}
			if(numRows() < numCols())
			{
				setNumRows(numRows() + 1);
			}
			else
			{
				setNumCols(numCols() + 1);
			}
		}
	}

	return ok;
}

TextureTableItem	*TextureTable::item(int i)
{
	TextureTableItem	*tti;

	printf("itemlist: %i\n",itemlist.count());

	tti = (TextureTableItem*)itemlist.first();
	while(tti)
	{
		printf("item: (%i) = (%i)\n",i,tti->id());

		if(tti->id() == i) return tti;
		tti = (TextureTableItem*)itemlist.next();
	}

	return NULL;
}

void	TextureTable::selectedTexture(int i)
{
	TextureTableItem	*tti;
	texture			*t;

	printf("%i\n",i);

	tti = item(i);

	if(tti)
	{
		t = tti->getTexture();
		emit setTexture(t);
	}
}
