#include <stdio.h>
#include <stdlib.h>
#include <unistd.h>
#include <sys/types.h>
#include <signal.h>
#include <sys/wait.h>
#include <sys/stat.h>
#include <fcntl.h>

#include <kapp.h>
#include <qcombo.h>
#include <qpixmap.h>
#include <qframe.h>
#include <qpainter.h>

#define READ	0
#define WRITE	1

class MyWidget : public QFrame
{
protected:
	QPainter	*qp;
	char		*com;
	int		x,y,r;

	int		pid;

	int		fd[2],fin;

public:
	MyWidget(char *command,QWidget *parent=0, const char *name=0);
	~MyWidget();

	void	start();
	void	stop();

	void	timerEvent(QTimerEvent*);
};

MyWidget::MyWidget(char *command,QWidget *parent, const char *name):
	QFrame(parent,name)
{
	qp = new QPainter(this);

	if(command) com = strdup(command);
	else com = strdup("povray -W%i -H%i -O- -FP -I./preview.pov -GA");
}

MyWidget::~MyWidget()
{
	delete qp;
	free(com);
}

void	MyWidget::start()
{
	char	*t,*args[256];
	int	k;
	char	tmpstr[2048];

	//remove("./preview.ppm");

	r = x = y = 0;

	if(pipe(fd) != 0)
	{
		printf("pipe failed\n");
		return;
	}

	sprintf(tmpstr,com,width(),height());

	//printf("start with command: %s\n",tmpstr);

	for(t=strtok(tmpstr," "),k=0;t!=NULL;t=strtok(NULL," "),k++)
	{
		args[k]=strdup(t); 
//		printf("stsrt: %s\n",args[k]);
	}
	
	args[k]=NULL;
	switch(pid=fork())
	{
		case 0: 
			close(fd[READ]);
			close(1);
			dup(fd[WRITE]);
			close(fd[WRITE]);
			sleep(1);
			execvp(args[0],args);
			printf("Programm konnte nicht ausgefhrt werden !\n");
			exit(-1);
		break;
		case -1: 
			printf("Fork failed !\n");
		break;
		default:
			//waitpid(pid,NULL,0);
			//printf("Childp. fertig !\n");
			close(fd[WRITE]);
			//fcntl(fd[READ],F_SETFL,O_NONBLOCK);
			//usleep(100);
			startTimer(250);
			//system("ps > result.txt");
		break;
	} // End of switch(pid)
}

void	MyWidget::stop()
{
	printf("stoped\n");

	kill(pid,9);
	waitpid(pid,NULL,0);
	killTimers();

	//close(fin);
	close(fd[READ]);
}

void	MyWidget::timerEvent(QTimerEvent *te)
{
	int		l,t;
	char	buffer[3000],*cp;
	QColor		c;

	t = 0;

	//if(r == 0) fin = open("preview.ppm",O_RDONLY | O_NONBLOCK);

	//l = fread(buffer,3000,1,stdin);
	//l = read(fin,buffer,3000);
	l = read(fd[READ],buffer,300);
	
//	if(l > 0) fwrite(buffer,1,l,stdout);

/*
	if(l > 0 && r == 0)
	{
		cp = buffer;
		while(*cp == '#')
		{
			cp = strchr(cp,'\n');
			cp++;
		}
		cp = strchr(cp,'\n');
		cp = strchr(cp,'\n');
		cp = strchr(cp,'\n');
		cp++;

		t = cp - buffer;
	}
*/
	for(;t < l;t+=3)
	{
		unsigned char	*ubuffer = (unsigned char*)buffer;

		c.setRgb(ubuffer[t],ubuffer[t + 1],ubuffer[t + 2]);

		qp->setPen(c);
		qp->drawPoint(x,y);
		if(++x == width())
		{
			x = 0;	
			if(++y == height())
			{
				stop();
				return;
			}
		}
	}
	r += l;
}


int main(int argc, char **argv)
{

	KApplication a(argc, argv);
	MyWidget w ("strace povray -W%i -H%i Output_File_Name=- -I./preview.pov -GA");
	//MyWidget w ("ls -l");

	w.resize(200,200);

	a.setMainWidget(&w);
	w.show();
	
	w.start();

	return a.exec();
}
