#include <stdio.h>
#include <stdlib.h>
#include <unistd.h>
#include <sys/types.h>
#include <signal.h>
#include <sys/wait.h>
#include <sys/stat.h>
#include <fcntl.h>

#include <kapp.h>
#include <qcombo.h>
#include <qpixmap.h>
#include <qframe.h>
#include <qpainter.h>

#define READ	0
#define WRITE	1

class MyWidget : public QFrame
{
protected:
	QPainter	*qp;
	char		*com;
	int		x,y,r;

	int		pid;

	int		fin;

public:
	MyWidget(char *command,QWidget *parent=0, const char *name=0);
	~MyWidget();

	void	start();
	void	stop();

	void	timerEvent(QTimerEvent*);
};

MyWidget::MyWidget(char *command,QWidget *parent, const char *name):
	QFrame(parent,name)
{
	qp = new QPainter(this);

	if(command) com = strdup(command);
	else com = strdup("povray -W%i -H%i -O- -FP -I./preview.pov -GA");
}

MyWidget::~MyWidget()
{
	delete qp;
	free(com);
}

void	MyWidget::start()
{
	char	*t,*args[256];
	int	k;
	char	tmpstr[2048];

	remove("./preview.ppm");

	r = x = y = 0;

	sprintf(tmpstr,com,width(),height());

	//printf("start with command: %s\n",tmpstr);

	for(t=strtok(tmpstr," "),k=0;t!=NULL;t=strtok(NULL," "),k++)
	{
		args[k]=strdup(t); 
//		printf("stsrt: %s\n",args[k]);
	}
	
	args[k]=NULL;
	switch(pid=fork())
	{
		case 0: 
			execvp(args[0],args);
			printf("Programm konnte nicht ausgefhrt werden !\n");
			exit(-1);
		break;
		case -1: 
			printf("Fork failed !\n");
		break;
		default:
			usleep(300);
			startTimer(250);
		break;
	} // End of switch(pid)
}

void	MyWidget::stop()
{
	printf("stoped\n");

	kill(pid,9);
	waitpid(pid,NULL,0);
	killTimers();

	close(fin);
}

void	MyWidget::timerEvent(QTimerEvent *te)
{
	int		l,t;
	char	buffer[3000],*cp;
	QColor		c;

	t = 0;

	if(r == 0) fin = open("./preview.ppm",O_RDONLY | O_NONBLOCK);

	l = read(fin,buffer,3000);
	

	if(l > 0 && r == 0)
	{
		cp = buffer;
		while(*cp == '#')
		{
			cp = strchr(cp,'\n');
			cp++;
		}
		cp = strchr(cp,'\n');
		cp = strchr(cp,'\n');
		cp = strchr(cp,'\n');
		cp++;

		t = cp - buffer;
	}

	for(;t < l;t+=3)
	{
		unsigned char	*ubuffer = (unsigned char*)buffer;

		c.setRgb(ubuffer[t],ubuffer[t + 1],ubuffer[t + 2]);

		qp->setPen(c);
		qp->drawPoint(x,y);
		if(++x == width())
		{
			x = 0;	
			if(++y == height())
			{
				stop();
				return;
			}
		}
	}
	r += l;
}


int main(int argc, char **argv)
{

	KApplication a(argc, argv);
	MyWidget w ("povray -W%i -H%i +FP -Opreview.ppm -Ipreview.pov -GA");
	//MyWidget w ("ls -l");

	w.resize(200,200);

	a.setMainWidget(&w);
	w.show();
	
	w.start();

	return a.exec();
}
