#include "selecttable.h"

SelectTableItem::SelectTableItem(SelectTable *parent,int i=-1,const char *title=0,QPixmap &p=0)
{
	if(i < 0)
		nid = parent->maxID() + 1;
	else
		nid = i;

	txt = title;
	pmap = p;

	parent->insertItem(this);
}

SelectTableItem::~SelectTableItem()
{
}

void		SelectTableItem::setText(const char *t)
{
	txt = t;
}

const char	*SelectTableItem::text() const
{
	return txt;
}

void		SelectTableItem::setPixmap(const QPixmap &p)
{
	pmap = p;
}

const QPixmap	*SelectTableItem::pixmap() const
{
	return &pmap;
}

const QPixmap	&SelectTableItem::getPixmap() const
{
	return pmap;
}

int		SelectTableItem::id()
{
	return nid;
}


